/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings;

import fuzs.fantasticwings.commands.WingsCommand;
import fuzs.fantasticwings.config.ServerConfig;
import fuzs.fantasticwings.flight.apparatus.FlightApparatusImpl;
import fuzs.fantasticwings.handler.ServerEventHandler;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.network.ServerboundControlFlyingMessage;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.event.v1.entity.EntityRidingEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.api.event.v1.server.RegisterCommandsCallback;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import fuzs.puzzleslib.api.network.v3.NetworkHandlerV3;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FantasticWings
implements ModConstructor {
    public static final String MOD_ID = "fantasticwings";
    public static final String MOD_NAME = "Fantastic Wings";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Fantastic Wings");
    public static final NetworkHandlerV3 NETWORK = NetworkHandlerV3.builder((String)"fantasticwings").registerServerbound(ServerboundControlFlyingMessage.class);
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"fantasticwings").server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        FantasticWings.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        RegisterCommandsCallback.EVENT.register(WingsCommand::register);
        EntityRidingEvents.START.register(ServerEventHandler::onStartRiding);
        PlayerTickEvents.END.register(ServerEventHandler::onEndPlayerTick);
        PlayerInteractEvents.ATTACK_ENTITY.register(ServerEventHandler::onAttackEntity);
    }

    public void onCommonSetup() {
        FlightApparatusImpl.forEach(FlightApparatusImpl::registerBrewingRecipes);
    }

    public void onRegisterCreativeModeTabs(CreativeModeTabContext context) {
        context.registerCreativeModeTab(CreativeModeTabConfigurator.from((String)MOD_ID).icon(() -> PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)FlightApparatusImpl.MONARCH_BUTTERFLY.getPotion())).icons(() -> (ItemStack[])Stream.of(FlightApparatusImpl.values()).map(flightApparatus -> PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)flightApparatus.getPotion())).toArray(ItemStack[]::new)).displayItems((itemDisplayParameters, output) -> {
            output.m_246342_(PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)((Potion)ModRegistry.BAT_BLOOD_POTION.m_203334_())));
            FlightApparatusImpl.forEach(flightApparatus -> output.m_246342_(PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)flightApparatus.getPotion())));
        }));
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

