/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.flight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.fantasticwings.client.animator.Animator;
import fuzs.fantasticwings.client.animator.state.State;
import fuzs.fantasticwings.client.animator.state.StateIdle;
import fuzs.fantasticwings.client.flight.apparatus.WingForm;
import fuzs.fantasticwings.flight.FlightCapability;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import java.util.function.Consumer;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public final class FlightViewCapability
extends CapabilityComponent<AbstractClientPlayer> {
    private WingState animator = PresentWingState.VOID;

    public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
        this.animator.ifFormPresent(consumer);
    }

    public void tick() {
        this.animator = WingForm.get(this.getFlight().getWings().flightApparatus()).map(view -> this.animator.next((WingForm<?>)view)).orElseGet(this.animator::nextAbsent);
        this.animator.update(this.getFlight(), (Player)this.getHolder());
    }

    public boolean resetEyeHeight() {
        return this.getFlight().isFlying() || this.getFlight().getFlyingAmount(1.0f) > 0.0f && ((AbstractClientPlayer)this.getHolder()).m_20089_() == Pose.FALL_FLYING;
    }

    public FlightCapability getFlight() {
        return (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)((Player)this.getHolder()));
    }

    private record PresentWingState(WingForm<?> wing, Strategy behavior) implements WingState
    {
        static final WingState VOID = new WingState(){

            @Override
            public WingState nextAbsent() {
                return this;
            }

            @Override
            public WingState next(WingForm<?> form) {
                return PresentWingState.newState(form);
            }

            @Override
            public void update(FlightCapability flight, Player player) {
            }

            @Override
            public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
            }
        };

        @Override
        public WingState nextAbsent() {
            return VOID;
        }

        @Override
        public WingState next(WingForm<?> form) {
            if (this.wing.equals(form)) {
                return this;
            }
            return PresentWingState.newState(form);
        }

        @Override
        public void update(FlightCapability flight, Player player) {
            this.behavior.update(flight, player);
        }

        @Override
        public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
            this.behavior.ifFormPresent(consumer);
        }

        public static <T extends Animator> WingState newState(WingForm<T> shape) {
            return new PresentWingState(shape, new WingStrategy<T>(shape));
        }

        private static class WingStrategy<T extends Animator>
        implements Strategy {
            private final WingForm<T> shape;
            private final T animator;
            private State state;

            public WingStrategy(WingForm<T> shape) {
                this.shape = shape;
                this.animator = shape.createAnimator();
                this.state = new StateIdle();
            }

            @Override
            public void update(FlightCapability flight, Player player) {
                this.animator.update();
                State state = this.state.update(flight, player.m_20185_() - player.f_19854_, player.m_20186_() - player.f_19855_, player.m_20189_() - player.f_19856_, player);
                if (!this.state.equals(state)) {
                    state.beginAnimation((Animator)this.animator);
                }
                this.state = state;
            }

            @Override
            public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
                consumer.accept(new WingForm.FormRenderer(){

                    @Override
                    public ResourceLocation getTexture() {
                        return shape.getTextureLocation();
                    }

                    @Override
                    public void render(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, float delta) {
                        shape.getModel().render(animator, delta, matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                    }
                });
            }
        }
    }

    static interface WingState {
        public WingState nextAbsent();

        public WingState next(WingForm<?> var1);

        public void update(FlightCapability var1, Player var2);

        public void ifFormPresent(Consumer<WingForm.FormRenderer> var1);
    }

    private static interface Strategy {
        public void update(FlightCapability var1, Player var2);

        public void ifFormPresent(Consumer<WingForm.FormRenderer> var1);
    }
}

