/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.fantasticwings.client.audio.WingsSound;
import fuzs.fantasticwings.client.flight.FlightViewCapability;
import fuzs.fantasticwings.client.init.ClientModRegistry;
import fuzs.fantasticwings.flight.FlightCapability;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.util.MathHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ClientEventHandler {
    public static void onAnimatePlayerModel(Player player, PlayerModel<?> model, float ticksExisted, float pitch) {
        float delta;
        FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player);
        float flyingAmount = flightCapability.getFlyingAmount(delta = ticksExisted - (float)player.f_19797_);
        if (flyingAmount != 0.0f) {
            model.f_102808_.f_104203_ = MathHelper.toRadians(MathHelper.lerp(pitch, pitch / 4.0f - 90.0f, flyingAmount));
            model.f_102812_.f_104203_ = MathHelper.lerp(model.f_102812_.f_104203_, -3.2f, flyingAmount);
            model.f_102811_.f_104203_ = MathHelper.lerp(model.f_102811_.f_104203_, -3.2f, flyingAmount);
            model.f_102814_.f_104203_ = MathHelper.lerp(model.f_102814_.f_104203_, 0.0f, flyingAmount);
            model.f_102813_.f_104203_ = MathHelper.lerp(model.f_102813_.f_104203_, 0.0f, flyingAmount);
            model.f_102809_.m_104315_(model.f_102808_);
        }
    }

    public static void onApplyRotations(Player player, PoseStack poseStack, float delta) {
        FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player);
        float amt = flightCapability.getFlyingAmount(delta);
        if (amt > 0.0f) {
            float roll = MathHelper.lerpDegrees(player.f_20884_ - player.f_19859_, player.f_20883_ - player.m_146908_(), delta);
            float pitch = -MathHelper.lerpDegrees(player.f_19860_, player.m_146909_(), delta) - 90.0f;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(MathHelper.lerpDegrees(0.0f, roll, amt)));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(MathHelper.lerpDegrees(0.0f, pitch, amt)));
            poseStack.m_85837_(0.0, -1.2 * (double)MathHelper.easeInOut(amt), 0.0);
        }
    }

    public static void onComputeCameraAngles(GameRenderer renderer, Camera camera, float partialTick, MutableFloat pitch, MutableFloat yaw, MutableFloat roll) {
        LivingEntity cameraEntity = (LivingEntity)camera.m_90592_();
        ModRegistry.FLIGHT_CAPABILITY.getIfProvided((Object)cameraEntity).ifPresent(flightViewCapability -> {
            float flyingAmount = flightViewCapability.getFlyingAmount(partialTick);
            if (flyingAmount > 0.0f) {
                float newRoll = MathHelper.lerpDegrees(cameraEntity.f_20884_ - cameraEntity.f_19859_, cameraEntity.f_20883_ - cameraEntity.m_146908_(), partialTick);
                roll.accept(MathHelper.lerpDegrees(0.0f, -newRoll * 0.25f, flyingAmount));
            }
        });
    }

    public static EventResult onEntityLoad(Entity entity, ClientLevel level) {
        if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)localPlayer);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new WingsSound((Player)localPlayer, flightCapability));
        }
        return EventResult.PASS;
    }

    public static void onEndPlayerTick(Player player) {
        ClientModRegistry.FLIGHT_VIEW_CAPABILITY.getIfProvided((Object)player).ifPresent(FlightViewCapability::tick);
    }

    public static EventResult onRenderOffHand(ItemInHandRenderer itemInHandRenderer, AbstractClientPlayer player, HumanoidArm humanoidArm, ItemStack itemStack, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLight, float partialTick, float interpolatedPitch, float swingProgress, float equipProgress) {
        if (itemStack.m_41619_() && !player.m_150108_() && !player.m_20145_() && !itemInHandRenderer.f_109300_.m_150930_(Items.f_42573_) && ((FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player)).isFlying()) {
            itemInHandRenderer.m_109346_(poseStack, multiBufferSource, combinedLight, equipProgress, swingProgress, player.m_5737_().m_20828_());
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static void onTurn(Entity entity, float deltaYaw) {
        float theta;
        Player player;
        if (entity instanceof Player && ((FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)(player = (Player)entity))).isFlying() && ((theta = Mth.m_14177_((float)(player.m_146908_() - player.f_20883_))) < -50.0f || theta > 50.0f)) {
            player.f_20883_ += deltaYaw;
            player.f_20884_ += deltaYaw;
        }
    }
}

