/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.handler;

import fuzs.fantasticwings.client.FantasticWingsClient;
import fuzs.fantasticwings.flight.apparatus.FlightApparatusImpl;
import fuzs.puzzleslib.api.client.data.v2.AbstractModelProvider;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class PotionItemModelHandler {
    public static final Item[] POTION_ITEMS = new Item[]{Items.f_42589_, Items.f_42736_, Items.f_42739_};
    private static final Set<ResourceLocation> POTION_MODEL_LOCATIONS = Stream.of(POTION_ITEMS).map(item -> new ModelResourceLocation(BuiltInRegistries.f_257033_.m_7981_(item), "inventory")).collect(Collectors.toSet());

    public static EventResultHolder<UnbakedModel> onModifyUnbakedModel(ResourceLocation modelLocation, Supplier<UnbakedModel> unbakedModel, Function<ResourceLocation, UnbakedModel> modelGetter, BiConsumer<ResourceLocation, UnbakedModel> modelAdder) {
        UnbakedModel unbakedModel2;
        if (POTION_MODEL_LOCATIONS.contains(modelLocation) && (unbakedModel2 = unbakedModel.get()) instanceof BlockModel) {
            BlockModel blockModel = (BlockModel)unbakedModel2;
            FlightApparatusImpl.forEach(flightApparatus -> PotionItemModelHandler.registerItemOverride(blockModel, flightApparatus.textureLocation(), flightApparatus.modelLocation()));
            PotionItemModelHandler.registerItemOverride(blockModel, FantasticWingsClient.BAT_BLOOD_BOTTLE_TEXTURE_LOCATION, AbstractModelProvider.decorateItemModelLocation((ResourceLocation)FantasticWingsClient.BAT_BLOOD_BOTTLE_TEXTURE_LOCATION));
            return EventResultHolder.interrupt((Object)blockModel);
        }
        return EventResultHolder.pass();
    }

    private static void registerItemOverride(BlockModel blockModel, ResourceLocation itemModelProperty, ResourceLocation overrideModelLocation) {
        ItemOverride.Predicate itemPredicate = new ItemOverride.Predicate(itemModelProperty, 1.0f);
        ItemOverride itemOverride = new ItemOverride(overrideModelLocation, Collections.singletonList(itemPredicate));
        blockModel.m_111484_().add(itemOverride);
    }
}

