/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.fantasticwings.client.model.pipeline.ForwardingVertexConsumer;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;

public final class Model3DTexture
extends ModelPart.Cube {
    private Model3DTexture(float posX, float posY, float posZ, int width, int height, float u1, float v1, float u2, float v2, int textureWidth, int textureHeight) {
        super(0, 0, posX, posY, posZ, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, (float)textureWidth, (float)textureHeight, EnumSet.allOf(Direction.class));
        float f9;
        float f8;
        float f82;
        float f7;
        int k;
        int faceCount = 2 + 2 * width + 2 * height;
        ModelPart.Polygon[] polygons = new ModelPart.Polygon[faceCount];
        float x0 = this.f_104335_;
        float x1 = this.f_104335_ + (float)width;
        float y0 = this.f_104336_;
        float y1 = this.f_104336_ + (float)height;
        float z0 = this.f_104337_;
        float z1 = this.f_104337_ + 1.0f;
        FaceAdder faces = Model3DTexture.getFaceAdder(polygons);
        faces.add(x0, y0, z0, x1, y1, z0, u1, v1, u2, v2, Direction.NORTH);
        faces.add(x0, y1, z1, x1, y0, z1, u1, v2, u2, v1, Direction.SOUTH);
        float f5 = 0.5f * (u1 - u2) / (float)width;
        float f6 = 0.5f * (v1 - v2) / (float)height;
        for (k = 0; k < width; ++k) {
            f7 = x0 + (float)k;
            f82 = u1 + (u2 - u1) * ((float)k / (float)width) - f5;
            faces.add(f7, y0, z0, f7, y1, z1, f82, v1, f82, v2, Direction.WEST);
        }
        for (k = 0; k < width; ++k) {
            f8 = u1 + (u2 - u1) * ((float)k / (float)width) - f5;
            f9 = x0 + (float)(k + 1);
            faces.add(f9, y1, z0, f9, y0, z1, f8, v2, f8, v1, Direction.EAST);
        }
        for (k = 0; k < height; ++k) {
            f8 = v1 + (v2 - v1) * ((float)k / (float)height) - f6;
            f9 = y0 + (float)(k + 1);
            faces.add(x0, f9, z0, x1, f9, z1, u1, f8, u2, f8, Direction.UP);
        }
        for (k = 0; k < height; ++k) {
            f7 = y0 + (float)k;
            f82 = v1 + (v2 - v1) * ((float)k / (float)height) - f6;
            faces.add(x1, f7, z0, x0, f7, z1, u2, f82, u1, f82, Direction.DOWN);
        }
        this.f_104341_ = polygons;
    }

    public void m_171332_(PoseStack.Pose pose, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.m_171332_(pose, (VertexConsumer)new ForwardingVertexConsumer(vertexConsumer), packedLight, packedOverlay, red, green, blue, alpha);
    }

    private static FaceAdder getFaceAdder(ModelPart.Polygon[] polygons) {
        AtomicInteger polygonIndex = new AtomicInteger();
        return (x0, y0, z0, x1, y1, z1, u1, v1, u2, v2, normal) -> {
            ModelPart.Vertex[] vertices = new ModelPart.Vertex[4];
            boolean vertical = normal.m_122434_().m_122478_();
            vertices[0] = new ModelPart.Vertex(x1, y0, z0, 0.0f, 0.0f);
            vertices[1] = new ModelPart.Vertex(x0, y0, vertical ? z0 : z1, 0.0f, 0.0f);
            vertices[2] = new ModelPart.Vertex(x0, y1, z1, 0.0f, 0.0f);
            vertices[3] = new ModelPart.Vertex(x1, y1, vertical ? z1 : z0, 0.0f, 0.0f);
            polygons[polygonIndex.getAndIncrement()] = new ModelPart.Polygon(vertices, u1, v1, u2, v2, 64.0f, 64.0f, false, normal);
        };
    }

    public static Model3DTexture create(float posX, float posY, float posZ, int width, int height, int u, int v, int textureWidth, int textureHeight) {
        return new Model3DTexture(posX, posY, posZ, width, height, u, v, u + width, v + height, textureWidth, textureHeight);
    }

    @FunctionalInterface
    static interface FaceAdder {
        public void add(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, Direction var11);
    }
}

