/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.fantasticwings.client.animator.AnimatorAvian;
import fuzs.fantasticwings.client.model.Model3DTexture;
import fuzs.fantasticwings.client.model.ModelWings;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public final class ModelWingsAvian
extends ModelWings<AnimatorAvian> {
    private final ModelPart root;
    private final ImmutableList<ModelPart> bonesLeft;
    private final ImmutableList<ModelPart> bonesRight;
    private final ImmutableList<ModelPart> feathersLeft;
    private final ImmutableList<ModelPart> feathersRight;

    public ModelWingsAvian(ModelPart modelPart) {
        this.root = modelPart;
        ModelPart leftCoracoid = modelPart.m_171324_("left_coracoid");
        ModelPart rightCoracoid = modelPart.m_171324_("right_coracoid");
        ModelPart leftHumerus = leftCoracoid.m_171324_("left_humerus");
        ModelPart rightHumerus = rightCoracoid.m_171324_("right_humerus");
        ModelPart leftUlna = leftHumerus.m_171324_("left_ulna");
        ModelPart rightUlna = rightHumerus.m_171324_("right_ulna");
        ModelPart leftCarpals = leftUlna.m_171324_("left_carpals");
        ModelPart rightCarpals = rightUlna.m_171324_("right_carpals");
        ModelPart leftCoracoidFeathers = leftCoracoid.m_171324_("left_coracoid_feathers");
        ModelWingsAvian.add3DTexture(leftCoracoidFeathers, 6, 40, 0.0f, 0.0f, -1.0f, 6, 8);
        ModelPart rightCoracoidFeathers = rightCoracoid.m_171324_("right_coracoid_feathers");
        ModelWingsAvian.add3DTexture(rightCoracoidFeathers, 0, 40, -6.0f, 0.0f, -1.0f, 6, 8);
        ModelPart leftTertiaryFeathers = leftHumerus.m_171324_("left_tertiary_feathers");
        ModelWingsAvian.add3DTexture(leftTertiaryFeathers, 10, 14, 0.0f, 0.0f, -0.5f, 10, 14);
        ModelPart rightTertiaryFeathers = rightHumerus.m_171324_("right_tertiary_feathers");
        ModelWingsAvian.add3DTexture(rightTertiaryFeathers, 0, 14, -10.0f, 0.0f, -0.5f, 10, 14);
        ModelPart leftSecondaryFeathers = leftUlna.m_171324_("left_secondary_feathers");
        ModelWingsAvian.add3DTexture(leftSecondaryFeathers, 31, 14, -2.0f, 0.0f, -0.5f, 11, 12);
        ModelPart rightSecondaryFeathers = rightUlna.m_171324_("right_secondary_feathers");
        ModelWingsAvian.add3DTexture(rightSecondaryFeathers, 20, 14, -9.0f, 0.0f, -0.5f, 11, 12);
        ModelPart leftPrimaryFeathers = leftCarpals.m_171324_("left_primary_feathers");
        ModelWingsAvian.add3DTexture(leftPrimaryFeathers, 53, 14, 0.0f, -2.1f, -0.5f, 11, 11);
        ModelPart rightPrimaryFeathers = rightCarpals.m_171324_("right_primary_feathers");
        ModelWingsAvian.add3DTexture(rightPrimaryFeathers, 42, 14, -11.0f, -2.1f, -0.5f, 11, 11);
        this.bonesLeft = ImmutableList.of((Object)leftCoracoid, (Object)leftHumerus, (Object)leftUlna, (Object)leftCarpals);
        this.bonesRight = ImmutableList.of((Object)rightCoracoid, (Object)rightHumerus, (Object)rightUlna, (Object)rightCarpals);
        this.feathersLeft = ImmutableList.of((Object)leftCoracoidFeathers, (Object)leftTertiaryFeathers, (Object)leftSecondaryFeathers, (Object)leftPrimaryFeathers);
        this.feathersRight = ImmutableList.of((Object)rightCoracoidFeathers, (Object)rightTertiaryFeathers, (Object)rightSecondaryFeathers, (Object)rightPrimaryFeathers);
    }

    public static LayerDefinition createWingsLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.m_171576_();
        PartDefinition leftCoracoid = root.m_171599_("left_coracoid", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171481_(0.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f), PartPose.m_171419_((float)1.5f, (float)5.5f, (float)2.5f));
        PartDefinition rightCoracoid = root.m_171599_("right_coracoid", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171481_(-5.0f, -1.5f, -1.5f, 5.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-1.5f, (float)5.5f, (float)2.5f));
        PartDefinition leftHumerus = leftCoracoid.m_171599_("left_humerus", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.1f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f), PartPose.m_171419_((float)4.7f, (float)-0.6f, (float)0.1f));
        PartDefinition rightHumerus = rightCoracoid.m_171599_("right_humerus", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171481_(-6.9f, -1.1f, -2.0f, 7.0f, 3.0f, 4.0f), PartPose.m_171419_((float)-4.7f, (float)-0.6f, (float)0.1f));
        PartDefinition leftUlna = leftHumerus.m_171599_("left_ulna", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171481_(0.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f), PartPose.m_171419_((float)6.5f, (float)0.2f, (float)0.1f));
        PartDefinition rightUlna = rightHumerus.m_171599_("right_ulna", CubeListBuilder.m_171558_().m_171514_(22, 6).m_171481_(-9.0f, -1.5f, -1.5f, 9.0f, 3.0f, 3.0f), PartPose.m_171419_((float)-6.5f, (float)0.2f, (float)0.1f));
        PartDefinition leftCarpals = leftUlna.m_171599_("left_carpals", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171481_(0.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f), PartPose.m_171419_((float)8.5f, (float)0.0f, (float)0.0f));
        PartDefinition rightCarpals = rightUlna.m_171599_("right_carpals", CubeListBuilder.m_171558_().m_171514_(46, 4).m_171481_(-5.0f, -1.0f, -1.0f, 5.0f, 2.0f, 2.0f), PartPose.m_171419_((float)-8.5f, (float)0.0f, (float)0.0f));
        PartDefinition leftCoracoidFeathers = leftCoracoid.m_171599_("left_coracoid_feathers", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.4f, (float)0.0f, (float)1.0f));
        PartDefinition rightCoracoidFeathers = rightCoracoid.m_171599_("right_coracoid_feathers", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.4f, (float)0.0f, (float)1.0f));
        PartDefinition leftTertiaryFeathers = leftHumerus.m_171599_("left_tertiary_feathers", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)1.0f));
        PartDefinition rightTertiaryFeathers = rightHumerus.m_171599_("right_tertiary_feathers", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)1.0f));
        PartDefinition leftSecondaryFeathers = leftUlna.m_171599_("left_secondary_feathers", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition rightSecondaryFeathers = rightUlna.m_171599_("right_secondary_feathers", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition leftPrimaryFeathers = leftCarpals.m_171599_("left_primary_feathers", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightPrimaryFeathers = rightCarpals.m_171599_("right_primary_feathers", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    @Override
    public void render(AnimatorAvian animator, float delta, PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        ModelPart right;
        ModelPart left;
        int i;
        for (i = 0; i < this.bonesLeft.size(); ++i) {
            left = (ModelPart)this.bonesLeft.get(i);
            right = (ModelPart)this.bonesRight.get(i);
            ModelWingsAvian.setAngles(left, right, animator.getWingRotation(i, delta));
        }
        for (i = 0; i < this.feathersLeft.size(); ++i) {
            left = (ModelPart)this.feathersLeft.get(i);
            right = (ModelPart)this.feathersRight.get(i);
            ModelWingsAvian.setAngles(left, right, animator.getFeatherRotation(i, delta));
        }
        this.root.m_104306_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private static void add3DTexture(ModelPart model, int u, int v, float offX, float offY, float offZ, int width, int height) {
        Preconditions.checkState((boolean)model.f_104212_.isEmpty(), (Object)"model part cube list is not empty");
        model.f_104212_ = ImmutableList.of((Object)((Object)Model3DTexture.create(offX, offY, offZ, width, height, u, v, 64, 64)));
    }
}

