/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import fuzs.fantasticwings.commands.WingsArgument;
import fuzs.fantasticwings.flight.apparatus.FlightApparatusImpl;
import fuzs.fantasticwings.world.effect.WingsMobEffect;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class WingsCommand {
    public static final String KEY_TAKE_WINGS_SINGLE = "commands.wings.take.success.single";
    public static final String KEY_TAKE_WINGS_MULTIPLE = "commands.wings.take.success.multiple";
    public static final String KEY_GIVE_WINGS_MULTIPLE = "commands.wings.give.success.multiple";
    public static final String KEY_GIVE_WINGS_SINGLE = "commands.wings.give.success.single";
    public static final MutableComponent COMPONENT_GIVE_WINGS_FAILED = Component.m_237115_((String)"commands.wings.give.failed");
    public static final MutableComponent COMPONENT_TAKE_WINGS_FAILED = Component.m_237115_((String)"commands.wings.take.failed");
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)COMPONENT_GIVE_WINGS_FAILED);
    private static final SimpleCommandExceptionType ERROR_TAKE_FAILED = new SimpleCommandExceptionType((Message)COMPONENT_TAKE_WINGS_FAILED);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"wings").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"wings", (ArgumentType)WingsArgument.wings()).executes(WingsCommand::giveWing))))).then(Commands.m_82127_((String)"take").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"wings", (ArgumentType)WingsArgument.wings()).executes(WingsCommand::takeSpecificWings))).executes(WingsCommand::takeWings))));
    }

    private static int giveWing(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(ctx, (String)"targets");
        FlightApparatusImpl wings = WingsArgument.getWings(ctx, "wings");
        int count = 0;
        for (ServerPlayer player : targets) {
            if (!WingsMobEffect.giveWings(player, wings.holder())) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)KEY_GIVE_WINGS_SINGLE, (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).m_5446_()}), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)KEY_GIVE_WINGS_MULTIPLE, (Object[])new Object[]{targets.size()}), true);
        }
        return count;
    }

    private static int takeWings(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(ctx, (String)"targets");
        int count = 0;
        for (ServerPlayer player : targets) {
            if (!WingsMobEffect.takeWings(player)) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_TAKE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)KEY_TAKE_WINGS_SINGLE, (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).m_5446_()}), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)KEY_TAKE_WINGS_MULTIPLE, (Object[])new Object[]{targets.size()}), true);
        }
        return count;
    }

    private static int takeSpecificWings(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(ctx, (String)"targets");
        FlightApparatusImpl wings = WingsArgument.getWings(ctx, "wings");
        int count = 0;
        for (ServerPlayer player : targets) {
            if (!WingsMobEffect.takeWings(player, wings.holder())) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_TAKE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)KEY_TAKE_WINGS_SINGLE, (Object[])new Object[]{((ServerPlayer)targets.iterator().next()).m_5446_()}), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)KEY_TAKE_WINGS_MULTIPLE, (Object[])new Object[]{targets.size()}), true);
        }
        return count;
    }
}

