/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.flight;

import fuzs.fantasticwings.FantasticWings;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.network.ServerboundControlFlyingMessage;
import fuzs.fantasticwings.util.CubicBezier;
import fuzs.fantasticwings.util.MathHelper;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class FlightCapability
extends CapabilityComponent<Player> {
    private static final String KEY_IS_FLYING = FantasticWings.id("is_flying").toString();
    private static final String KEY_TIME_FLYING = FantasticWings.id("time_flying").toString();
    private static final String KEY_WING_TYPE = FantasticWings.id("wing_type").toString();
    private static final CubicBezier FLY_AMOUNT_CURVE = new CubicBezier(0.37f, 0.13f, 0.3f, 1.12f);
    private static final int INITIAL_TIME_FLYING = 0;
    private static final int MAX_TIME_FLYING = 20;
    private static final float MIN_SPEED = 0.03f;
    private static final float MAX_SPEED = 0.0715f;
    private static final float Y_BOOST = 0.05f;
    private static final float MANUAL_Y_BOOST = 0.06f;
    private static final float FALL_REDUCTION = 0.9f;
    private static final float PITCH_OFFSET = 30.0f;
    private int prevTimeFlying = 0;
    private int timeFlying = 0;
    private boolean isFlying;
    private FlightApparatus.Holder holder = FlightApparatus.Holder.empty();

    public void setIsFlying(boolean isFlying) {
        this.setIsFlying(isFlying, null);
    }

    public void setIsFlying(boolean isFlying, @Nullable PlayerSet playerSet) {
        if (this.isFlying != isFlying) {
            this.isFlying = isFlying;
            if (this.isFlying) {
                ((Player)this.getHolder()).m_19877_();
            }
            this.setChanged(playerSet);
        }
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public void toggleIsFlying(PlayerSet playerSet) {
        this.setIsFlying(!this.isFlying, playerSet);
    }

    public void setTimeFlying(int timeFlying) {
        if (this.timeFlying != timeFlying) {
            this.timeFlying = timeFlying;
            this.setChanged(PlayerSet.ofNone());
        }
    }

    public void setWings(FlightApparatus.Holder flightApparatus) {
        if (!this.holder.is(flightApparatus)) {
            this.holder = flightApparatus;
            this.setChanged();
        }
    }

    public FlightApparatus.Holder getWings() {
        return this.holder;
    }

    public float getFlyingAmount(float delta) {
        return FLY_AMOUNT_CURVE.eval(MathHelper.lerp(this.prevTimeFlying, this.timeFlying, delta) / 20.0f);
    }

    public boolean canUseWings() {
        return !((Player)this.getHolder()).m_150110_().f_35935_ && !((Player)this.getHolder()).m_6844_(EquipmentSlot.CHEST).m_204117_(ModRegistry.WING_OBSTRUCTIONS);
    }

    public boolean canFly() {
        return this.holder.flightApparatus().isUsableForFlying((Player)this.getHolder()) && this.canUseWings();
    }

    public boolean canSlowlyDescend() {
        return this.holder.flightApparatus().isUsableForSlowlyDescending((Player)this.getHolder()) && this.canUseWings() && (this.isFlying() || !((Player)this.getHolder()).m_20164_() && !((Player)this.getHolder()).m_150110_().f_35936_);
    }

    private void onWornUpdate() {
        Player player = (Player)this.getHolder();
        if (!player.m_9236_().f_46443_ && this.isFlying() && !this.canFly()) {
            this.setIsFlying(false);
        }
        if (player.m_21515_()) {
            if (this.isFlying()) {
                float speed = Mth.m_144920_((float)0.03f, (float)0.0715f, (float)player.f_20902_);
                float elevationBoost = MathHelper.transform(Math.abs(player.m_146909_()), 45.0f, 90.0f, 1.0f, 0.0f);
                float pitch = -MathHelper.toRadians(player.m_146909_() - 30.0f * elevationBoost);
                float yaw = -MathHelper.toRadians(player.m_146908_()) - (float)Math.PI;
                float vxz = -Mth.m_14089_((float)pitch);
                float vy = Mth.m_14031_((float)pitch);
                float vz = Mth.m_14089_((float)yaw);
                float vx = Mth.m_14031_((float)yaw);
                player.m_20256_(player.m_20184_().m_82520_((double)(vx * vxz * speed), (double)(vy * speed) + (double)0.05f * (player.m_146909_() > 0.0f ? (double)elevationBoost : 1.0), (double)(vz * vxz * speed)));
                if (player.f_20899_) {
                    player.m_20256_(player.m_20184_().m_82520_(0.0, (double)0.03f, 0.0));
                } else if (player.m_20164_()) {
                    player.m_20256_(player.m_20184_().m_82520_(0.0, (double)-0.06f, 0.0));
                }
            }
            if (this.canSlowlyDescend()) {
                Vec3 deltaMovement = player.m_20184_();
                if (deltaMovement.m_7098_() < 0.0) {
                    player.m_20256_(deltaMovement.m_82542_(1.0, (double)0.9f, 1.0));
                }
                player.f_19789_ = 0.0f;
            }
        }
    }

    public void tick() {
        Player player = (Player)this.getHolder();
        if (!this.holder.isEmpty() || !player.m_21515_()) {
            this.onWornUpdate();
        } else if (!player.m_9236_().f_46443_ && this.isFlying()) {
            this.setIsFlying(false);
        }
        this.prevTimeFlying = this.timeFlying;
        if (this.isFlying()) {
            if (this.timeFlying < 20) {
                this.setTimeFlying(this.timeFlying + 1);
            } else if (player.m_7578_() && player.m_20096_()) {
                this.setIsFlying(false, PlayerSet.ofNone());
                FantasticWings.NETWORK.sendMessage((Record)new ServerboundControlFlyingMessage(false));
            }
        } else if (this.timeFlying > 0) {
            this.setTimeFlying(this.timeFlying - 1);
        }
    }

    public void onFlown(Vec3 direction) {
        Player player = (Player)this.getHolder();
        if (this.isFlying()) {
            this.holder.flightApparatus().onFlying(player, direction);
        } else if (this.canSlowlyDescend() && player.m_20184_().m_7098_() < -0.5) {
            this.holder.flightApparatus().onSlowlyDescending(player, direction);
        }
    }

    public void write(CompoundTag compoundTag) {
        compoundTag.m_128379_(KEY_IS_FLYING, this.isFlying);
        compoundTag.m_128405_(KEY_TIME_FLYING, this.timeFlying);
        compoundTag.m_128365_(KEY_WING_TYPE, (Tag)this.holder.writeToNbtTag());
    }

    public void read(CompoundTag compoundTag) {
        this.isFlying = compoundTag.m_128471_(KEY_IS_FLYING);
        this.timeFlying = compoundTag.m_128451_(KEY_TIME_FLYING);
        this.holder = FlightApparatus.Holder.readFromNbtTag(compoundTag.m_128469_(KEY_WING_TYPE));
    }
}

