/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.world.effect;

import fuzs.fantasticwings.flight.FlightCapability;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import fuzs.fantasticwings.flight.apparatus.FlightApparatusImpl;
import fuzs.fantasticwings.init.ModRegistry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.InstantenousMobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;

public class WingsMobEffect
extends InstantenousMobEffect {
    public WingsMobEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        super.m_6742_(livingEntity, amplifier);
        if (!livingEntity.m_9236_().f_46443_ && livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (this.m_19486_() ? WingsMobEffect.giveWings(serverPlayer, amplifier) : WingsMobEffect.takeWings(serverPlayer)) {
                serverPlayer.m_9236_().m_6263_(null, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), (SoundEvent)ModRegistry.ITEM_ARMOR_EQUIP_WINGS.m_203334_(), SoundSource.PLAYERS, 1.0f, this.m_19486_() ? 1.0f : 0.8f);
            }
        }
    }

    public static boolean giveWings(ServerPlayer serverPlayer, int wingsTypeId) {
        return WingsMobEffect.giveWings(serverPlayer, FlightApparatusImpl.byId(wingsTypeId).holder());
    }

    public static boolean giveWings(ServerPlayer serverPlayer, FlightApparatus.Holder flightApparatus) {
        FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)serverPlayer);
        if (!flightCapability.getWings().is(flightApparatus)) {
            flightCapability.setWings(flightApparatus);
            return true;
        }
        return false;
    }

    public static boolean takeWings(ServerPlayer serverPlayer) {
        return WingsMobEffect.takeWings(serverPlayer, FlightApparatus.Holder.empty());
    }

    public static boolean takeWings(ServerPlayer serverPlayer, FlightApparatus.Holder flightApparatus) {
        FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)serverPlayer);
        if (!flightCapability.getWings().isEmpty() && (flightApparatus.isEmpty() || flightCapability.getWings().is(flightApparatus))) {
            flightCapability.setWings(FlightApparatus.Holder.empty());
            return true;
        }
        return false;
    }
}

