/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.fantasticwings.client.audio.WingsSound;
import fuzs.fantasticwings.client.flight.FlightViewCapability;
import fuzs.fantasticwings.client.init.ClientModRegistry;
import fuzs.fantasticwings.flight.FlightCapability;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.fantasticwings.util.MathHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ClientEventHandler {
    public static void onAnimatePlayerModel(Player player, PlayerModel<?> model, float ticksExisted, float pitch) {
        float delta;
        FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player);
        float flyingAmount = flightCapability.getFlyingAmount(delta = ticksExisted - (float)player.tickCount);
        if (flyingAmount != 0.0f) {
            model.head.xRot = MathHelper.toRadians(MathHelper.lerp(pitch, pitch / 4.0f - 90.0f, flyingAmount));
            model.leftArm.xRot = MathHelper.lerp(model.leftArm.xRot, -3.2f, flyingAmount);
            model.rightArm.xRot = MathHelper.lerp(model.rightArm.xRot, -3.2f, flyingAmount);
            model.leftLeg.xRot = MathHelper.lerp(model.leftLeg.xRot, 0.0f, flyingAmount);
            model.rightLeg.xRot = MathHelper.lerp(model.rightLeg.xRot, 0.0f, flyingAmount);
            model.hat.copyFrom(model.head);
        }
    }

    public static void onApplyRotations(Player player, PoseStack poseStack, float delta) {
        FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player);
        float amt = flightCapability.getFlyingAmount(delta);
        if (amt > 0.0f) {
            float roll = MathHelper.lerpDegrees(player.yBodyRotO - player.yRotO, player.yBodyRot - player.getYRot(), delta);
            float pitch = -MathHelper.lerpDegrees(player.xRotO, player.getXRot(), delta) - 90.0f;
            poseStack.mulPose(Axis.ZP.rotationDegrees(MathHelper.lerpDegrees(0.0f, roll, amt)));
            poseStack.mulPose(Axis.XP.rotationDegrees(MathHelper.lerpDegrees(0.0f, pitch, amt)));
            poseStack.translate(0.0, -1.2 * (double)MathHelper.easeInOut(amt), 0.0);
        }
    }

    public static void onComputeCameraAngles(GameRenderer renderer, Camera camera, float partialTick, MutableFloat pitch, MutableFloat yaw, MutableFloat roll) {
        LivingEntity cameraEntity = (LivingEntity)camera.getEntity();
        ModRegistry.FLIGHT_CAPABILITY.getIfProvided((Object)cameraEntity).ifPresent(flightViewCapability -> {
            float flyingAmount = flightViewCapability.getFlyingAmount(partialTick);
            if (flyingAmount > 0.0f) {
                float newRoll = MathHelper.lerpDegrees(cameraEntity.yBodyRotO - cameraEntity.yRotO, cameraEntity.yBodyRot - cameraEntity.getYRot(), partialTick);
                roll.accept(MathHelper.lerpDegrees(0.0f, -newRoll * 0.25f, flyingAmount));
            }
        });
    }

    public static EventResult onEntityLoad(Entity entity, ClientLevel level) {
        if (entity instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)entity;
            FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)localPlayer);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new WingsSound((Player)localPlayer, flightCapability));
        }
        return EventResult.PASS;
    }

    public static void onEndPlayerTick(Player player) {
        ClientModRegistry.FLIGHT_VIEW_CAPABILITY.getIfProvided((Object)player).ifPresent(FlightViewCapability::tick);
    }

    public static EventResult onRenderOffHand(ItemInHandRenderer itemInHandRenderer, AbstractClientPlayer player, HumanoidArm humanoidArm, ItemStack itemStack, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLight, float partialTick, float interpolatedPitch, float swingProgress, float equipProgress) {
        if (itemStack.isEmpty() && !player.isScoping() && !player.isInvisible() && !itemInHandRenderer.mainHandItem.is(Items.FILLED_MAP) && ((FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)player)).isFlying()) {
            itemInHandRenderer.renderPlayerArm(poseStack, multiBufferSource, combinedLight, equipProgress, swingProgress, player.getMainArm().getOpposite());
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static void onTurn(Entity entity, float deltaYaw) {
        float theta;
        Player player;
        if (entity instanceof Player && ((FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)(player = (Player)entity))).isFlying() && ((theta = Mth.wrapDegrees((float)(player.getYRot() - player.yBodyRot))) < -50.0f || theta > 50.0f)) {
            player.yBodyRot += deltaYaw;
            player.yBodyRotO += deltaYaw;
        }
    }
}

