/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.flight.apparatus;

import fuzs.fantasticwings.FantasticWings;
import fuzs.fantasticwings.config.ServerConfig;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import fuzs.fantasticwings.flight.apparatus.WingSettings;
import fuzs.fantasticwings.flight.apparatus.WingSettingsApparatus;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.puzzleslib.api.client.data.v2.AbstractModelProvider;
import fuzs.puzzleslib.api.init.v3.PotionBrewingRegistry;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import org.jetbrains.annotations.Nullable;

public enum FlightApparatusImpl implements WingSettingsApparatus,
StringRepresentable
{
    ANGEL("angel_wings", () -> Items.FEATHER, serverConfig -> serverConfig.angelWings),
    PARROT("parrot_wings", () -> Items.RED_DYE, serverConfig -> serverConfig.parrotWings),
    SLIME("slime_wings", () -> Items.SLIME_BALL, serverConfig -> serverConfig.slimeWings),
    BLUE_BUTTERFLY("blue_butterfly_wings", () -> Items.BLUE_DYE, serverConfig -> serverConfig.blueButterflyWings),
    MONARCH_BUTTERFLY("monarch_butterfly_wings", () -> Items.ORANGE_DYE, serverConfig -> serverConfig.monarchButterflyWings),
    FIRE("fire_wings", () -> Items.BLAZE_POWDER, serverConfig -> serverConfig.fireWings),
    BAT("bat_wings", () -> Items.LEATHER, serverConfig -> serverConfig.batWings),
    FAIRY("fairy_wings", () -> Items.OXEYE_DAISY, serverConfig -> serverConfig.fairyWings),
    EVIL("evil_wings", () -> Items.BONE, serverConfig -> serverConfig.evilWings),
    DRAGON("dragon_wings", () -> Items.FIRE_CHARGE, serverConfig -> serverConfig.dragonWings),
    METALLIC("metallic_wings", () -> Items.IRON_INGOT, serverConfig -> serverConfig.metallicWings);

    private static final FlightApparatusImpl[] VALUES;
    private static final IntFunction<FlightApparatusImpl> BY_ID;
    private final String name;
    private final Supplier<Item> ingredient;
    private final Function<ServerConfig, WingSettings> settingsExtractor;
    @Nullable
    private Potion potion;

    private FlightApparatusImpl(String name, Supplier<Item> ingredient, Function<ServerConfig, WingSettings> settingsExtractor) {
        this.name = name;
        this.ingredient = ingredient;
        this.settingsExtractor = settingsExtractor;
    }

    public static FlightApparatusImpl byId(int id) {
        return BY_ID.apply(id);
    }

    public FlightApparatus.Holder holder() {
        return FlightApparatus.Holder.of(this);
    }

    public String id() {
        return this.resourceLocation().toString();
    }

    public ResourceLocation resourceLocation() {
        return FantasticWings.id(this.name);
    }

    public ResourceLocation textureLocation() {
        return this.resourceLocation().withSuffix("_bottle");
    }

    public ResourceLocation modelLocation() {
        return AbstractModelProvider.decorateItemModelLocation((ResourceLocation)this.textureLocation());
    }

    public void registerPotion(BiConsumer<String, Supplier<Potion>> consumer) {
        consumer.accept(this.name, () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)ModRegistry.GROW_WINGS_MOB_EFFECT.value(), 1, this.ordinal())}));
    }

    public void registerBrewingRecipes() {
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(Potions.SLOW_FALLING, this.ingredient.get(), this.getPotion());
        PotionBrewingRegistry.INSTANCE.registerPotionRecipe(Potions.LONG_SLOW_FALLING, this.ingredient.get(), this.getPotion());
    }

    public Potion getPotion() {
        return this.potion != null ? this.potion : (this.potion = (Potion)BuiltInRegistries.POTION.get(this.resourceLocation()));
    }

    public static void forEach(Consumer<FlightApparatusImpl> consumer) {
        for (FlightApparatusImpl flightApparatus : VALUES) {
            consumer.accept(flightApparatus);
        }
    }

    @Override
    public WingSettings getWingSettings() {
        return this.settingsExtractor.apply((ServerConfig)FantasticWings.CONFIG.get(ServerConfig.class));
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        VALUES = FlightApparatusImpl.values();
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])VALUES, (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
    }
}

