/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.client.flight;

import fuzs.fantasticwings.client.animator.Animator;
import fuzs.fantasticwings.client.animator.state.State;
import fuzs.fantasticwings.client.animator.state.StateIdle;
import fuzs.fantasticwings.client.flight.apparatus.WingForm;
import fuzs.fantasticwings.flight.FlightCapability;
import fuzs.fantasticwings.init.ModRegistry;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_742;

public final class FlightViewCapability
extends CapabilityComponent<class_742> {
    private WingState animator = PresentWingState.VOID;

    public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
        this.animator.ifFormPresent(consumer);
    }

    public void tick() {
        this.animator = WingForm.get(this.getFlight().getWings().flightApparatus()).map(view -> this.animator.next((WingForm<?>)view)).orElseGet(this.animator::nextAbsent);
        this.animator.update(this.getFlight(), (class_1657)this.getHolder());
    }

    public boolean resetEyeHeight() {
        return this.getFlight().isFlying() || this.getFlight().getFlyingAmount(1.0f) > 0.0f && ((class_742)this.getHolder()).method_18376() == class_4050.field_18077;
    }

    public FlightCapability getFlight() {
        return (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)((class_1657)this.getHolder()));
    }

    private record PresentWingState(WingForm<?> wing, Strategy behavior) implements WingState
    {
        static final WingState VOID = new WingState(){

            @Override
            public WingState nextAbsent() {
                return this;
            }

            @Override
            public WingState next(WingForm<?> form) {
                return PresentWingState.newState(form);
            }

            @Override
            public void update(FlightCapability flight, class_1657 player) {
            }

            @Override
            public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
            }
        };

        @Override
        public WingState nextAbsent() {
            return VOID;
        }

        @Override
        public WingState next(WingForm<?> form) {
            if (this.wing.equals(form)) {
                return this;
            }
            return PresentWingState.newState(form);
        }

        @Override
        public void update(FlightCapability flight, class_1657 player) {
            this.behavior.update(flight, player);
        }

        @Override
        public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
            this.behavior.ifFormPresent(consumer);
        }

        public static <T extends Animator> WingState newState(WingForm<T> shape) {
            return new PresentWingState(shape, new WingStrategy<T>(shape));
        }

        private static class WingStrategy<T extends Animator>
        implements Strategy {
            private final WingForm<T> shape;
            private final T animator;
            private State state;

            public WingStrategy(WingForm<T> shape) {
                this.shape = shape;
                this.animator = shape.createAnimator();
                this.state = new StateIdle();
            }

            @Override
            public void update(FlightCapability flight, class_1657 player) {
                this.animator.update();
                State state = this.state.update(flight, player.method_23317() - player.field_6014, player.method_23318() - player.field_6036, player.method_23321() - player.field_5969, player);
                if (!this.state.equals(state)) {
                    state.beginAnimation((Animator)this.animator);
                }
                this.state = state;
            }

            @Override
            public void ifFormPresent(Consumer<WingForm.FormRenderer> consumer) {
                consumer.accept(new WingForm.FormRenderer(){

                    @Override
                    public class_2960 getTexture() {
                        return shape.getTextureLocation();
                    }

                    @Override
                    public void render(class_4587 matrixStack, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, float delta) {
                        shape.getModel().render(animator, delta, matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                    }
                });
            }
        }
    }

    static interface WingState {
        public WingState nextAbsent();

        public WingState next(WingForm<?> var1);

        public void update(FlightCapability var1, class_1657 var2);

        public void ifFormPresent(Consumer<WingForm.FormRenderer> var1);
    }

    private static interface Strategy {
        public void update(FlightCapability var1, class_1657 var2);

        public void ifFormPresent(Consumer<WingForm.FormRenderer> var1);
    }
}

