/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import fuzs.fantasticwings.commands.WingsArgument;
import fuzs.fantasticwings.flight.apparatus.FlightApparatusImpl;
import fuzs.fantasticwings.world.effect.WingsMobEffect;
import java.util.Collection;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class WingsCommand {
    public static final String KEY_TAKE_WINGS_SINGLE = "commands.wings.take.success.single";
    public static final String KEY_TAKE_WINGS_MULTIPLE = "commands.wings.take.success.multiple";
    public static final String KEY_GIVE_WINGS_MULTIPLE = "commands.wings.give.success.multiple";
    public static final String KEY_GIVE_WINGS_SINGLE = "commands.wings.give.success.single";
    public static final class_5250 COMPONENT_GIVE_WINGS_FAILED = class_2561.method_43471((String)"commands.wings.give.failed");
    public static final class_5250 COMPONENT_TAKE_WINGS_FAILED = class_2561.method_43471((String)"commands.wings.take.failed");
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)COMPONENT_GIVE_WINGS_FAILED);
    private static final SimpleCommandExceptionType ERROR_TAKE_FAILED = new SimpleCommandExceptionType((Message)COMPONENT_TAKE_WINGS_FAILED);

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"wings").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(class_2170.method_9247((String)"give").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"wings", (ArgumentType)WingsArgument.wings()).executes(WingsCommand::giveWing))))).then(class_2170.method_9247((String)"take").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"wings", (ArgumentType)WingsArgument.wings()).executes(WingsCommand::takeSpecificWings))).executes(WingsCommand::takeWings))));
    }

    private static int giveWing(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        Collection targets = class_2186.method_9312(ctx, (String)"targets");
        FlightApparatusImpl wings = WingsArgument.getWings(ctx, "wings");
        int count = 0;
        for (class_3222 player : targets) {
            if (!WingsMobEffect.giveWings(player, wings.holder())) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)KEY_GIVE_WINGS_SINGLE, (Object[])new Object[]{((class_3222)targets.iterator().next()).method_5476()}), true);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)KEY_GIVE_WINGS_MULTIPLE, (Object[])new Object[]{targets.size()}), true);
        }
        return count;
    }

    private static int takeWings(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        Collection targets = class_2186.method_9312(ctx, (String)"targets");
        int count = 0;
        for (class_3222 player : targets) {
            if (!WingsMobEffect.takeWings(player)) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_TAKE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)KEY_TAKE_WINGS_SINGLE, (Object[])new Object[]{((class_3222)targets.iterator().next()).method_5476()}), true);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)KEY_TAKE_WINGS_MULTIPLE, (Object[])new Object[]{targets.size()}), true);
        }
        return count;
    }

    private static int takeSpecificWings(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        Collection targets = class_2186.method_9312(ctx, (String)"targets");
        FlightApparatusImpl wings = WingsArgument.getWings(ctx, "wings");
        int count = 0;
        for (class_3222 player : targets) {
            if (!WingsMobEffect.takeWings(player, wings.holder())) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_TAKE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)KEY_TAKE_WINGS_SINGLE, (Object[])new Object[]{((class_3222)targets.iterator().next()).method_5476()}), true);
        } else {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)KEY_TAKE_WINGS_MULTIPLE, (Object[])new Object[]{targets.size()}), true);
        }
        return count;
    }
}

