/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.hud;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscResources;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.magic.ManaHandler;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.GuiGraphicsAccess;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAttributes;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Activation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.ChanneledActivation;
import by.dragonsurvivalteam.dragonsurvival.util.AnimationUtils;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.blaze3d.platform.Window;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.util.Color;

@EventBusSubscriber(value={Dist.CLIENT})
public class MagicHUD {
    @Translation(comments={"\u00a7fThis ability is \u00a7r\u00a7cnot ready\u00a7r\u00a7f yet!\u00a7r (%s)"})
    public static final String COOLDOWN = Translation.Type.GUI.wrap("ability.cooldown");
    @ConfigRange(min=0.0, max=1.0)
    @Translation(key="mark_disabled_abilities_red_lerp_speed", type=Translation.Type.CONFIGURATION, comments={"How fast the lerp speed is for marking disabled abilities red."})
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "magic"}, key="mark_disabled_abilities_red_lerp_speed")
    public static double markDisabledAbilitiesRedLerpSpeed = 0.05;
    @ConfigRange(min=0.0)
    @Translation(key="mark_disabled_abilities_red_delay", type=Translation.Type.CONFIGURATION, comments={"How long until the red overlay activates if an ability is disabled."})
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "magic"}, key="mark_disabled_abilities_red_delay")
    public static double disabledColorDelay = 0.8;
    @ConfigRange
    @Translation(key="cast_bar_x_offset", type=Translation.Type.CONFIGURATION, comments={"Offset for the x position of the cast bar"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "magic"}, key="cast_bar_x_offset")
    public static Integer castbarXOffset = 0;
    @ConfigRange
    @Translation(key="cast_bar_y_offset", type=Translation.Type.CONFIGURATION, comments={"Offset for the y position of the cast bar"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "magic"}, key="casterBarYPos")
    public static Integer castbarYOffset = 0;
    @ConfigRange
    @Translation(key="skill_bar_x_offset", type=Translation.Type.CONFIGURATION, comments={"Offset for the x position of the skill bar"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "magic"}, key="skill_bar_x_offset")
    public static Integer skillbarXOffset = 0;
    @ConfigRange
    @Translation(key="skill_bar_y_offset", type=Translation.Type.CONFIGURATION, comments={"Offset for the x position of the skill bar"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "magic"}, key="skill_bar_y_offset")
    public static Integer skillbarYOffset = 0;
    @ConfigRange
    @Translation(key="mana_bar_x_offset", type=Translation.Type.CONFIGURATION, comments={"Offset for the x position of the mana bar"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "magic"}, key="mana_bar_x_offset")
    public static Integer manabarXOffset = 0;
    @ConfigRange
    @Translation(key="mana_bar_y_offset", type=Translation.Type.CONFIGURATION, comments={"Offset for the y position of the mana bar"})
    @ConfigOption(side=ConfigSide.CLIENT, category={"ui", "magic"}, key="mana_bar_y_offset")
    public static Integer manabarYOffset = 0;
    public static final ResourceLocation ID = DragonSurvival.res("magic_hud");
    public static final ResourceLocation WIDGET_TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/widgets.png");
    private static final ResourceLocation VANILLA_WIDGETS = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/pre-1.20.1-widgets.png");
    private static final ResourceLocation CAST_BAR_FILL = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/cast_bar_fill.png");
    private static boolean initializedDisabledAbilitiesColor = false;
    private static final OutlineColorData[] colors = new OutlineColorData[4];
    private static int errorTicks;
    private static Component errorMessage;
    private static float deltaCounter;
    private static boolean reverseCounter;

    public static boolean renderExperienceBar(GuiGraphics guiGraphics, int screenWidth) {
        int height;
        Player localPlayer = DragonSurvival.PROXY.getLocalPlayer();
        if (localPlayer == null || !Minecraft.getInstance().gameMode.canHurtPlayer() || !Minecraft.getInstance().gameMode.hasExperience()) {
            return false;
        }
        DragonStateHandler handler = DragonStateProvider.getData(localPlayer);
        if (!handler.isDragon() || ((DragonSpecies)handler.species().value()).manaHandling().manaXpConversion() == 0.0) {
            return false;
        }
        Window window = Minecraft.getInstance().getWindow();
        int guiScaledWidth = window.getGuiScaledWidth();
        int guiScaledHeight = window.getGuiScaledHeight();
        Minecraft.getInstance().getProfiler().push("expLevel");
        if (localPlayer.getXpNeededForNextLevel() > 0) {
            int width = screenWidth / 2 - 91;
            int experienceProgress = (int)(localPlayer.experienceProgress * 183.0f);
            height = guiScaledHeight - 32 + 3;
            guiGraphics.blit(WIDGET_TEXTURES, width, height, 0, 0.0f, 164.0f, 182, 5, 256, 256);
            if (experienceProgress > 0) {
                guiGraphics.blit(WIDGET_TEXTURES, width, height, 0, 0.0f, 169.0f, experienceProgress, 5, 256, 256);
            }
        }
        Minecraft.getInstance().getProfiler().pop();
        if (localPlayer.experienceLevel > 0) {
            Minecraft.getInstance().getProfiler().push("expLevel");
            String s = "" + localPlayer.experienceLevel;
            int width = (guiScaledWidth - Minecraft.getInstance().font.width(s)) / 2;
            height = guiScaledHeight - 31 - 4;
            guiGraphics.drawString(Minecraft.getInstance().font, s, width + 1, height, 0, false);
            guiGraphics.drawString(Minecraft.getInstance().font, s, width - 1, height, 0, false);
            guiGraphics.drawString(Minecraft.getInstance().font, s, width, height + 1, 0, false);
            guiGraphics.drawString(Minecraft.getInstance().font, s, width, height - 1, 0, false);
            guiGraphics.drawString(Minecraft.getInstance().font, s, width, height, 15937595, false);
            Minecraft.getInstance().getProfiler().pop();
        }
        return true;
    }

    public static void castingError(Component component) {
        errorTicks = Functions.secondsToTicks(5.0);
        errorMessage = component;
    }

    @SubscribeEvent
    public static void tickDownError(ClientTickEvent.Pre event) {
        if (--errorTicks <= 0) {
            errorMessage = Component.empty();
        }
    }

    private static void lerpToColor(int slot, Color color) {
        MagicHUD.colors[slot].delay -= (double)AnimationUtils.getDeltaSeconds();
        if (MagicHUD.colors[slot].delay <= 0.0) {
            MagicHUD.colors[slot].pastDelay = true;
        }
        if (!MagicHUD.colors[slot].pastDelay) {
            return;
        }
        Color currentColor = MagicHUD.colors[slot].color;
        float lerpSpeed = (float)markDisabledAbilitiesRedLerpSpeed;
        float red = Mth.lerp((float)lerpSpeed, (float)currentColor.getRedFloat(), (float)color.getRedFloat());
        float green = Mth.lerp((float)lerpSpeed, (float)currentColor.getGreenFloat(), (float)color.getGreenFloat());
        float blue = Mth.lerp((float)lerpSpeed, (float)currentColor.getBlueFloat(), (float)color.getBlueFloat());
        float alpha = Mth.lerp((float)lerpSpeed, (float)currentColor.getAlphaFloat(), (float)color.getAlphaFloat());
        MagicHUD.colors[slot].color = Color.ofRGBA((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void render(@NotNull GuiGraphics graphics, @NotNull DeltaTracker tracker) {
        int i1;
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isSpectator()) {
            return;
        }
        if (!DragonStateProvider.isDragon((Entity)player)) {
            return;
        }
        MagicData magic = MagicData.getData((Player)player);
        if (magic.getAbilities().isEmpty()) {
            return;
        }
        if (!initializedDisabledAbilitiesColor) {
            for (int i = 0; i < 4; ++i) {
                MagicHUD.colors[i] = new OutlineColorData(Color.ofRGBA((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f), disabledColorDelay, false);
            }
            initializedDisabledAbilitiesColor = true;
        }
        float delta = tracker.getGameTimeDeltaPartialTick(true) / 30.0f;
        if ((deltaCounter += reverseCounter ? -delta : delta) > 1.0f) {
            reverseCounter = true;
            deltaCounter = 1.0f;
        } else if (deltaCounter < 0.0f) {
            reverseCounter = false;
            deltaCounter = 0.0f;
        }
        int sizeX = 20;
        int sizeY = 20;
        int posX = i1 = graphics.guiWidth() - sizeX * 4 - 20;
        int posY = graphics.guiHeight() - sizeY;
        posX += skillbarXOffset.intValue();
        posY += skillbarYOffset.intValue();
        if (magic.shouldRenderAbilities()) {
            if (!magic.getActiveAbilities().isEmpty()) {
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                for (int x = 0; x < 4; ++x) {
                    DragonAbilityInstance ability = magic.fromSlot(x);
                    if (ability != null) {
                        int xPos;
                        int uWidth;
                        int uOffset;
                        if (!ability.isEnabled()) {
                            if (MagicHUD.colors[x].pastDelay && MagicHUD.colors[x].color.equals((Object)Color.ofOpaque((int)-2314))) {
                                MagicHUD.colors[x].delay = disabledColorDelay;
                                MagicHUD.colors[x].pastDelay = false;
                            }
                            MagicHUD.lerpToColor(x, Color.RED);
                        } else if (!ability.hasEnoughMana((Player)player)) {
                            MagicHUD.lerpToColor(x, Color.YELLOW);
                        } else {
                            MagicHUD.colors[x].pastDelay = true;
                            MagicHUD.colors[x].delay = 0.0;
                            MagicHUD.lerpToColor(x, Color.WHITE);
                        }
                        Color outlineColor = MagicHUD.colors[x].color;
                        graphics.setColor(outlineColor.getRedFloat(), outlineColor.getGreenFloat(), outlineColor.getBlueFloat(), outlineColor.getAlphaFloat());
                        if (x == 0) {
                            uOffset = 0;
                            uWidth = 21;
                            xPos = posX;
                        } else if (x != 3) {
                            uOffset = 21;
                            uWidth = 20;
                            xPos = posX + x * 20 + 1;
                        } else {
                            uOffset = 161;
                            uWidth = 21;
                            xPos = posX + x * 20 + 1;
                        }
                        graphics.blit(VANILLA_WIDGETS, xPos, posY - 2, -50, (float)uOffset, 0.0f, uWidth, 22, 256, 256);
                        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                        graphics.blitSprite(ability.getIcon(), posX + x * sizeX + 3, posY + 1, 0, 16, 16);
                        float skillCooldown = ability.value().activation().getCooldown(ability.level());
                        float currentCooldown = (float)ability.getCooldown() - Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
                        if (!(skillCooldown > 0.0f) || !(currentCooldown > 0.0f) || skillCooldown == currentCooldown) continue;
                        float cooldown = Mth.clamp((float)(currentCooldown / skillCooldown), (float)0.0f, (float)1.0f);
                        int boxX = posX + x * sizeX + 3;
                        int boxY = posY + 1;
                        int offset = 16 - (int)(16.0f - cooldown * 16.0f);
                        int color = errorTicks > 0 ? DSColors.withAlpha(15937595, 0.75f) : DSColors.withAlpha(0x262626, 0.75f);
                        graphics.fill(boxX, boxY, boxX + 16, boxY + offset, color);
                        continue;
                    }
                    graphics.blit(VANILLA_WIDGETS, posX + x * 20, posY - 2, -50, (float)(x * 20), 0.0f, 21, 22, 256, 256);
                }
                if (magic.getSelectedAbility() != null) {
                    Color outlineColor = MagicHUD.colors[magic.getSelectedAbilitySlot()].color;
                    graphics.setColor(outlineColor.getRedFloat(), outlineColor.getGreenFloat(), outlineColor.getBlueFloat(), outlineColor.getAlphaFloat());
                }
                graphics.blit(VANILLA_WIDGETS, posX + sizeX * magic.getSelectedAbilitySlot() - 1, posY - 3, 2, 0.0f, 22.0f, 24, 24, 256, 256);
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
            float reservedMana = ManaHandler.getReservedMana((Player)player);
            float maxMana = ManaHandler.getMaxMana((Player)player);
            float currentMana = Math.min(maxMana, ManaHandler.getCurrentMana((Player)player));
            int manaX = i1;
            int manaY = graphics.guiHeight() - sizeY;
            manaX += manabarXOffset.intValue();
            manaY += manabarYOffset.intValue();
            if (magic.getActiveAbilities().isEmpty()) {
                manaY += 20;
            }
            float red = 1.0f;
            float green = 1.0f;
            float blue = 1.0f;
            DragonStateHandler handler = DragonStateProvider.getData((Player)player);
            MiscResources.ManaSprites manaSprites = ((DragonSpecies)handler.species().value()).miscResources().manaSprites().orElse(null);
            if (manaSprites == null) {
                manaSprites = MiscResources.ManaSprites.DEFAULT;
                DSColors.RGB color = DSColors.RGB.of(((DragonSpecies)handler.species().value()).miscResources().primaryColor().getValue());
                red = color.red();
                green = color.green();
                blue = color.blue();
            }
            for (int row = 0; row < 3; ++row) {
                for (int point = 0; point < 9; ++point) {
                    int slot = row * 9 + point;
                    if ((double)slot + 0.5 > (double)currentMana) {
                        int x = manaX + point * 9;
                        int y = manaY - 13 - row * 10;
                        if (maxMana > 0.0f && (double)maxMana >= (double)slot + 0.5) {
                            if (magic.isCasting()) {
                                MagicHUD.blit(graphics, manaSprites.empty(), x, y, 9, 1.0f, 1.0f, 1.0f, 1.0f);
                                continue;
                            }
                            if (player.getAttributeValue(DSAttributes.MANA_REGENERATION) > player.getAttributeBaseValue(DSAttributes.MANA_REGENERATION)) {
                                MagicHUD.blit(graphics, manaSprites.recovery(), x, y, 9, 1.0f, red, green, blue);
                                continue;
                            }
                            MagicHUD.blit(graphics, manaSprites.empty(), x, y, 9, 1.0f, 1.0f, 1.0f, 1.0f);
                            MagicHUD.blit(graphics, manaSprites.recovery(), x, y, 9, deltaCounter, red, green, blue);
                            continue;
                        }
                        if (!(reservedMana > 0.0f) || !((double)reservedMana >= (double)slot + 0.5 - (double)maxMana)) continue;
                        MagicHUD.blit(graphics, manaSprites.reserved(), x, y, 9, 1.0f, red, green, blue);
                        continue;
                    }
                    MagicHUD.blit(graphics, manaSprites.full(), manaX + point * 9, manaY - 13 - row * 10, 9, 1.0f, red, green, blue);
                }
            }
        }
        if (magic.isCasting()) {
            ChanneledActivation channeled;
            Activation manaY;
            DragonAbilityInstance ability = Objects.requireNonNull(magic.fromSlot(magic.getSelectedAbilitySlot()));
            float currentTime = (float)magic.getClientCastTimer() - Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
            int targetTime = ability.value().activation().getCastTime(ability.level());
            if (currentTime <= 0.0f && (manaY = ability.value().activation()) instanceof ChanneledActivation && (channeled = (ChanneledActivation)manaY).maxDuration().isPresent()) {
                currentTime = (float)magic.getClientTickTimer() - Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
                targetTime = (int)channeled.maxDuration().get().calculate(ability.level());
            }
            if (targetTime > 0) {
                graphics.pose().pushPose();
                graphics.flush();
                graphics.pose().scale(0.5f, 0.5f, 0.0f);
                int startX = graphics.guiWidth() / 2 - 49 + castbarXOffset;
                int startY = graphics.guiHeight() - 96 + castbarYOffset;
                float percentage = Math.clamp(1.0f - currentTime / (float)targetTime, 0.0f, 1.0f);
                graphics.pose().translate((float)startX, (float)startY, 0.0f);
                DragonStateHandler handler = DragonStateProvider.getData((Player)player);
                graphics.blit(((DragonSpecies)handler.species().value()).miscResources().castBar(), startX, startY, 0.0f, 0.0f, 196, 47, 196, 47);
                Color color = new Color(DSColors.toARGB(((DragonSpecies)handler.species().value()).miscResources().primaryColor()));
                graphics.setColor(color.getRedFloat(), color.getGreenFloat(), color.getBlueFloat(), color.getAlphaFloat());
                graphics.blit(CAST_BAR_FILL, startX + 2, startY + 41, 0.0f, 0.0f, (int)(191.0f * percentage), 4, 191, 4);
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                graphics.blitSprite(ability.getIcon(), startX + 78, startY + 3, 0, 36, 36);
                graphics.pose().popPose();
            }
        }
        if (errorTicks > 0) {
            graphics.drawString(Minecraft.getInstance().font, errorMessage.getVisualOrderText(), (int)((float)graphics.guiWidth() / 2.0f - (float)Minecraft.getInstance().font.width((FormattedText)errorMessage) / 2.0f), graphics.guiHeight() - 70, -1);
        }
    }

    private static void blit(GuiGraphics graphics, ResourceLocation resource, int x, int y, int size, float alpha, float red, float green, float blue) {
        ((GuiGraphicsAccess)graphics).dragonSurvival$innerBlit(resource, x, x + size, y, y + size, 0, 0.0f, 1.0f, 0.0f, 1.0f, red, green, blue, alpha);
    }

    public static class OutlineColorData {
        private Color color;
        private double delay;
        private boolean pastDelay;

        public OutlineColorData(Color color, double delay, boolean pastDelay) {
            this.color = color;
            this.delay = delay;
            this.pastDelay = pastDelay;
        }
    }
}

