/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.screens;

import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons.DragonBodyButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.TabButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HoverButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.EmoteComponent;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.util.TextRenderUtil;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.network.emotes.SyncEmote;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEmoteKeybindings;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.emotes.DragonEmote;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.emotes.DragonEmoteSet;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(value={Dist.CLIENT})
public class DragonEmoteScreen
extends Screen {
    @Translation(comments={"Reset all emote keybinds"})
    private static final String RESET_ALL_KEYBINDS = Translation.Type.GUI.wrap("emote_screen.reset_all_keybinds");
    @Translation(comments={"Currently binding emote."})
    private static final String CURRENTLY_BINDING = Translation.Type.GUI.wrap("emote_screen.currently_binding");
    @Translation(comments={"Press escape to cancel."})
    private static final String PRESS_ESCAPE_TO_CANCEL = Translation.Type.GUI.wrap("emote_screen.press_escape_to_cancel");
    @Translation(comments={"Stop all emotes"})
    private static final String STOP_ALL_EMOTES = Translation.Type.GUI.wrap("emote_screen.stop_all_emotes");
    @Translation(comments={"\u25a0 This is the emotes menu.", "- The icon on the right will allow you to \u00a76keybind\u00a7r\u00a7f and play the emote without entering this menu.", "- Some emotions can be combined with each other. For example, \u00a76Blend\u00a7r\u00a7f.", "- Flip pages - \u00a76mouse wheel\u00a7r\u00a7f."})
    private static final String EMOTE_INFO = Translation.Type.GUI.wrap("emote_screen.info");
    @Translation(comments={"\u25a0 This is a link to our \u00a76Wiki\u00a7r\u00a77 dedicated to making your own emote!\u00a77"})
    private static final String WIKI = Translation.Type.GUI.wrap("emote_screen.wiki");
    public static final String EMOTE_WIKI_URL = "https://github.com/DragonSurvivalTeam/DragonSurvival/wiki/9.-How-Help-or-Make-Content#-create-a-new-emotion";
    public static final int NO_KEY = -1;
    public static final int REMOVE_KEY = 256;
    private static final int PER_PAGE = 9;
    private final List<EmoteComponent> emoteComponents = new ArrayList<EmoteComponent>();
    public String currentlyKeybinding;
    private int emotePage;
    private int guiLeft;
    private int guiTop;
    private static final ResourceLocation BACKGROUND_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/emote/emote_main.png");
    private static final ResourceLocation DISCORD_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/emote/discord_hover.png");
    private static final ResourceLocation DISCORD_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/emote/discord_main.png");
    private static final ResourceLocation RESET_ALL_KEYBINDS_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/emote/reset_all_keybinds_hover.png");
    private static final ResourceLocation RESET_ALL_KEYBINDS_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/emote/reset_all_keybinds_main.png");
    private static final ResourceLocation RESET_EMOTES_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/emote/reset_emotes_hover.png");
    private static final ResourceLocation RESET_EMOTES_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/emote/reset_emotes_main.png");
    private static final ResourceLocation WIKI_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/emote/wiki_hover.png");
    private static final ResourceLocation WIKI_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/emote/wiki_main.png");
    private static final ResourceLocation INFO_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/emote/info_hover.png");
    private static final ResourceLocation INFO_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/emote/info_main.png");

    public DragonEmoteScreen() {
        super((Component)Component.empty());
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY < 0.0) {
            if (this.emotePage < (int)Math.ceil((double)((DragonEmoteSet)((DragonBody)DragonStateProvider.getData((Player)this.minecraft.player).body().value()).emotes().value()).emotes().size() / 9.0) - 1) {
                ++this.emotePage;
                this.reinitializeEmoteComponents();
            }
        } else if (scrollY > 0.0 && this.emotePage > 0) {
            --this.emotePage;
            this.reinitializeEmoteComponents();
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void setFocused(@Nullable GuiEventListener listener) {
        if (listener instanceof DragonBodyButton) {
            return;
        }
        super.setFocused(listener);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        int startX = this.guiLeft;
        int startY = this.guiTop;
        RenderSystem.enableBlend();
        graphics.blit(BACKGROUND_MAIN, startX, startY, 0, 0, 256, 256);
        RenderSystem.disableBlend();
        super.render(graphics, mouseX, mouseY, partialTick);
        int totalPages = (int)Math.ceil((double)((DragonEmoteSet)((DragonBody)DragonStateProvider.getData((Player)this.minecraft.player).body().value()).emotes().value()).emotes().size() / 9.0);
        TextRenderUtil.drawCenteredScaledText(graphics, this.guiLeft + 75, this.guiTop + 137, 1.0f, this.emotePage + 1 + "/" + totalPages, Color.white.getRGB());
        if (this.currentlyKeybinding != null) {
            TextRenderUtil.drawCenteredScaledText(graphics, this.guiLeft + 75, this.guiTop + 151, 1.0f, Component.translatable((String)CURRENTLY_BINDING).getString(), Color.red.getRGB());
            TextRenderUtil.drawCenteredScaledText(graphics, this.guiLeft + 75, this.guiTop + 161, 1.0f, Component.translatable((String)PRESS_ESCAPE_TO_CANCEL).getString(), Color.red.getRGB());
        }
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    public void init() {
        int xSize = 256;
        int ySize = 256;
        this.guiLeft = this.width - xSize / 2 - 30;
        this.guiTop = (this.height - ySize / 2) / 2 - 20;
        int startX = this.guiLeft - 15;
        int startY = this.guiTop + 30;
        TabButton.addTabButtonsToScreen(this, startX + 17, startY - 56, TabButton.TabButtonType.EMOTES_TAB);
        this.reinitializeEmoteComponents();
        HoverButton resetEmotesButton = new HoverButton(startX + 19, startY - 26, 14, 14, 14, 14, RESET_EMOTES_MAIN, RESET_EMOTES_HOVER, button -> {
            DragonEntity dragon = ClientDragonRenderer.getDragon((Player)Minecraft.getInstance().player);
            if (dragon == null) {
                return;
            }
            dragon.stopAllEmotes();
        });
        resetEmotesButton.setTooltip(Tooltip.create((Component)Component.translatable((String)STOP_ALL_EMOTES)));
        this.addRenderableWidget((GuiEventListener)resetEmotesButton);
        HoverButton infoButton = new HoverButton(startX + 68, startY - 26, 14, 14, 14, 14, INFO_MAIN, INFO_HOVER, button -> {});
        infoButton.setTooltip(Tooltip.create((Component)Component.translatable((String)EMOTE_INFO)));
        this.addRenderableWidget((GuiEventListener)infoButton);
        HoverButton discordButton = new HoverButton(startX + 83, startY - 26, 14, 14, 14, 14, DISCORD_MAIN, DISCORD_HOVER, ConfirmLinkScreen.confirmLink((Screen)this, (String)"https://discord.gg/8SsB8ar"));
        discordButton.setTooltip(Tooltip.create((Component)Component.translatable((String)LangKey.DISCORD)));
        this.addRenderableWidget((GuiEventListener)discordButton);
        HoverButton wikiButton = new HoverButton(startX + 98, startY - 26, 14, 14, 14, 14, WIKI_MAIN, WIKI_HOVER, ConfirmLinkScreen.confirmLink((Screen)this, (String)EMOTE_WIKI_URL));
        wikiButton.setTooltip(Tooltip.create((Component)Component.translatable((String)WIKI)));
        this.addRenderableWidget((GuiEventListener)wikiButton);
        HoverButton resetAllKeybindsButton = new HoverButton(startX + 150, startY - 26, 14, 14, 14, 14, RESET_ALL_KEYBINDS_MAIN, RESET_ALL_KEYBINDS_HOVER, button -> {
            DSEmoteKeybindings.EMOTE_KEYBINDS.clear();
            this.reinitializeEmoteComponents();
        });
        resetAllKeybindsButton.setTooltip(Tooltip.create((Component)Component.translatable((String)RESET_ALL_KEYBINDS)));
        this.addRenderableWidget((GuiEventListener)resetAllKeybindsButton);
    }

    private void reinitializeEmoteComponents() {
        DragonStateHandler handler;
        List<DragonEmote> emotes;
        int emoteIndex;
        for (EmoteComponent emoteComponent : this.emoteComponents) {
            for (AbstractWidget button : emoteComponent.children()) {
                this.removeWidget((GuiEventListener)button);
            }
        }
        this.emoteComponents.clear();
        for (int i = 0; i < 9 && (emoteIndex = 9 * this.emotePage + i) < (emotes = ((DragonEmoteSet)((DragonBody)(handler = DragonStateProvider.getData((Player)Minecraft.getInstance().player)).body().value()).emotes().value()).emotes()).size(); ++i) {
            this.emoteComponents.add(new EmoteComponent(this, this.guiLeft + 10, this.guiTop + 30 + i * 12, emotes.get(9 * this.emotePage + i)));
        }
    }

    public static void addEmote(String key) {
        DragonEntity dragon = ClientDragonRenderer.getDragon((Player)Minecraft.getInstance().player);
        if (dragon == null) {
            return;
        }
        DragonStateHandler handler = DragonStateProvider.getData((Player)Minecraft.getInstance().player);
        DragonEmote emote = ((DragonEmoteSet)((DragonBody)handler.body().value()).emotes().value()).getEmote(key);
        dragon.beginPlayingEmote(emote);
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncEmote(Minecraft.getInstance().player.getId(), emote, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.currentlyKeybinding != null) {
            this.currentlyKeybinding = null;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @SubscribeEvent
    public static void onKey(InputEvent.MouseButton.Pre event) {
        if (event.getAction() == 1) {
            DragonEmoteScreen.onKey(event.getButton());
        }
    }

    @SubscribeEvent
    public static void onKey(InputEvent.Key event) {
        if (event.getAction() == 1) {
            DragonEmoteScreen.onKey(event.getKey());
        }
    }

    private static void onKey(int keyCode) {
        Minecraft instance = Minecraft.getInstance();
        if (instance.player == null || instance.level == null) {
            return;
        }
        LocalPlayer player = instance.player;
        if (player.isSpectator() || !DragonStateProvider.isDragon((Entity)player)) {
            return;
        }
        if (keyCode == -1) {
            return;
        }
        Screen screen = instance.screen;
        if (screen instanceof DragonEmoteScreen) {
            DragonEmoteScreen emoteScreen = (DragonEmoteScreen)screen;
            if (emoteScreen.currentlyKeybinding != null) {
                if (keyCode == 256) {
                    DSEmoteKeybindings.EMOTE_KEYBINDS.remove(emoteScreen.currentlyKeybinding);
                } else {
                    DSEmoteKeybindings.EMOTE_KEYBINDS.put(keyCode, emoteScreen.currentlyKeybinding);
                }
                for (EmoteComponent emoteComponent : emoteScreen.emoteComponents) {
                    emoteComponent.refreshKeybinding();
                }
                emoteScreen.currentlyKeybinding = null;
            }
        } else {
            String emote = DSEmoteKeybindings.EMOTE_KEYBINDS.get(keyCode);
            if (emote != null) {
                DragonEmoteScreen.addEmote(emote);
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

