/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.screens;

import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.dragon_editor.buttons.DragonBodyButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.GrowthCrystalButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.PenaltyButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.TabButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HoverButton;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.BarComponent;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.DietMenuComponent;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.components.ScrollableComponent;
import by.dragonsurvivalteam.dragonsurvival.client.util.TextRenderUtil;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscResources;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.StageResources;
import by.dragonsurvivalteam.dragonsurvival.compat.ModCheck;
import by.dragonsurvivalteam.dragonsurvival.compat.jei.JEIPlugin;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.FlightData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.data_maps.DietEntryCache;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.FlightEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragonSpeciesScreen
extends Screen {
    @Translation(comments={"\u25a0 In order to allow other players to mount you, you must crouch and they can right click on you to mount.", "\n\u00a76\u25a0 Human players can ride you at below or equal to scale %s\u00a7r\u00a77", "\n\u00a76\u25a0 Dragon players can ride you at below or equal to scale %s\u00a7r\u00a77"})
    private static final String RIDING_INFO = Translation.Type.GUI.wrap("dragon_species_screen.riding_info");
    @Translation(comments={"\u25a0 This species cannot gain the ability to fly."})
    public static final String FLIGHT_CANNOT_GAIN = Translation.Type.GUI.wrap("dragon_species_screen.flight_cannot_gain");
    @Translation(comments={"\u25a0 You currently cannot fly."})
    public static final String FLIGHT_CANNOT_FLY = Translation.Type.GUI.wrap("dragon_species_screen.flight_cannot_fly_or_spin");
    @Translation(comments={"\u25a0 You currently can fly."})
    public static final String FLIGHT_CAN_FLY = Translation.Type.GUI.wrap("dragon_species_screen.flight_can_fly");
    @Translation(comments={"\u25a0 You currently can spin."})
    public static final String FLIGHT_CAN_SPIN = Translation.Type.GUI.wrap("dragon_species_screen.flight_can_spin");
    @Translation(comments={"\u25a0 Players cannot ride this species."})
    private static final String RIDING_DISABLED = Translation.Type.GUI.wrap("dragon_species_screen.riding_disabled");
    @Translation(comments={"This species has no penalties."})
    private static final String NO_PENALTIES = Translation.Type.GUI.wrap("dragon_species_screen.no_penalties");
    @Translation(comments={"This species has no special diet."})
    private static final String NO_DIET = Translation.Type.GUI.wrap("dragon_species_screen.no_diet");
    private static final ResourceLocation BACKGROUND_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/species/species_background.png");
    private static final ResourceLocation RIDING_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/species/riding_hover.png");
    private static final ResourceLocation RIDING_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/species/riding_main.png");
    private static final ResourceLocation WINGS_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/species/wing_hover.png");
    private static final ResourceLocation WINGS_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/species/wing_main.png");
    private static final ResourceLocation PENALTIES_LEFT_ARROW_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/species/penalties_left_arrow_hover.png");
    private static final ResourceLocation PENALTIES_LEFT_ARROW_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/species/penalties_left_arrow_main.png");
    private static final ResourceLocation PENALTIES_RIGHT_ARROW_HOVER = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/species/penalties_right_arrow_hover.png");
    private static final ResourceLocation PENALTIES_RIGHT_ARROW_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/species/penalties_right_arrow_main.png");
    public Holder<DragonSpecies> species;
    private Holder<DragonStage> stage;
    private final List<ScrollableComponent> scrollableComponents = new ArrayList<ScrollableComponent>();
    private DietMenuComponent dietMenu;
    private HoverButton growthButton;
    private ExtendedButton speciesBanner;
    private ScrollableComponent crystalBar;
    private int guiLeft;
    private int guiTop;
    private int growthTooltipScroll;

    public DragonSpeciesScreen() {
        super((Component)Component.empty());
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (ScrollableComponent component : this.scrollableComponents) {
            if (component == this.crystalBar) continue;
            component.scroll(mouseX, mouseY, scrollX, scrollY);
        }
        this.growthTooltipScroll = this.growthButton.isHovered() ? (this.growthTooltipScroll += (int)(-scrollY)) : 0;
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.dietMenu != null && this.dietMenu.getHovered() != null && ModCheck.isModLoaded("jei")) {
            return JEIPlugin.handleKeyPress(InputConstants.getKey((int)keyCode, (int)scanCode), this.dietMenu.getHovered());
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void setFocused(@Nullable GuiEventListener listener) {
        if (listener instanceof DragonBodyButton) {
            return;
        }
        super.setFocused(listener);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        this.renderBlurredBackground(partialTick);
        int startX = this.guiLeft + 23;
        int startY = this.guiTop - 13;
        DragonStateHandler data = DragonStateProvider.getData((Player)this.minecraft.player);
        graphics.blit(BACKGROUND_MAIN, startX, startY, 0, 0, 256, 256);
        for (ScrollableComponent component : this.scrollableComponents) {
            component.update();
        }
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        this.speciesBanner.render(graphics, mouseX, mouseY, partialTick);
        for (Renderable renderable : this.renderables) {
            if (renderable == this.speciesBanner) continue;
            renderable.render(graphics, mouseX, mouseY, partialTick);
        }
    }

    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    public void init() {
        this.species = DragonStateProvider.getData((Player)this.minecraft.player).species();
        this.stage = DragonStateProvider.getData((Player)this.minecraft.player).stage();
        int xSize = 256;
        int ySize = 256;
        this.guiLeft = (this.width - xSize) / 2;
        this.guiTop = (this.height - ySize / 2) / 2;
        int startX = this.guiLeft + 13;
        int startY = this.guiTop + 17;
        TabButton.addTabButtonsToScreen(this, startX + 17, startY - 56, TabButton.TabButtonType.SPECIES_TAB);
        final DragonStateHandler data = DragonStateProvider.getData((Player)this.minecraft.player);
        if (DietEntryCache.isEmpty(this.species)) {
            ExtendedButton noDietText = new ExtendedButton(this, startX + 77, startY + 30, 140, 20, (Component)Component.empty(), button -> {}){

                public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
                    FormattedText buttonText = Minecraft.getInstance().font.ellipsize((FormattedText)this.getMessage(), this.width + 26);
                    TextRenderUtil.drawScaledText(graphics, this.getX(), (float)this.getY() + (float)(this.height - 8) / 2.0f, 0.8f, buttonText.getString(), this.getFGColor());
                }
            };
            noDietText.setMessage((Component)Component.translatable((String)NO_DIET));
            this.addRenderableOnly((Renderable)noDietText);
        } else {
            this.dietMenu = new DietMenuComponent(this.species, startX + 78, startY + 10);
            this.scrollableComponents.add(this.dietMenu);
            this.renderables.add(this.dietMenu);
        }
        this.speciesBanner = new ExtendedButton(startX + 17, startY - 22, 49, 147, (Component)Component.empty(), button -> {}){

            private boolean isTop(double mouseY) {
                return mouseY > (double)(this.getY() + 6) && mouseY < (double)(this.getY() + 100);
            }

            public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
                if (this.isHovered() && this.isTop(mouseY)) {
                    graphics.blit(((DragonSpecies)data.species().value()).miscResources().altarBanner(), this.getX(), this.getY(), 0.0f, 0.0f, 49, 147, 49, 294);
                    ArrayList<Either> components = new ArrayList<Either>();
                    components.addFirst(Either.left((Object)Component.translatable((String)Translation.Type.DRAGON_SPECIES_INVENTORY_DESCRIPTION.wrap(DragonSpeciesScreen.this.species.getKey().location()))));
                    graphics.renderComponentTooltipFromElements(Minecraft.getInstance().font, components, mouseX, mouseY, ItemStack.EMPTY);
                } else {
                    graphics.blit(((DragonSpecies)data.species().value()).miscResources().altarBanner(), this.getX(), this.getY(), 0.0f, 147.0f, 49, 147, 49, 294);
                }
            }
        };
        this.addRenderableWidget((GuiEventListener)this.speciesBanner);
        HoverButton wingButton = new HoverButton(startX + 79, startY - 19, 20, WINGS_MAIN, WINGS_HOVER);
        this.addRenderableWidget((GuiEventListener)wingButton);
        FlightData flightData = FlightData.getData((Player)this.minecraft.player);
        MutableComponent flightTooltip = Component.empty();
        if (flightData.hasFlight) {
            flightTooltip = Component.translatable((String)FLIGHT_CAN_FLY);
        }
        if (flightData.hasSpin) {
            if (flightTooltip.getContents() != PlainTextContents.EMPTY) {
                flightTooltip.append("\n");
            }
            flightTooltip.append((Component)Component.translatable((String)FLIGHT_CAN_SPIN));
        }
        if (!flightData.hasFlight && !flightData.hasSpin) {
            if (!MagicData.getData((Player)this.minecraft.player).checkAbility((Player)this.minecraft.player, FlightEffect.class, MagicData.AbilityCheck.HAS_EFFECT)) {
                flightTooltip.append((Component)Component.translatable((String)FLIGHT_CANNOT_GAIN));
            } else {
                flightTooltip.append((Component)Component.translatable((String)FLIGHT_CANNOT_FLY));
            }
        }
        wingButton.setTooltip(Tooltip.create((Component)flightTooltip));
        StageResources.GrowthIcon growthIcon = StageResources.getGrowthIcon(data.species(), data.stageKey());
        this.growthButton = new HoverButton(startX + 99, startY - 21, 20, growthIcon.icon(), growthIcon.hoverIcon(), () -> {
            DragonStateHandler handler = DragonStateProvider.getData((Player)this.minecraft.player);
            Pair<List<Either<FormattedText, TooltipComponent>>, Integer> growthDescriptionResult = handler.getGrowthDescription(this.growthTooltipScroll);
            List components = (List)growthDescriptionResult.getFirst();
            this.growthTooltipScroll = (Integer)growthDescriptionResult.getSecond();
            return components;
        });
        this.addRenderableWidget((GuiEventListener)this.growthButton);
        List<Holder<DragonStage>> stages = data.getStagesSortedByProgression((HolderLookup.Provider)this.minecraft.player.registryAccess());
        if (!stages.isEmpty()) {
            List<AbstractWidget> crystals = stages.stream().map(stage -> new GrowthCrystalButton(0, 0, (Holder<DragonStage>)stage)).toList();
            MiscResources textures = ((DragonSpecies)data.species().value()).miscResources();
            this.crystalBar = new BarComponent(this, startX + 130, startY - 19, 4, crystals, 2, -11, 39, 1, 12, 16, textures.growthLeftArrow().hoverIcon(), textures.growthLeftArrow().icon(), textures.growthRightArrow().hoverIcon(), textures.growthRightArrow().icon());
            this.scrollableComponents.add(this.crystalBar);
        }
        HoverButton ridingButton = new HoverButton(startX + 186, startY - 18, 16, RIDING_MAIN, RIDING_HOVER);
        if (((DragonBody)data.body().value()).mountingOffsets().isPresent()) {
            ridingButton.setTooltip(Tooltip.create((Component)Component.translatable((String)RIDING_INFO, (Object[])new Object[]{String.format("%.2f", Float.valueOf(this.minecraft.player.getScale() * 0.8f)), String.format("%.2f", Float.valueOf(this.minecraft.player.getScale() * 0.5f))})));
        } else {
            ridingButton.setTooltip(Tooltip.create((Component)Component.translatable((String)RIDING_DISABLED)));
        }
        this.addRenderableWidget((GuiEventListener)ridingButton);
        DragonBodyButton bodyTypeButton = new DragonBodyButton(this, startX + 29, startY + 101, 25, 25, data.body(), DragonBodyButton.LockedReason.NONE, button -> {});
        this.addRenderableWidget((GuiEventListener)bodyTypeButton);
        List<AbstractWidget> penalties = ((DragonSpecies)data.species().value()).penalties().stream().filter(penalty -> ((DragonPenalty)penalty.value()).icon().isPresent()).map(penalty -> new PenaltyButton(0, 0, (Holder<DragonPenalty>)penalty)).toList();
        if (!penalties.isEmpty()) {
            this.scrollableComponents.add(new BarComponent(this, startX + 85, startY + 85, 3, penalties, 5, -10, 116, 10, 9, 16, PENALTIES_LEFT_ARROW_HOVER, PENALTIES_LEFT_ARROW_MAIN, PENALTIES_RIGHT_ARROW_HOVER, PENALTIES_RIGHT_ARROW_MAIN));
        } else {
            ExtendedButton noPenaltiesText = new ExtendedButton(this, startX + 82, startY + 100, 140, 10, (Component)Component.empty(), button -> {}){

                public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
                    FormattedText buttonText = Minecraft.getInstance().font.ellipsize((FormattedText)this.getMessage(), this.width + 26);
                    TextRenderUtil.drawScaledText(graphics, this.getX(), (float)this.getY() + (float)(this.height - 8) / 2.0f, 0.8f, buttonText.getString(), this.getFGColor());
                }
            };
            noPenaltiesText.setMessage((Component)Component.translatable((String)NO_PENALTIES));
            this.addRenderableOnly((Renderable)noPenaltiesText);
        }
    }

    public void tick() {
        DragonStateHandler data = DragonStateProvider.getData((Player)this.minecraft.player);
        if (this.species == null) {
            this.onClose();
        }
        if (this.species != data.species() || this.stage != data.stage()) {
            this.species = data.species();
            this.stage = data.stage();
            this.clearWidgets();
            this.init();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

