/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.screens;

import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.TimeComponent;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.HelpButton;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.SourceOfMagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.server.containers.SourceOfMagicContainer;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.SourceOfMagicBlockEntity;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class SourceOfMagicScreen
extends AbstractContainerScreen<SourceOfMagicContainer> {
    @Translation(comments={"\u25a0 This source of magic can be charged with with the following items:"})
    private static final String HELP = Translation.Type.GUI.wrap("source_of_magic.help");
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/source_of_magic/source_of_magic_ui.png");
    private static final ResourceLocation CAVE_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/source_of_magic/cave_source_of_magic_0.png");
    private static final ResourceLocation CAVE_FILLED = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/source_of_magic/cave_source_of_magic_1.png");
    private static final ResourceLocation FOREST_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/source_of_magic/forest_source_of_magic_0.png");
    private static final ResourceLocation FOREST_FILLED = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/source_of_magic/forest_source_of_magic_1.png");
    private static final ResourceLocation SEA_MAIN = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/source_of_magic/sea_source_of_magic_0.png");
    private static final ResourceLocation SEA_FILLED = ResourceLocation.fromNamespaceAndPath((String)"dragonsurvival", (String)"textures/gui/source_of_magic/sea_source_of_magic_1.png");
    private static final int MAX_SHOWN = 5;
    private HelpButton helpButton;
    private final SourceOfMagicBlockEntity blockEntity;
    private int scrollAmount;

    public SourceOfMagicScreen(SourceOfMagicContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.blockEntity = container.blockEntity;
    }

    protected void init() {
        super.init();
        this.helpButton = new HelpButton(this.leftPos + 12, this.topPos + 12, 12, 12, this.getTooltip());
        this.addRenderableWidget((GuiEventListener)this.helpButton);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.helpButton.isHovered()) {
            int oldScroll = this.scrollAmount;
            this.scrollAmount = Math.clamp((long)(this.scrollAmount + (int)(-scrollY)), 0, this.maxScroll());
            if (oldScroll != this.scrollAmount) {
                this.helpButton.setTooltip(this.getTooltip());
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        boolean hasItem = this.blockEntity.getCurrentDuration() > 0;
        Block block = this.blockEntity.getBlockState().getBlock();
        ResourceLocation resource = null;
        if (block == DSBlocks.CAVE_SOURCE_OF_MAGIC.get()) {
            resource = hasItem ? CAVE_FILLED : CAVE_MAIN;
        } else if (block == DSBlocks.FOREST_SOURCE_OF_MAGIC.get()) {
            resource = hasItem ? FOREST_FILLED : FOREST_MAIN;
        } else if (block == DSBlocks.SEA_SOURCE_OF_MAGIC.get()) {
            ResourceLocation resourceLocation = resource = hasItem ? SEA_FILLED : SEA_MAIN;
        }
        if (resource != null) {
            guiGraphics.blit(resource, this.leftPos + 8, this.topPos + 8, 0.0f, 0.0f, 160, 49, 160, 49);
        }
    }

    private List<Either<FormattedText, TooltipComponent>> getTooltip() {
        ArrayList<Either<FormattedText, TooltipComponent>> tooltip = new ArrayList<Either<FormattedText, TooltipComponent>>();
        List<SourceOfMagicData.Consumable> consumables = this.blockEntity.getConsumables();
        consumables.sort(Comparator.comparingInt(SourceOfMagicData.Consumable::duration).reversed());
        for (int i = this.scrollAmount; i < consumables.size() && tooltip.size() != 5; ++i) {
            SourceOfMagicData.Consumable consumable = consumables.get(i);
            tooltip.add((Either<FormattedText, TooltipComponent>)Either.right((Object)new TimeComponent(consumable.item(), consumable.duration(), TimeComponent.DEFAULT)));
        }
        tooltip.addFirst(Either.left((Object)Component.translatable((String)HELP)));
        return tooltip;
    }

    private int maxScroll() {
        if (this.blockEntity == null) {
            return 0;
        }
        return Math.max(0, this.blockEntity.consumableAmount() - 5);
    }
}

