/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonAbilityScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons.generic.ClickHoverButton;
import by.dragonsurvivalteam.dragonsurvival.network.magic.AttemptManualUpgrade;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.ExperiencePointsUpgrade;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class LevelButton
extends ClickHoverButton {
    private static final ResourceLocation DOWNGRADE_CLICK = DragonSurvival.res("textures/gui/ability_screen/arrow_left_upgrade_click.png");
    private static final ResourceLocation DOWNGRADE_HOVER = DragonSurvival.res("textures/gui/ability_screen/arrow_left_upgrade_hover.png");
    private static final ResourceLocation DOWNGRADE_MAIN = DragonSurvival.res("textures/gui/ability_screen/arrow_left_upgrade_main.png");
    public static final ResourceLocation UPGRADE_CLICK = DragonSurvival.res("textures/gui/ability_screen/arrow_right_upgrade_click.png");
    private static final ResourceLocation UPGRADE_HOVER = DragonSurvival.res("textures/gui/ability_screen/arrow_right_upgrade_hover.png");
    private static final ResourceLocation UPGRADE_MAIN = DragonSurvival.res("textures/gui/ability_screen/arrow_right_upgrade_main.png");
    private static final int WIDTH = 16;
    private static final int HEIGHT = 16;
    private final Type type;
    private final DragonAbilityInstance ability;

    public void resetDimensions() {
        this.width = 16;
        this.height = 16;
    }

    public LevelButton(Type type, DragonAbilityInstance ability, int xPos, int yPos) {
        super(xPos, yPos, 16, 16, 0, 0, 16, 16, (Component)Component.empty(), button -> {
            switch (type.ordinal()) {
                case 0: {
                    PacketDistributor.sendToServer((CustomPacketPayload)new AttemptManualUpgrade(ability.key(), ExperiencePointsUpgrade.Type.DOWNGRADE), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    break;
                }
                case 1: {
                    PacketDistributor.sendToServer((CustomPacketPayload)new AttemptManualUpgrade(ability.key(), ExperiencePointsUpgrade.Type.UPGRADE), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }, type.click, type.hover, type.main);
        this.type = type;
        this.ability = ability;
    }

    public int getExperienceModification() {
        LocalPlayer player = Objects.requireNonNull(Minecraft.getInstance().player);
        if (player.hasInfiniteMaterials()) {
            return 0;
        }
        return this.ability.value().upgrade().map(type -> {
            if (type instanceof ExperiencePointsUpgrade) {
                ExperiencePointsUpgrade upgrade = (ExperiencePointsUpgrade)type;
                return upgrade.getExperience(this.ability, this.getExperienceType());
            }
            return 0;
        }).orElse(0);
    }

    public boolean canModify() {
        LocalPlayer player = Objects.requireNonNull(Minecraft.getInstance().player);
        return this.ability.value().upgrade().map(type -> {
            if (type instanceof ExperiencePointsUpgrade) {
                ExperiencePointsUpgrade upgrade = (ExperiencePointsUpgrade)type;
                return upgrade.canModifyLevel((Player)player, this.ability, this.getExperienceType());
            }
            return false;
        }).orElse(false);
    }

    private ExperiencePointsUpgrade.Type getExperienceType() {
        return this.type == Type.UPGRADE ? ExperiencePointsUpgrade.Type.UPGRADE : ExperiencePointsUpgrade.Type.DOWNGRADE;
    }

    @Override
    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.canModify()) {
            return;
        }
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof DragonAbilityScreen) {
            DragonAbilityScreen abilityScreen = (DragonAbilityScreen)screen;
            if (this.isHovered()) {
                abilityScreen.lastHoveredLevelButton = this;
            }
        }
    }

    public void onPress() {
        if (this.canModify()) {
            super.onPress();
        }
    }

    public static enum Type {
        DOWNGRADE(DOWNGRADE_CLICK, DOWNGRADE_HOVER, DOWNGRADE_MAIN),
        UPGRADE(UPGRADE_CLICK, UPGRADE_HOVER, UPGRADE_MAIN);

        public final ResourceLocation click;
        public final ResourceLocation hover;
        public final ResourceLocation main;

        private Type(ResourceLocation click, ResourceLocation hover, ResourceLocation main) {
            this.click = click;
            this.hover = hover;
            this.main = main;
        }
    }
}

