/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.buttons;

import by.dragonsurvivalteam.dragonsurvival.client.gui.hud.MagicHUD;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonAbilityScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonEmoteScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonInventoryScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonSkinsScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.DragonSpeciesScreen;
import by.dragonsurvivalteam.dragonsurvival.client.gui.screens.InventoryScreenHandler;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.ScreenAccessor;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.DSLanguageProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class TabButton
extends Button {
    private final TabButtonType tabButtonType;
    private final Screen parent;

    public TabButton(int x, int y, TabButtonType tabButton, Screen parent) {
        super(x, y, 28, 32, (Component)Component.empty(), action -> {}, DEFAULT_NARRATION);
        this.tabButtonType = tabButton;
        this.parent = parent;
        this.setTooltip(Tooltip.create((Component)DSLanguageProvider.enumValue(tabButton)));
    }

    public void onPress() {
        if (this.isCurrent()) {
            return;
        }
        switch (this.tabButtonType.ordinal()) {
            case 0: {
                InventoryScreenHandler.openDragonInventory();
                break;
            }
            case 1: {
                Minecraft.getInstance().setScreen((Screen)new DragonAbilityScreen());
                break;
            }
            case 3: {
                Minecraft.getInstance().setScreen((Screen)new DragonSkinsScreen());
                break;
            }
            case 2: {
                Minecraft.getInstance().setScreen((Screen)new DragonSpeciesScreen());
                break;
            }
            case 4: {
                Minecraft.getInstance().setScreen((Screen)new DragonEmoteScreen());
            }
        }
    }

    public boolean isCurrent() {
        return switch (this.tabButtonType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this.parent instanceof DragonInventoryScreen || this.parent instanceof InventoryScreen) {
                    yield true;
                }
                yield false;
            }
            case 1 -> this.parent instanceof DragonAbilityScreen;
            case 3 -> this.parent instanceof DragonSkinsScreen;
            case 2 -> this.parent instanceof DragonSpeciesScreen;
            case 4 -> this.parent instanceof DragonEmoteScreen;
        };
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float p_230431_4_) {
        if (this.isCurrent()) {
            guiGraphics.blit(MagicHUD.WIDGET_TEXTURES, this.getX(), this.getY(), 28, 0, 28, 32);
        } else if (this.isHovered()) {
            guiGraphics.blit(MagicHUD.WIDGET_TEXTURES, this.getX(), this.getY(), 84, 0, 28, 32);
        } else {
            guiGraphics.blit(MagicHUD.WIDGET_TEXTURES, this.getX(), this.getY(), 56, 0, 28, 32);
        }
        if (this.isHovered() || this.isCurrent()) {
            guiGraphics.blit(MagicHUD.WIDGET_TEXTURES, this.getX() + 2, this.getY() + 2 + (this.isCurrent() ? 2 : 0), this.tabButtonType.ordinal() * 24, 67, 24, 24);
        } else {
            guiGraphics.blit(MagicHUD.WIDGET_TEXTURES, this.getX() + 2, this.getY() + 2 + (this.isCurrent() ? 2 : 0), this.tabButtonType.ordinal() * 24, 41, 24, 24);
        }
    }

    public static void addTabButtonsToScreen(Screen screen, int offsetX, int offsetY, TabButtonType selectedButton) {
        boolean ignoreAbilityTab = ((MagicData)Minecraft.getInstance().player.getData(DSDataAttachments.MAGIC)).getAbilities().isEmpty();
        if (ignoreAbilityTab) {
            for (int i = 0; i < TabButtonType.values().length; ++i) {
                TabButtonType tabButton = TabButtonType.values()[i];
                if (tabButton == TabButtonType.ABILITY_TAB) continue;
                int additionalOffset = 0;
                if (tabButton.ordinal() > TabButtonType.ABILITY_TAB.ordinal()) {
                    additionalOffset = -28;
                }
                if (tabButton == selectedButton) {
                    ((ScreenAccessor)screen).dragonSurvival$addRenderableWidget(new TabButton(offsetX + additionalOffset + 1 + i * 28, offsetY - 2, tabButton, screen));
                    continue;
                }
                ((ScreenAccessor)screen).dragonSurvival$addRenderableWidget(new TabButton(offsetX + additionalOffset + i * 28, offsetY, tabButton, screen));
            }
        } else {
            for (int i = 0; i < TabButtonType.values().length; ++i) {
                TabButtonType tabButton = TabButtonType.values()[i];
                if (tabButton == selectedButton) {
                    ((ScreenAccessor)screen).dragonSurvival$addRenderableWidget(new TabButton(offsetX + 1 + i * 28, offsetY - 2, tabButton, screen));
                    continue;
                }
                ((ScreenAccessor)screen).dragonSurvival$addRenderableWidget(new TabButton(offsetX + i * 28, offsetY, tabButton, screen));
            }
        }
    }

    public static enum TabButtonType {
        INVENTORY_TAB,
        ABILITY_TAB,
        SPECIES_TAB,
        SKINS_TAB,
        EMOTES_TAB;

    }
}

