/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.models;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.DragonEditorHandler;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonStageCustomization;
import by.dragonsurvivalteam.dragonsurvival.client.skins.DragonSkins;
import by.dragonsurvivalteam.dragonsurvival.client.util.FakeClientPlayer;
import by.dragonsurvivalteam.dragonsurvival.client.util.RenderingUtils;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.StageResources;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.HunterData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MovementData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.util.AnimationUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.loading.math.MathParser;
import software.bernie.geckolib.model.GeoModel;

public class DragonModel
extends GeoModel<DragonEntity> {
    private static final double DELTA_YAW_PITCH_FACTOR = 0.2;
    private static final double DELTA_MOVEMENT_FACTOR = 10.0;
    private final ResourceLocation defaultTexture = DragonSurvival.res("textures/dragon_dragon/newborn.png");
    private ResourceLocation overrideTexture;

    public void applyMolangQueries(AnimationState<DragonEntity> animationState, double currentTick) {
        double verticalVelocityAvg;
        double headPitchAvg;
        double headYawAvg;
        double bodyYawAvg;
        super.applyMolangQueries(animationState, currentTick);
        DragonEntity dragon = (DragonEntity)animationState.getAnimatable();
        Player player = dragon.getPlayer();
        if (player == null) {
            return;
        }
        MovementData movement = MovementData.getData((Entity)player);
        float deltaTick = Minecraft.getInstance().getTimer().getRealtimeDeltaTicks();
        float partialDeltaTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        if (dragon.neckLocked) {
            MathParser.setVariable((String)"query.head_yaw", () -> 0.0);
            MathParser.setVariable((String)"query.head_pitch", () -> 0.0);
        } else {
            MathParser.setVariable((String)"query.head_yaw", () -> movement.headYaw);
            MathParser.setVariable((String)"query.head_pitch", () -> movement.headPitch);
        }
        double gravity = player.getAttributeValue(Attributes.GRAVITY);
        MathParser.setVariable((String)"query.gravity", () -> gravity);
        if (!dragon.isInInventory) {
            boolean removedElement;
            double bodyYawChange = Functions.angleDifference(movement.bodyYaw, movement.bodyYawLastFrame) / (double)deltaTick * 0.2;
            double headYawChange = Functions.angleDifference(movement.headYaw, movement.headYawLastFrame) / (double)deltaTick * 0.2;
            double headPitchChange = Functions.angleDifference(movement.headPitch, movement.headPitchLastFrame) / (double)deltaTick * 0.2;
            double verticalVelocity = Mth.lerp((double)partialDeltaTick, (double)movement.deltaMovementLastFrame.y, (double)movement.deltaMovement.y) * 10.0;
            verticalVelocity *= (double)(1.0f - Mth.abs((float)Mth.clampedMap((float)movement.prevXRot, (float)-90.0f, (float)90.0f, (float)-1.0f, (float)1.0f)));
            float deltaTickFor60FPS = AnimationUtils.getDeltaTickFor60FPS();
            int removeSize = (int)(10.0f / deltaTickFor60FPS);
            if (dragon.clearVerticalVelocity) {
                dragon.verticalVelocityHistory.clear();
                while (dragon.verticalVelocityHistory.size() < removeSize) {
                    dragon.verticalVelocityHistory.add(0.0);
                }
            }
            do {
                removedElement = false;
                if (dragon.bodyYawHistory.size() > removeSize) {
                    dragon.bodyYawHistory.removeFirst();
                    removedElement = true;
                }
                if (dragon.headYawHistory.size() > removeSize) {
                    dragon.headYawHistory.removeFirst();
                    removedElement = true;
                }
                if (dragon.headPitchHistory.size() > removeSize) {
                    dragon.headPitchHistory.removeFirst();
                    removedElement = true;
                }
                if (dragon.verticalVelocityHistory.size() <= removeSize) continue;
                dragon.verticalVelocityHistory.removeFirst();
                removedElement = true;
            } while (removedElement);
            dragon.bodyYawHistory.add(bodyYawChange);
            dragon.headYawHistory.add(headYawChange);
            dragon.headPitchHistory.add(headPitchChange);
            dragon.verticalVelocityHistory.add(verticalVelocity);
            bodyYawAvg = dragon.bodyYawHistory.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
            headYawAvg = dragon.headYawHistory.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
            headPitchAvg = dragon.headPitchHistory.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
            verticalVelocityAvg = dragon.verticalVelocityHistory.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
        } else {
            bodyYawAvg = 0.0;
            headYawAvg = 0.0;
            headPitchAvg = 0.0;
            verticalVelocityAvg = 0.0;
        }
        bodyYawAvg = Double.isNaN(bodyYawAvg) ? 0.0 : bodyYawAvg;
        headYawAvg = Double.isNaN(headYawAvg) ? 0.0 : headYawAvg;
        headPitchAvg = Double.isNaN(headPitchAvg) ? 0.0 : headPitchAvg;
        verticalVelocityAvg = Double.isNaN(verticalVelocityAvg) ? 0.0 : verticalVelocityAvg;
        double lerpRate = Math.min(1.0f, deltaTick);
        dragon.currentBodyYawChange = Mth.lerp((double)lerpRate, (double)dragon.currentBodyYawChange, (double)bodyYawAvg);
        dragon.currentHeadYawChange = Mth.lerp((double)lerpRate, (double)dragon.currentHeadYawChange, (double)headYawAvg);
        dragon.currentHeadPitchChange = Mth.lerp((double)lerpRate, (double)dragon.currentHeadPitchChange, (double)headPitchAvg);
        if (dragon.clearVerticalVelocity) {
            dragon.currentTailMotionUp = 0.0;
            dragon.clearVerticalVelocity = false;
        } else {
            dragon.currentTailMotionUp = Mth.lerp((double)lerpRate, (double)dragon.currentTailMotionUp, (double)(-verticalVelocityAvg));
        }
        if (dragon.tailLocked) {
            MathParser.setVariable((String)"query.tail_motion_up", () -> 0.0);
            MathParser.setVariable((String)"query.body_yaw_change", () -> 0.0);
        } else {
            MathParser.setVariable((String)"query.body_yaw_change", () -> dragon.currentBodyYawChange);
            MathParser.setVariable((String)"query.tail_motion_up", () -> dragon.currentTailMotionUp);
        }
        MathParser.setVariable((String)"query.head_yaw_change", () -> dragon.currentHeadYawChange);
        MathParser.setVariable((String)"query.head_pitch_change", () -> dragon.currentHeadPitchChange);
    }

    public ResourceLocation getModelResource(DragonEntity dragon) {
        ResourceLocation model = dragon.getPlayer() == null ? DragonBody.DEFAULT_MODEL : DragonStateProvider.getData(dragon.getPlayer()).getModel();
        model = model.withPrefix("geo/").withSuffix(".geo.json");
        try {
            this.getBakedModel(model);
        }
        catch (Exception e) {
            DragonSurvival.LOGGER.error("Model not found for dragon species: {}", (Object)Translation.Type.DRAGON_SPECIES.wrap(DragonStateProvider.getData(dragon.getPlayer()).speciesKey().location()));
            return DragonBody.DEFAULT_MODEL;
        }
        return model;
    }

    public ResourceLocation getTextureResource(DragonEntity dragon) {
        ResourceLocation skin;
        if (this.overrideTexture != null && RenderingUtils.hasTexture(this.overrideTexture)) {
            return this.overrideTexture;
        }
        Object player = dragon.overrideUUIDWithLocalPlayerForTextureFetch ? Minecraft.getInstance().player : dragon.getPlayer();
        if (player == null) {
            return this.defaultTexture;
        }
        DragonStateHandler handler = DragonStateProvider.getData((Player)player);
        DragonStageCustomization customization = handler.getCurrentStageCustomization();
        if (handler.getModel().equals((Object)DragonBody.DEFAULT_MODEL) && !(player instanceof FakeClientPlayer) && RenderingUtils.hasTexture(skin = DragonSkins.getPlayerSkin((Player)player, handler.stageKey()))) {
            return skin;
        }
        if (handler.getSkinData().blankSkin) {
            return DragonSurvival.res("textures/dragon/" + handler.speciesId().getPath() + "/blank_skin.png");
        }
        ResourceKey<DragonStage> stageKey = handler.stageKey();
        if (handler.needsSkinRecompilation()) {
            DragonEditorHandler.generateSkinTextures(dragon);
            handler.getSkinData().isCompiled.put(handler.stageKey(), true);
            handler.getSkinData().recompileSkin.put(handler.stageKey(), false);
        }
        ResourceLocation texture = DragonModel.dynamicTexture((Player)player, handler, false);
        if (customization.defaultSkin || !handler.getSkinData().isCompiled.getOrDefault(stageKey, false).booleanValue() || !RenderingUtils.hasTexture(texture)) {
            return StageResources.getDefaultSkin(handler.species(), handler.stageKey(), false);
        }
        return texture;
    }

    public static ResourceLocation dynamicTexture(Player player, DragonStateHandler handler, boolean isGlowLayer) {
        String prefix = isGlowLayer ? "dynamic_glow_" : "dynamic_normal_";
        return DragonSurvival.res(prefix + player.getStringUUID() + "_" + handler.speciesId().getPath() + "_" + handler.stageKey().location().getPath());
    }

    public ResourceLocation getAnimationResource(DragonEntity dragon) {
        Player player = dragon.getPlayer();
        return DragonModel.getAnimationResource(player);
    }

    public RenderType getRenderType(DragonEntity animatable, ResourceLocation texture) {
        Player player = animatable.getPlayer();
        if (player != null && HunterData.hasTransparency((LivingEntity)player)) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)texture);
        }
        return RenderType.entityCutout((ResourceLocation)texture);
    }

    public void setOverrideTexture(ResourceLocation overrideTexture) {
        this.overrideTexture = overrideTexture;
    }

    public static ResourceLocation getAnimationResource(Player player) {
        DragonStateHandler handler;
        Holder<DragonBody> body;
        if (player != null && (body = (handler = DragonStateProvider.getData(player)).body()) != null) {
            return ((DragonBody)body.value()).animation().withPrefix("animations/").withSuffix(".json");
        }
        return DragonSurvival.res("animations/dragon_center.json");
    }
}

