/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.render.item;

import by.dragonsurvivalteam.dragonsurvival.client.render.item.RotatingKeyModel;
import by.dragonsurvivalteam.dragonsurvival.common.items.RotatingKeyItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.loading.math.MathParser;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class RotatingKeyRenderer
extends GeoItemRenderer<RotatingKeyItem> {
    public RotatingKeyRenderer() {
        super((GeoModel)new RotatingKeyModel());
    }

    public void preRender(PoseStack poseStack, RotatingKeyItem animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.preRender(poseStack, (Item)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        if (animatable.playerHoldingItem == null) {
            return;
        }
        Vector3f target = new Vector3f((Vector3fc)animatable.currentTarget);
        Vector3f vectorTo = target.sub((Vector3fc)animatable.playerHoldingItem.getEyePosition(partialTick).toVector3f()).normalize();
        Quaternionf lookAtRot = new Quaternionf();
        lookAtRot.lookAlong((Vector3fc)vectorTo, (Vector3fc)Direction.UP.step());
        Vector3f eulerAngles = new Vector3f();
        lookAtRot.getEulerAnglesZXY(eulerAngles);
        eulerAngles.mul(57.295776f);
        MathParser.setVariable((String)"query.x_rotation", () -> eulerAngles.x + 180.0f);
        MathParser.setVariable((String)"query.y_rotation", () -> eulerAngles.y - animatable.playerHoldingItem.getYRot() - 90.0f);
        MathParser.setVariable((String)"query.z_rotation", () -> eulerAngles.z);
    }
}

