/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.util;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class TextRenderUtil {
    public static void drawScaledText(@NotNull GuiGraphics guiGraphics, float x, float y, float scale, String text, int color) {
        TextRenderUtil.drawScaledText(guiGraphics, x, y, scale, text, color, 0);
    }

    public static void drawScaledText(@NotNull GuiGraphics guiGraphics, float x, float y, float scale, String text, int color, int zLevel) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(x - x * scale, y - y * scale, (float)zLevel);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.drawString(Minecraft.getInstance().font, text, x, y, color, false);
        guiGraphics.pose().popPose();
    }

    public static void drawCenteredScaledText(@NotNull GuiGraphics guiGraphics, int x, int y, float scale, String text, int color) {
        TextRenderUtil.drawCenteredScaledText(guiGraphics, x, y, scale, text, color, 0);
    }

    public static void drawCenteredScaledText(@NotNull GuiGraphics guiGraphics, int x, int y, float scale, String text, int color, int zLevel) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x - (float)x * scale, (float)y - (float)y * scale, (float)zLevel);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, text, x, y, color);
        guiGraphics.pose().popPose();
    }

    public static void drawCenteredScaledTextSplit(@NotNull GuiGraphics guiGraphics, int x, int y, float scale, String text, int color, int maxLength, int zLevel) {
        List lines = Minecraft.getInstance().font.split((FormattedText)Component.empty().append(text), (int)((float)maxLength / scale));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x - (float)x * scale, (float)y - (float)y * scale, (float)zLevel);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            Font font = Minecraft.getInstance().font;
            int n = x - Minecraft.getInstance().font.width(line) / 2;
            Objects.requireNonNull(Minecraft.getInstance().font);
            guiGraphics.drawString(font, line, n, y + i * 9, color, true);
        }
        guiGraphics.pose().popPose();
    }

    public static void drawScaledTextSplit(@NotNull GuiGraphics guiGraphics, float x, float y, float scale, Component text, int color, int maxLength, int zLevel) {
        List lines = Minecraft.getInstance().font.split((FormattedText)text, (int)((float)maxLength / scale));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(x - x * scale, y - y * scale, (float)zLevel);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)lines.get(i);
            Font font = Minecraft.getInstance().font;
            Objects.requireNonNull(Minecraft.getInstance().font);
            guiGraphics.drawString(font, line, x, y + (float)(i * 9), color, true);
        }
        guiGraphics.pose().popPose();
    }
}

