/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.blocks;

import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.container.OpenDragonAltar;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.AltarData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class DragonAltarBlock
extends Block {
    @Translation(comments={"The altar is on cooldown for: %s"})
    private static final String ALTAR_COOLDOWN = Translation.Type.GUI.wrap("message.altar_cooldown");
    @Translation(comments={"\u25a0\u00a77 An altar that allows you to turn into a dragon and edit skin."})
    private static final String ALTAR = Translation.Type.DESCRIPTION.wrap("dragon_altar");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private final VoxelShape SHAPE = Shapes.block();

    public DragonAltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public void appendHoverText(@NotNull ItemStack pStack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTootipComponents, @NotNull TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTootipComponents, pTooltipFlag);
        pTootipComponents.add((Component)Component.translatable((String)ALTAR));
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos position, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        AltarData data = AltarData.getData(player);
        if (ServerConfig.altarUsageCooldown > 0 && data.altarCooldown > 0) {
            Functions.Time time = Functions.Time.fromTicks(data.altarCooldown);
            player.sendSystemMessage((Component)Component.translatable((String)ALTAR_COOLDOWN, (Object[])new Object[]{time.format()}));
            return InteractionResult.FAIL;
        }
        data.altarCooldown = Functions.secondsToTicks(ServerConfig.altarUsageCooldown.intValue());
        data.hasUsedAltar = true;
        data.isInAltar = true;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenDragonAltar(DragonSpecies.getSpecies(serverPlayer, true)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.SHAPE;
    }
}

