/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.blocks;

import by.dragonsurvivalteam.dragonsurvival.common.blocks.ModCompat;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.particles.TreasureParticleOption;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncResting;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.TreasureRestData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreasureBlock
extends FallingBlock
implements SimpleWaterloggedBlock,
ModCompat {
    @Translation(comments={"\u25a0\u00a77 Creatures can sleep on treasure to regenerate health and mana. Gathering more treasure increases the speed of the regeneration. Build your horde and show off your wealth!"})
    private static final String TREASURE = Translation.Type.DESCRIPTION.wrap("treasure");
    public static final IntegerProperty LAYERS = BlockStateProperties.LAYERS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[]{Shapes.empty(), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private final String compatId;
    private final int effectColor;

    public TreasureBlock(int effectColor, BlockBehaviour.Properties properties) {
        this(effectColor, properties, null);
    }

    public TreasureBlock(int effectColor, BlockBehaviour.Properties properties, String compatId) {
        super(properties);
        this.compatId = compatId;
        this.effectColor = effectColor;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    public String getCompatId() {
        return this.compatId;
    }

    public boolean isPathfindable(@NotNull BlockState state, PathComputationType pPathComputationType) {
        return switch (pPathComputationType) {
            default -> throw new MatchException(null, null);
            case PathComputationType.LAND -> {
                if ((Integer)state.getValue((Property)LAYERS) < 5) {
                    yield true;
                }
                yield false;
            }
            case PathComputationType.WATER, PathComputationType.AIR -> false;
        };
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos position, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (!DragonStateProvider.isDragon((Entity)player)) {
            return InteractionResult.PASS;
        }
        if (player.getBlockStateOn().getBlock() == state.getBlock()) {
            TreasureRestData treasureData = TreasureRestData.getData(player);
            treasureData.setResting(true);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.resetStat(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST));
                serverPlayer.serverLevel().updateSleepingPlayerList();
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)serverPlayer, (CustomPacketPayload)new SyncResting(serverPlayer.getId(), treasureData.isResting()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                BlockPos respawnPosition = serverPlayer.getRespawnPosition();
                if (respawnPosition == null || serverPlayer.getRespawnDimension() != level.dimension() || !respawnPosition.equals((Object)position) && respawnPosition.distSqr((Vec3i)position) > 40.0) {
                    serverPlayer.setRespawnPosition(level.dimension(), position, 0.0f, false, true);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, position, player, hitResult);
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState blockState) {
        return true;
    }

    @NotNull
    public Optional<ServerPlayer.RespawnPosAngle> getRespawnPosition(@NotNull BlockState state, @NotNull EntityType<?> type, @NotNull LevelReader levelReader, @NotNull BlockPos pos, float orientation) {
        Optional standUpPosition;
        if (levelReader instanceof Level && (standUpPosition = RespawnAnchorBlock.findStandUpPosition(type, (CollisionGetter)levelReader, (BlockPos)pos)).isPresent()) {
            return Optional.of(new ServerPlayer.RespawnPosAngle((Vec3)standUpPosition.get(), orientation));
        }
        return Optional.empty();
    }

    public boolean isBed(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull LivingEntity sleeper) {
        return DragonStateProvider.isDragon((Entity)sleeper);
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean canBeReplaced(BlockState blockState, BlockPlaceContext context) {
        int i = (Integer)blockState.getValue((Property)LAYERS);
        if (context.getItemInHand().getItem() == this.asItem() && i < 8 && context.replacingClickedOnBlock()) {
            return context.getClickedFace() == Direction.UP;
        }
        return false;
    }

    @NotNull
    public VoxelShape getBlockSupportShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos) {
        return SHAPE_BY_LAYER[(Integer)blockState.getValue((Property)LAYERS)];
    }

    public float getShadeBrightness(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos) {
        return 1.0f;
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext context) {
        return SHAPE_BY_LAYER[(Integer)blockState.getValue((Property)LAYERS)];
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext context) {
        return SHAPE_BY_LAYER[Math.max((Integer)blockState.getValue((Property)LAYERS), 0)];
    }

    @NotNull
    public VoxelShape getVisualShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext context) {
        return Shapes.empty();
    }

    public boolean propagatesSkylightDown(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos) {
        return true;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState clickedState = context.getLevel().getBlockState(context.getClickedPos());
        if (clickedState.is((Block)this)) {
            int layers = (Integer)clickedState.getValue((Property)LAYERS);
            return (BlockState)((BlockState)clickedState.setValue((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, layers + 1)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
        }
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public boolean isPossibleToRespawnInThis(@NotNull BlockState ignored) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LAYERS});
        builder.add(new Property[]{WATERLOGGED});
    }

    public void appendHoverText(@NotNull ItemStack pStack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)TREASURE));
    }

    public void onBrokenAfterFall(Level world, @NotNull BlockPos pos, @NotNull FallingBlockEntity entity) {
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof TreasureBlock && state.getBlock() == entity.getBlockState().getBlock()) {
            int i = (Integer)state.getValue((Property)LAYERS);
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + (Integer)entity.getBlockState().getValue((Property)LAYERS)))));
        }
    }

    @NotNull
    protected MapCodec<? extends FallingBlock> codec() {
        return MapCodec.unit((Object)this);
    }

    @NotNull
    public BlockState updateShape(BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        pLevel.scheduleTick(pCurrentPos, (Block)this, this.getDelayAfterPlace());
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public void tick(BlockState state, ServerLevel level, final BlockPos blockPos, @NotNull RandomSource randomSource) {
        boolean lowerLayer;
        boolean belowEmpty = TreasureBlock.isFree((BlockState)level.getBlockState(blockPos.below())) && blockPos.getY() >= level.getMinBuildHeight();
        boolean bl = lowerLayer = level.getBlockState(blockPos.below()).getBlock() == state.getBlock() && (Integer)level.getBlockState(blockPos.below()).getValue((Property)LAYERS) < 8;
        if (belowEmpty || lowerLayer) {
            FallingBlockEntity fallingblockentity = new FallingBlockEntity(this, (Level)level, (double)blockPos.getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5, level.getBlockState(blockPos)){

                public void tick() {
                    int i;
                    BlockState state = this.level().getBlockState(this.blockPosition().below());
                    if (state.getBlock() == this.getBlockState().getBlock() && (i = ((Integer)state.getValue((Property)LAYERS)).intValue()) > 0 && i < 8) {
                        int missingLayers = 8 - i;
                        int newLayers = (Integer)this.getBlockState().getValue((Property)LAYERS);
                        int leftOver = 0;
                        if (newLayers > missingLayers) {
                            leftOver = newLayers - missingLayers;
                            newLayers = missingLayers;
                        }
                        this.level().setBlockAndUpdate(this.blockPosition().below(), (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + newLayers))));
                        if (leftOver > 0) {
                            this.level().setBlock(this.blockPosition(), (BlockState)this.getBlockState().setValue((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, leftOver))), 3);
                        } else {
                            this.level().setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
                        }
                        this.remove(Entity.RemovalReason.DISCARDED);
                        return;
                    }
                    super.tick();
                }
            };
            level.setBlock(blockPos, state.getFluidState().createLegacyBlock(), 3);
            level.addFreshEntity((Entity)fallingblockentity);
            this.falling(fallingblockentity);
        }
    }

    public void animateTick(@NotNull BlockState block, Level level, BlockPos position, @NotNull RandomSource random) {
        double xOffset = random.nextDouble();
        double yOffset = (double)((Integer)block.getValue((Property)LAYERS)).intValue() * 0.125 + 0.1;
        double zOffset = random.nextDouble();
        if (level.isEmptyBlock(position.above()) && random.nextInt(100) < 35) {
            level.addParticle((ParticleOptions)new TreasureParticleOption((float)FastColor.ARGB32.red((int)this.effectColor) / 255.0f, (float)FastColor.ARGB32.green((int)this.effectColor) / 255.0f, (float)FastColor.ARGB32.blue((int)this.effectColor) / 255.0f, 1.0f), (double)position.getX() + xOffset, (double)position.getY() + yOffset, (double)position.getZ() + zOffset, 0.0, 0.0, 0.0);
        }
    }
}

