/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.capability;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.gui.widgets.TimeComponent;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.DragonStageCustomization;
import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.SkinPreset;
import by.dragonsurvivalteam.dragonsurvival.common.capability.EntityStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.SkinData;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscCodecs;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Modifier;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncMagicData;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncDesiredGrowth;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncGrowth;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAdvancementTriggers;
import by.dragonsurvivalteam.dragonsurvival.registry.DSModifiers;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.AltarData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ClawInventoryData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.HarvestBonuses;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.PenaltySupply;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.InputData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStage;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import by.dragonsurvivalteam.dragonsurvival.util.ToolUtils;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragonStateHandler
extends EntityStateHandler {
    @Translation(comments={"You cannot turn into a human in this world"})
    private static final String NO_HUMANS = Translation.Type.GUI.wrap("message.no_humans");
    public static final double NO_GROWTH = -1.0;
    private static final double AGE_LERP_SPEED = 0.1;
    private static final double AGE_EPSILON = 0.01;
    public MultiMining multiMining = MultiMining.ENABLED;
    public LargeDragonDestruction largeDragonDestruction = LargeDragonDestruction.ENABLED;
    private final Map<ResourceKey<DragonStage>, Map<Item, Integer>> usedGrowthItems = new HashMap<ResourceKey<DragonStage>, Map<Item, Integer>>();
    public boolean isGrowthStopped;
    public boolean isGrowing = true;
    public int magicSource;
    public boolean isOnMagicSource;
    public boolean markedByEnderDragon;
    public boolean flightWasGranted;
    public boolean spinWasGranted;
    public boolean refreshBody;
    public boolean shouldFudgePosition;
    public int lastSync;
    private final Map<ResourceKey<DragonSpecies>, Double> savedGrowth = new HashMap<ResourceKey<DragonSpecies>, Double>();
    private SkinData skinData = new SkinData();
    private Holder<DragonSpecies> dragonSpecies;
    private Holder<DragonBody> dragonBody;
    private Holder<DragonStage> dragonStage;
    private int passengerId = -1;
    private double growth = -1.0;
    private double visualGrowth = -1.0;
    private double visualGrowthLastTick = -1.0;
    private double desiredGrowth = -1.0;
    private boolean destructionEnabled;
    public Pose previousPose;
    public Vec3 preCollisionDeltaMovement = Vec3.ZERO;
    private static final RandomSource RANDOM = RandomSource.create();
    private static final int MAX_SHOWN = 5;
    public static final String DRAGON_SPECIES = "dragon_species";
    public static final String GROWTH = "growth";
    private static final String DRAGON_BODY = "dragon_body";
    private static final String DRAGON_STAGE = "dragon_stage";
    private static final String ENTITY_STATE = "entity_state";
    private static final String SKIN_DATA = "skin_data";
    private static final String SAVED_GROWTH_SUFFIX = "_saved_growth";
    private static final String MULTI_MINING = "multi_mining";
    private static final String GIANT_DRAGON_DESTRUCTION = "giant_dragon_destruction";
    private static final String IS_GROWTH_STOPPED = "is_growth_stopped";
    private static final String MARKED_BY_ENDER_DRAGON = "marked_by_ender_dragon";
    private static final String SPIN_WAS_GRANTED = "spin_was_granted";
    private static final String WINGS_WAS_GRANTED = "wings_was_granted";
    private static final String IS_GROWING = "is_growing";
    private static final String DESTRUCTION_ENABLED = "destruction_enabled";
    private static final String USED_GROWTH_ITEMS = "used_growth_items";

    public void setRandomValidStage(@Nullable Player player) {
        if (this.dragonSpecies == null) {
            return;
        }
        HolderSet<DragonStage> stages = ((DragonSpecies)this.dragonSpecies.value()).getStages((HolderLookup.Provider)(player != null ? player.registryAccess() : null));
        this.setStage(player, (Holder<DragonStage>)((Holder)stages.getRandomElement(player != null ? player.getRandom() : RANDOM).orElseThrow()));
    }

    public void setStage(@Nullable Player player, Holder<DragonStage> dragonStage) {
        if (!((DragonSpecies)this.dragonSpecies.value()).getStages((HolderLookup.Provider)(player != null ? player.registryAccess() : null)).contains(dragonStage)) {
            Functions.logOrThrow("The dragon stage [" + String.valueOf(dragonStage.getKey().location()) + "] is not valid for the dragon species [" + String.valueOf(this.speciesId()) + "]");
            return;
        }
        double boundedGrowth = ((DragonStage)dragonStage.value()).getBoundedGrowth(this.growth);
        if (boundedGrowth == ((DragonStage)dragonStage.value()).growthRange().max()) {
            boundedGrowth -= 1.0E-7;
        }
        if (this.dragonStage == null) {
            this.setDesiredGrowth(player, boundedGrowth);
            this.setGrowth(player, this.desiredGrowth);
        } else {
            this.setDesiredGrowth(player, boundedGrowth);
        }
    }

    public void lerpGrowth(Player player) {
        if (player.level().isClientSide()) {
            if (this.visualGrowth == -1.0) {
                this.visualGrowth = this.growth;
            }
            this.visualGrowthLastTick = this.visualGrowth;
            this.visualGrowth = Math.abs(this.visualGrowth - this.desiredGrowth) < 0.01 ? this.desiredGrowth : Mth.lerp((double)0.1, (double)this.visualGrowth, (double)this.desiredGrowth);
        } else if (Math.abs(this.growth - this.desiredGrowth) < 0.01) {
            this.setGrowth(player, this.desiredGrowth);
        } else {
            this.setGrowth(player, Mth.lerp((double)0.1, (double)this.growth, (double)this.desiredGrowth));
        }
    }

    public void setGrowth(@Nullable Player player, double growth) {
        this.setGrowth(player, growth, false);
    }

    public void setGrowth(@Nullable Player player, double growth, boolean forceUpdate) {
        double oldGrowth = this.growth;
        Holder<DragonStage> oldStage = this.dragonStage;
        this.updateGrowthAndStage((HolderLookup.Provider)(player != null ? player.registryAccess() : null), growth);
        if (player == null) {
            return;
        }
        if (this.dragonStage == null) {
            DSModifiers.updateGrowthModifiers(player, this);
            return;
        }
        if (!forceUpdate && oldGrowth == this.growth && oldStage != null && this.dragonStage.is(oldStage)) {
            return;
        }
        DSModifiers.updateGrowthModifiers(player, this);
        this.shouldFudgePosition = true;
        player.refreshDimensions();
        this.shouldFudgePosition = false;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)serverPlayer, (CustomPacketPayload)new SyncGrowth(serverPlayer.getId(), this.getGrowth()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            MagicData.getData(player).handleAutoUpgrades(serverPlayer, InputData.growth((int)this.growth));
            DSAdvancementTriggers.BE_DRAGON.get().trigger(serverPlayer);
        }
        if (player.level().isClientSide()) {
            ClientProxy.sendClientData();
        }
    }

    public void setDesiredGrowth(@Nullable Player player, double growth) {
        if (player == null) {
            this.desiredGrowth = growth;
            this.setGrowth(null, growth);
            return;
        }
        this.desiredGrowth = this.clampGrowth((HolderLookup.Provider)player.registryAccess(), growth);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)serverPlayer, (CustomPacketPayload)new SyncDesiredGrowth(serverPlayer.getId(), this.desiredGrowth), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private double clampGrowth(@Nullable HolderLookup.Provider provider, double growth) {
        MiscCodecs.Bounds bounds = DragonStage.getBounds();
        double newGrowth = Math.clamp(growth, bounds.min(), bounds.max());
        if (this.dragonSpecies == null) {
            return newGrowth;
        }
        Holder<DragonStage> stage = DragonStage.get(((DragonSpecies)this.dragonSpecies.value()).getStages(provider), newGrowth);
        return ((DragonStage)stage.value()).getBoundedGrowth(newGrowth);
    }

    private void updateGrowthAndStage(@Nullable HolderLookup.Provider provider, double growth) {
        if (growth == -1.0) {
            this.dragonStage = null;
            this.growth = -1.0;
            this.desiredGrowth = -1.0;
            return;
        }
        this.dragonStage = this.dragonSpecies != null ? DragonStage.get(((DragonSpecies)this.dragonSpecies.value()).getStages(provider), growth) : null;
        this.growth = this.clampGrowth(provider, growth);
        if (this.dragonSpecies != null && this.growth == ((DragonSpecies)this.dragonSpecies.value()).getStartingGrowth(provider)) {
            this.usedGrowthItems.clear();
        }
    }

    public List<Holder<DragonStage>> getStagesSortedByProgression(@Nullable HolderLookup.Provider provider) {
        List<Holder<DragonStage>> stages = this.getStages(provider);
        ArrayList<Holder<DragonStage>> sortedStages = new ArrayList<Holder<DragonStage>>(stages);
        sortedStages.sort(Comparator.comparingDouble(stage -> ((DragonStage)stage.value()).growthRange().min()));
        return sortedStages;
    }

    public List<Holder<DragonStage>> getStages(@Nullable HolderLookup.Provider provider) {
        if (((DragonSpecies)this.dragonSpecies.value()).stages().isPresent()) {
            return ((DragonSpecies)this.dragonSpecies.value()).stages().get().stream().toList();
        }
        return DragonStage.getDefaultStages(provider).stream().toList();
    }

    public void incrementGrowthUses(Item item) {
        Map items = this.usedGrowthItems.computeIfAbsent(this.stageKey(), key -> new HashMap());
        items.compute(item, (key, timesUsed) -> timesUsed == null ? 1 : timesUsed + 1);
    }

    public int getGrowthUses(Item item) {
        Map<Item, Integer> items = this.usedGrowthItems.get(this.stageKey());
        if (items == null) {
            return 0;
        }
        Integer uses = items.get(item);
        if (uses == null) {
            return 0;
        }
        return uses;
    }

    public Holder<DragonSpecies> species() {
        return this.dragonSpecies;
    }

    public ResourceKey<DragonSpecies> speciesKey() {
        return this.species().getKey();
    }

    public ResourceLocation speciesId() {
        return this.speciesKey().location();
    }

    public Holder<DragonStage> stage() {
        return this.dragonStage;
    }

    public Holder<DragonStage> stageFromDesiredSize(Player player) {
        return DragonStage.get(((DragonSpecies)this.dragonSpecies.value()).getStages((HolderLookup.Provider)player.registryAccess()), this.desiredGrowth);
    }

    public ResourceKey<DragonStage> stageKey() {
        return this.stage().getKey();
    }

    public ResourceLocation stageId() {
        return this.stageKey().location();
    }

    public Holder<DragonBody> body() {
        return this.dragonBody;
    }

    public ResourceKey<DragonBody> bodyKey() {
        return this.body().getKey();
    }

    public ResourceLocation bodyId() {
        return this.bodyKey().location();
    }

    public void refreshMagicData(ServerPlayer player, boolean forceRetainMagicData) {
        MagicData magic = MagicData.getData((Player)player);
        if (!ServerConfig.saveAllAbilities.booleanValue() && !forceRetainMagicData) {
            magic.refresh(player, this.dragonSpecies);
            this.flightWasGranted = false;
            this.spinWasGranted = false;
        } else if (this.dragonSpecies == null || magic.dataForSpeciesIsEmpty(this.speciesKey())) {
            magic.refresh(player, this.dragonSpecies);
        } else {
            magic.setCurrentSpecies((Player)player, this.speciesKey());
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncMagicData(magic.serializeNBT((HolderLookup.Provider)player.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void setSpecies(@Nullable Player player, @Nullable Holder<DragonSpecies> species, boolean savedForSoul) {
        ServerPlayer serverPlayer;
        boolean hasChanged;
        Holder<DragonSpecies> oldSpecies = this.dragonSpecies;
        double oldGrowth = this.growth;
        this.dragonSpecies = species;
        boolean bl = hasChanged = species != null && !DragonUtils.isSpecies(oldSpecies, species);
        if (hasChanged) {
            if (this.body() == null || !((DragonSpecies)species.value()).isValidForBody(this.body())) {
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    this.setBody((Player)serverPlayer, DragonBody.getRandomUnlocked(serverPlayer));
                } else {
                    this.setBody(player, DragonBody.getRandom((HolderLookup.Provider)(player != null ? player.registryAccess() : null), species));
                }
            }
            this.updateGrowthAndStage((HolderLookup.Provider)(player != null ? player.registryAccess() : null), this.getSavedDragonAge(this.speciesKey()));
            if (FMLLoader.getDist().isClient() && ((SkinPreset)((HashMap)this.skinData.skinPresets.get()).get(this.speciesKey())).isEmpty()) {
                this.refreshSkinPresetForSpecies(this.dragonSpecies, this.dragonBody);
                this.recompileCurrentSkin();
            }
        }
        if (oldSpecies != null && !savedForSoul) {
            this.savedGrowth.put((ResourceKey<DragonSpecies>)oldSpecies.getKey(), oldGrowth);
        } else if (oldSpecies != null) {
            this.savedGrowth.remove(oldSpecies.getKey());
        }
        if (player == null) {
            return;
        }
        if (hasChanged) {
            PenaltySupply.clear(player);
            DSModifiers.updateTypeModifiers(player, this);
            if (player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                this.refreshMagicData(serverPlayer, false);
            }
        } else if (species == null) {
            PenaltySupply.clear(player);
            DSModifiers.clearModifiers(player);
        }
    }

    public void setSpecies(@Nullable Player player, Holder<DragonSpecies> species) {
        this.setSpecies(player, species, false);
    }

    public void setBody(@Nullable Player player, Holder<DragonBody> dragonBody) {
        Holder<DragonBody> oldBody = this.dragonBody;
        this.dragonBody = dragonBody;
        boolean isSameBody = DragonUtils.isBody(oldBody, this.dragonBody);
        if (this.dragonBody != null && !isSameBody) {
            this.refreshBody = true;
            if (oldBody != null && ((DragonBody)this.dragonBody.value()).model() != ((DragonBody)oldBody.value()).model()) {
                this.refreshSkinPresetForSpecies(this.dragonSpecies, this.dragonBody);
                this.recompileCurrentSkin();
            }
        }
        if (player == null) {
            return;
        }
        if (!isSameBody) {
            DSModifiers.updateBodyModifiers(player, this);
        }
    }

    public boolean canHarvestWithPaw(Player player, BlockState state) {
        if (!ToolUtils.shouldUseDragonTools(player.getMainHandItem())) {
            return HarvestBonuses.canHarvest(player, state, player.getMainHandItem());
        }
        return HarvestBonuses.canHarvest(player, state, ClawInventoryData.getData(player).getTool(state));
    }

    public void setPassengerId(int passengerId) {
        this.passengerId = passengerId;
    }

    public double getVisualScale(Player player, float partialTick) {
        if (!DragonSurvival.PROXY.isOnRenderThread()) {
            Functions.logOrThrow("Visual scale update should only be used for rendering purposes!");
            return player.getAttributeValue(Attributes.SCALE);
        }
        AttributeInstance instance = Objects.requireNonNull(player.getAttribute(Attributes.SCALE));
        double partialVisualGrowth = Mth.lerp((double)partialTick, (double)this.visualGrowthLastTick, (double)this.visualGrowth);
        if (partialVisualGrowth == this.visualGrowth || DragonSurvival.PROXY.isFakePlayer(player)) {
            return instance.getValue();
        }
        List<AttributeModifier> attributeModifiers = ((DragonStage)this.stage().value()).filterModifiers(instance);
        List<Modifier> modifiers = ((DragonStage)this.stage().value()).modifiers().stream().filter(modifier -> modifier.attribute().is(Attributes.SCALE)).toList();
        return Functions.calculateAttributeValue(instance, partialVisualGrowth - ((DragonStage)this.stage().value()).growthRange().min(), attributeModifiers, modifiers);
    }

    public double getGrowth() {
        return this.growth;
    }

    public double getDesiredGrowth() {
        return this.desiredGrowth;
    }

    public boolean isDragon() {
        return this.dragonSpecies != null && this.dragonBody != null && this.dragonStage != null;
    }

    public int getPassengerId() {
        return this.passengerId;
    }

    public SkinData getSkinData() {
        return this.skinData;
    }

    public ResourceLocation getModel() {
        return ((DragonBody)this.dragonBody.value()).model();
    }

    public void setSkinPresetForType(ResourceKey<DragonSpecies> dragonSpecies, SkinPreset preset) {
        ((HashMap)this.skinData.skinPresets.get()).put(dragonSpecies, preset);
    }

    public void setCurrentSkinPreset(SkinPreset preset) {
        ((HashMap)this.skinData.skinPresets.get()).put(this.speciesKey(), preset);
        this.recompileCurrentSkin();
    }

    public SkinPreset getCurrentSkinPreset() {
        return (SkinPreset)((HashMap)this.skinData.skinPresets.get()).get(this.speciesKey());
    }

    public void refreshSkinPresetForSpecies(Holder<DragonSpecies> species, Holder<DragonBody> body) {
        SkinPreset freshSkinPreset = new SkinPreset();
        freshSkinPreset.initDefaults(species, body != null ? ((DragonBody)body.value()).model() : DragonBody.DEFAULT_MODEL);
        ((HashMap)this.skinData.skinPresets.get()).put(species.getKey(), freshSkinPreset);
    }

    public SkinPreset getSkinPresetForSpecies(Holder<DragonSpecies> species, Holder<DragonBody> body) {
        SkinPreset skinPreset = (SkinPreset)((HashMap)this.skinData.skinPresets.get()).get(species.getKey());
        if (skinPreset.isEmpty()) {
            this.refreshSkinPresetForSpecies(species, body);
        }
        return (SkinPreset)((HashMap)this.skinData.skinPresets.get()).get(species.getKey());
    }

    public void recompileCurrentSkin() {
        if (!this.isDragon()) {
            return;
        }
        this.skinData.compileSkin(this.stageKey());
    }

    public void setCurrentStageCustomization(DragonStageCustomization customization) {
        ((SkinPreset)((HashMap)this.skinData.skinPresets.get()).get(this.speciesKey())).put(this.stageKey(), (Lazy<DragonStageCustomization>)Lazy.of(() -> customization));
    }

    public DragonStageCustomization getCurrentStageCustomization() {
        Lazy<DragonStageCustomization> customizationLazy = this.skinData.get(this.speciesKey(), this.stageKey());
        if (customizationLazy == null) {
            DragonSurvival.LOGGER.error("Failed to get customization for species [{}] and stage [{}]. Returning empty customization.", (Object)this.speciesId(), (Object)this.stageId());
            return new DragonStageCustomization();
        }
        return (DragonStageCustomization)customizationLazy.get();
    }

    public DragonStageCustomization getCustomizationForStageAndSpecies(ResourceKey<DragonSpecies> species, ResourceKey<DragonStage> stage) {
        return (DragonStageCustomization)this.skinData.get(species, stage).get();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider, boolean isDragonSoul) {
        CompoundTag tag = new CompoundTag();
        if (this.isDragon()) {
            tag.putString(DRAGON_SPECIES, this.speciesId().toString());
            tag.putString(DRAGON_BODY, this.bodyId().toString());
            tag.putString(DRAGON_STAGE, this.stageId().toString());
            tag.putDouble(GROWTH, this.growth);
            tag.putBoolean(IS_GROWTH_STOPPED, this.isGrowthStopped);
            tag.putBoolean(IS_GROWING, this.isGrowing);
            tag.putBoolean(DESTRUCTION_ENABLED, this.destructionEnabled);
            tag.putBoolean(MARKED_BY_ENDER_DRAGON, this.markedByEnderDragon);
            tag.putBoolean(WINGS_WAS_GRANTED, this.flightWasGranted);
            tag.putBoolean(SPIN_WAS_GRANTED, this.spinWasGranted);
        }
        tag.putString(MULTI_MINING, this.multiMining.name());
        tag.putString(GIANT_DRAGON_DESTRUCTION, this.largeDragonDestruction.name());
        if (isDragonSoul && this.dragonSpecies != null) {
            this.storeSavedAge(this.speciesKey(), tag);
            this.savedGrowth.remove(this.speciesKey());
        } else if (!isDragonSoul) {
            for (ResourceKey<DragonSpecies> type : ResourceHelper.keys(provider, DragonSpecies.REGISTRY)) {
                boolean hasSavedGrowth = this.savedGrowth.containsKey(type);
                if (!hasSavedGrowth) continue;
                this.storeSavedAge(type, tag);
            }
        }
        CompoundTag usedGrowthItems = new CompoundTag();
        this.usedGrowthItems.forEach((key, items) -> {
            CompoundTag perStage = new CompoundTag();
            items.forEach((item, count) -> perStage.putInt(item.builtInRegistryHolder().getKey().location().toString(), count.intValue()));
            usedGrowthItems.put(key.location().toString(), (Tag)perStage);
        });
        tag.put(USED_GROWTH_ITEMS, (Tag)usedGrowthItems);
        tag.put(SKIN_DATA, (Tag)this.skinData.serializeNBT(provider));
        tag.put(ENTITY_STATE, (Tag)super.serializeNBT(provider));
        return tag;
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        return this.serializeNBT(provider, false);
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag tag, boolean isDragonSoul) {
        ResourceKey<DragonSpecies> species = ResourceHelper.decodeKey(provider, DragonSpecies.REGISTRY, tag, DRAGON_SPECIES);
        this.dragonSpecies = species != null ? provider.holderOrThrow(species) : null;
        ResourceKey<DragonBody> body = ResourceHelper.decodeKey(provider, DragonBody.REGISTRY, tag, DRAGON_BODY);
        this.dragonBody = body != null ? provider.holderOrThrow(body) : null;
        ResourceKey<DragonStage> stage = ResourceHelper.decodeKey(provider, DragonStage.REGISTRY, tag, DRAGON_STAGE);
        this.dragonStage = stage != null ? provider.holderOrThrow(stage) : null;
        this.multiMining = Functions.getEnum(MultiMining.class, tag.getString(MULTI_MINING));
        this.largeDragonDestruction = Functions.getEnum(LargeDragonDestruction.class, tag.getString(GIANT_DRAGON_DESTRUCTION));
        if (this.dragonSpecies != null) {
            if (this.dragonBody == null) {
                this.dragonBody = DragonBody.getRandom(provider, this.dragonSpecies);
            }
            this.setGrowth(null, tag.getDouble(GROWTH));
            this.desiredGrowth = this.growth;
            this.destructionEnabled = tag.getBoolean(DESTRUCTION_ENABLED);
            this.isGrowing = !tag.contains(IS_GROWING) || tag.getBoolean(IS_GROWING);
            this.isGrowthStopped = tag.getBoolean(IS_GROWTH_STOPPED);
            this.markedByEnderDragon = tag.getBoolean(MARKED_BY_ENDER_DRAGON);
            this.flightWasGranted = tag.getBoolean(WINGS_WAS_GRANTED);
            this.spinWasGranted = tag.getBoolean(SPIN_WAS_GRANTED);
        }
        if (this.dragonSpecies != null) {
            if (isDragonSoul) {
                this.savedGrowth.put(this.speciesKey(), this.growth);
            } else {
                for (ResourceKey<DragonSpecies> type : ResourceHelper.keys(provider, DragonSpecies.REGISTRY)) {
                    CompoundTag compound = tag.getCompound(String.valueOf(this.speciesId()) + SAVED_GROWTH_SUFFIX);
                    if (compound.isEmpty()) continue;
                    this.savedGrowth.put(type, this.loadSavedStage(provider, type, tag));
                }
            }
        }
        this.usedGrowthItems.clear();
        CompoundTag usedGrowthItems = tag.getCompound(USED_GROWTH_ITEMS);
        usedGrowthItems.getAllKeys().forEach(growthItemStage -> {
            ResourceLocation stageResource = ResourceLocation.tryParse((String)growthItemStage);
            if (stageResource == null) {
                return;
            }
            CompoundTag perStage = usedGrowthItems.getCompound(growthItemStage);
            ResourceKey stageKey = ResourceKey.create(DragonStage.REGISTRY, (ResourceLocation)stageResource);
            perStage.getAllKeys().forEach(itemResource -> {
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)itemResource));
                if (item != Items.AIR) {
                    this.usedGrowthItems.computeIfAbsent((ResourceKey<DragonStage>)stageKey, ignored -> new HashMap()).put(item, perStage.getInt(itemResource));
                }
            });
        });
        this.skinData = new SkinData();
        this.skinData.deserializeNBT(provider, tag.getCompound(SKIN_DATA), this.dragonBody);
        super.deserializeNBT(provider, tag.getCompound(ENTITY_STATE));
        if (this.isDragon()) {
            this.refreshBody = true;
            this.getSkinData().compileSkin(this.stageKey());
        }
    }

    private double loadSavedStage(@NotNull HolderLookup.Provider provider, ResourceKey<DragonSpecies> dragonSpecies, CompoundTag tag) {
        CompoundTag compound = tag.getCompound(String.valueOf(dragonSpecies.location()) + SAVED_GROWTH_SUFFIX);
        if (compound.isEmpty()) {
            Optional<Holder.Reference<DragonSpecies>> optional = ResourceHelper.get(provider, dragonSpecies);
            if (optional.isPresent()) {
                return ((DragonSpecies)optional.get().value()).getStartingGrowth(provider);
            }
            DragonSurvival.LOGGER.warn("Cannot load saved growth for dragon species [{}] while deserializing NBT of [{}] due to the dragon type not existing. Falling back to the smallest growth.", dragonSpecies, (Object)tag);
            return DragonStage.getBounds().min();
        }
        return compound.getDouble(GROWTH);
    }

    private void storeSavedAge(ResourceKey<DragonSpecies> speciesKey, CompoundTag tag) {
        CompoundTag savedGrowthTag = new CompoundTag();
        savedGrowthTag.putDouble(GROWTH, this.getSavedDragonAge(speciesKey));
        tag.put(String.valueOf(speciesKey.location()) + SAVED_GROWTH_SUFFIX, (Tag)savedGrowthTag);
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag tag) {
        this.deserializeNBT(provider, tag, false);
    }

    public void revertToHumanForm(Player player, boolean isDragonSoul) {
        if (ServerConfig.noHumansAllowed.booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)NO_HUMANS), true);
            return;
        }
        ClawInventoryData.reInsertClawTools(player);
        this.setSpecies(player, null, isDragonSoul);
        this.setBody(player, null);
        this.setDesiredGrowth(player, -1.0);
        AltarData altarData = AltarData.getData(player);
        altarData.altarCooldown = Functions.secondsToTicks(ServerConfig.altarUsageCooldown.intValue());
        altarData.hasUsedAltar = true;
    }

    public boolean needsSkinRecompilation() {
        return this.isDragon() && this.getSkinData().recompileSkin.getOrDefault(this.stageKey(), true) != false;
    }

    public double getSavedDragonAge(ResourceKey<DragonSpecies> type) {
        return this.savedGrowth.getOrDefault(type, -1.0);
    }

    public Pair<List<Either<FormattedText, TooltipComponent>>, Integer> getGrowthDescription(int currentScroll) {
        DragonStage stage = (DragonStage)this.dragonStage.value();
        double percentage = Math.clamp(stage.getProgress(this.getGrowth()), 0.0, 1.0);
        String ageInformation = stage.getTimeToGrowFormattedWithPercentage(percentage, this.getGrowth(), this.isGrowing);
        ArrayList growthItems = new ArrayList();
        ((DragonStage)this.stage().value()).growthItems().forEach(growthItem -> growthItem.items().forEach(item -> growthItems.add(new TimeComponent((Item)item.value(), growthItem.growthInTicks(), TimeComponent.GROWTH))));
        int scroll = currentScroll;
        scroll = growthItems.size() <= 5 ? 0 : Math.clamp((long)scroll, 0, growthItems.size() - 5);
        int max = Math.min(growthItems.size(), scroll + 5);
        ArrayList<Either> components = new ArrayList<Either>();
        components.add(Either.left((Object)Component.translatable((String)LangKey.GROWTH_STAGE).append(DragonStage.translatableName(this.stageKey()))));
        components.add(Either.left((Object)Component.translatable((String)LangKey.GROWTH_AGE, (Object[])new Object[]{ageInformation})));
        components.add(Either.left((Object)Component.translatable((String)LangKey.GROWTH_AMOUNT, (Object[])new Object[]{(int)this.getGrowth()})));
        components.add(Either.left((Object)Component.translatable((String)LangKey.GROWTH_INFO).append((Component)Component.literal((String)(" [" + Math.min(growthItems.size(), scroll + 5) + " / " + growthItems.size() + "]")).withStyle(ChatFormatting.DARK_GRAY))));
        for (int i = scroll; i < max; ++i) {
            components.add(Either.right((Object)((TooltipComponent)growthItems.get(i))));
        }
        return Pair.of(components, (Object)scroll);
    }

    @Translation(comments={"Multi Mining"})
    public static enum MultiMining {
        ENABLED,
        DISABLED;

    }

    @Translation(comments={"Large Dragon Destruction"})
    public static enum LargeDragonDestruction {
        ENABLED,
        DISABLED;

    }
}

