/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;

public record DragonBeaconData(List<Effect> effects, PaymentData paymentData) {
    public static final Codec<DragonBeaconData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Effect.CODEC.listOf().fieldOf("effects").forGetter(DragonBeaconData::effects), (App)PaymentData.CODEC.fieldOf("payment_data").forGetter(DragonBeaconData::paymentData)).apply((Applicative)instance, DragonBeaconData::new));

    @SafeVarargs
    public static List<Effect> createEffects(int duration, int amplifier, Holder<MobEffect> ... effects) {
        ArrayList<Effect> instances = new ArrayList<Effect>();
        for (Holder<MobEffect> effect : effects) {
            instances.add(new Effect(effect, duration, amplifier));
        }
        return instances;
    }

    public record PaymentData(int experienceCost, int durationMultiplier, int amplifierModification) {
        public static final Codec<PaymentData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("experience_cost", (Object)0).forGetter(PaymentData::experienceCost), (App)ExtraCodecs.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("duration_multiplier", (Object)1).forGetter(PaymentData::durationMultiplier), (App)Codec.INT.optionalFieldOf("amplifier_modification", (Object)0).forGetter(PaymentData::amplifierModification)).apply((Applicative)instance, PaymentData::new));
    }

    public record Effect(Holder<MobEffect> effect, int duration, int amplifier) {
        public static final Codec<Effect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("effect").forGetter(Effect::effect), (App)ExtraCodecs.intRange((int)-1, (int)Integer.MAX_VALUE).optionalFieldOf("duration", (Object)-1).forGetter(Effect::duration), (App)ExtraCodecs.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("amplifier", (Object)0).forGetter(Effect::amplifier)).apply((Applicative)instance, Effect::new));
    }
}

