/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance;

import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.ClientEffectProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record CommonData(ClientEffectProvider.ClientData clientData, Optional<ResourceKey<DragonAbility>> ability, Optional<ResourceKey<DragonPenalty>> penalty, Optional<UUID> source, int appliedAbilityLevel, boolean removeAutomatically) {
    public static final Codec<CommonData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ClientEffectProvider.ClientData.CODEC.fieldOf("client_data").forGetter(CommonData::clientData), (App)ResourceKey.codec(DragonAbility.REGISTRY).optionalFieldOf("ability").forGetter(CommonData::ability), (App)ResourceKey.codec(DragonPenalty.REGISTRY).optionalFieldOf("penalty").forGetter(CommonData::penalty), (App)UUIDUtil.CODEC.optionalFieldOf("source").forGetter(CommonData::source), (App)Codec.INT.fieldOf("applied_ability_level").forGetter(CommonData::appliedAbilityLevel), (App)Codec.BOOL.optionalFieldOf("remove_automatically", (Object)false).forGetter(CommonData::removeAutomatically)).apply((Applicative)instance, CommonData::new));

    public static CommonData from(ResourceLocation id, ServerPlayer dragon, DragonAbilityInstance ability, Optional<ResourceLocation> customIcon, boolean removeAutomatically) {
        ClientEffectProvider.ClientData clientData = ClientEffectProvider.ClientData.from(id, dragon, ability, customIcon);
        return new CommonData(clientData, Optional.of(ability.key()), Optional.empty(), Optional.of(dragon.getUUID()), ability.level(), removeAutomatically);
    }

    public static CommonData from(ResourceLocation id, ServerPlayer dragon, Holder<DragonPenalty> penalty, Optional<ResourceLocation> customIcon, boolean removeAutomatically) {
        ClientEffectProvider.ClientData clientData = ClientEffectProvider.ClientData.from(id, penalty, customIcon);
        return new CommonData(clientData, Optional.empty(), Optional.of(penalty.getKey()), Optional.of(dragon.getUUID()), 1, removeAutomatically);
    }
}

