/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Condition;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.CommonData;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.duration_instance.DurationInstanceBase;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.StorageEntry;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.ClientEffectProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public abstract class DurationInstance<B extends DurationInstanceBase<?, ?>>
implements ClientEffectProvider,
StorageEntry {
    public static final int INFINITE_DURATION = -1;
    private final B baseData;
    private final CommonData commonData;
    private int currentDuration;

    public DurationInstance(B baseData, CommonData commonData, int currentDuration) {
        this.baseData = baseData;
        this.commonData = commonData;
        this.currentDuration = currentDuration;
    }

    public static <T extends DurationInstance<B>, B extends DurationInstanceBase<?, ?>> Products.P3<RecordCodecBuilder.Mu<T>, B, CommonData, Integer> codecStart(RecordCodecBuilder.Instance<T> instance, Supplier<Codec<B>> baseDataCodec) {
        return instance.group((App)baseDataCodec.get().fieldOf("base_data").forGetter(DurationInstance::baseData), (App)CommonData.CODEC.fieldOf("common_data").forGetter(DurationInstance::commonData), (App)Codec.INT.fieldOf("current_duration").forGetter(DurationInstance::currentDuration));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean tick(Entity storageHolder) {
        Level level;
        if (this.currentDuration != -1) {
            --this.currentDuration;
            if (storageHolder.level().isClientSide()) {
                return false;
            }
            if (this.currentDuration == 0) {
                return true;
            }
        }
        if (storageHolder.level().isClientSide()) {
            return false;
        }
        if (this.commonData.removeAutomatically() && this.commonData.source().isPresent()) {
            Player source = storageHolder.level().getPlayerByUUID(this.commonData.source().get());
            if (source == null) {
                return true;
            }
            DragonStateHandler handler = DragonStateProvider.getData(source);
            if (!handler.isDragon()) {
                return true;
            }
            if (this.commonData.ability().isPresent()) {
                MagicData magic = MagicData.getData(source);
                DragonAbilityInstance ability = magic.getAbility(this.commonData.ability().get());
                if (ability == null) return true;
                if (!ability.isApplyingEffects()) {
                    return true;
                }
            }
            if (this.commonData.penalty().isPresent() && source instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)source;
                for (Holder penalty : ((DragonSpecies)handler.species().value()).penalties()) {
                    if (penalty.getKey() != this.commonData.penalty().get() || !((DragonPenalty)penalty.value()).condition().map(condition -> !condition.test((Object)Condition.penaltyContext(serverPlayer))).orElse(false).booleanValue()) continue;
                    return true;
                }
            }
        }
        if (!((level = storageHolder.level()) instanceof ServerLevel)) return false;
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.earlyRemovalCondition().map(condition -> condition.test((Object)Condition.entityContext(serverLevel, storageHolder))).orElse(false) == false) return false;
        return true;
    }

    public B baseData() {
        return this.baseData;
    }

    @Override
    public ResourceLocation id() {
        return ((DurationInstanceBase)this.baseData).id();
    }

    @Override
    public int getDuration() {
        return (int)((DurationInstanceBase)this.baseData).duration().calculate(this.appliedAbilityLevel());
    }

    @Override
    public boolean isHidden() {
        return ((DurationInstanceBase)this.baseData).isHidden();
    }

    public CommonData commonData() {
        return this.commonData;
    }

    @Override
    public ClientEffectProvider.ClientData clientData() {
        return this.commonData.clientData();
    }

    public Optional<ResourceKey<DragonAbility>> ability() {
        return this.commonData.ability();
    }

    public Optional<UUID> source() {
        return this.commonData.source();
    }

    public int appliedAbilityLevel() {
        return this.commonData.appliedAbilityLevel();
    }

    @Override
    public int currentDuration() {
        return this.currentDuration;
    }

    public Optional<LootItemCondition> earlyRemovalCondition() {
        return ((DurationInstanceBase)this.baseData()).earlyRemovalCondition();
    }
}

