/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.effects;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.effects.ModifiableMobEffect;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDamageTypes;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSDragonSpeciesTags;
import by.dragonsurvivalteam.dragonsurvival.util.AdditionalEffectData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public class BlastDustedEffect
extends ModifiableMobEffect {
    @ConfigRange(min=0.0, max=256.0)
    @Translation(key="blast_dust_explosion_multiplier", type=Translation.Type.CONFIGURATION, comments={"A multiplier to the amplifier which determines the explosion radius of the blast dust effect"})
    @ConfigOption(side=ConfigSide.SERVER, category={"effects", "blast_dust"}, key="blast_dust_explosion_multiplier")
    public static Float radiusMultiplier = Float.valueOf(0.6f);

    public BlastDustedEffect(MobEffectCategory type, int color, boolean incurable) {
        super(type, color, incurable);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(@NotNull LivingEntity entity, int amplifier) {
        Player player;
        DragonStateHandler handler;
        if (entity instanceof Player && (handler = DragonStateProvider.getData(player = (Player)entity)).isDragon() && handler.species().is(DSDragonSpeciesTags.CAVE_DRAGONS)) {
            return false;
        }
        if (entity.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) || entity.isInWaterRainOrBubble()) {
            return false;
        }
        return super.applyEffectTick(entity, amplifier);
    }

    public void onMobHurt(@NotNull LivingEntity entity, int amplifier, @NotNull DamageSource damageSource, float amount) {
        if (entity.level().isClientSide()) {
            return;
        }
        if (damageSource.is(DamageTypeTags.IS_FIRE)) {
            BlastDustedEffect.explode(entity, amplifier);
            entity.removeEffect(DSEffects.BLAST_DUSTED);
        }
    }

    public static void explode(LivingEntity entity, int amplifier) {
        float radius;
        Entity effectApplier = null;
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AdditionalEffectData effectInstance = (AdditionalEffectData)entity.getEffect(DSEffects.BLAST_DUSTED);
            if (effectInstance != null) {
                effectApplier = effectInstance.dragonSurvival$getApplier(serverLevel);
            }
        }
        if ((radius = (float)(amplifier + 1) * radiusMultiplier.floatValue()) > 0.0f) {
            entity.level().explode((Entity)entity, new DamageSource(DSDamageTypes.get(entity.level(), DSDamageTypes.BLAST_DUST), effectApplier), null, entity.getX(), entity.getY(), entity.getZ(), radius, true, Level.ExplosionInteraction.MOB);
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        Player player;
        DragonStateHandler handler;
        if (event.getEffect() != DSEffects.BLAST_DUSTED) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (handler = DragonStateProvider.getData(player = (Player)livingEntity)).isDragon() && handler.species().is(DSDragonSpeciesTags.CAVE_DRAGONS)) {
            return;
        }
        event.getEntity().level().playLocalSound(event.getEntity().position().x(), event.getEntity().position().y(), event.getEntity().position().z(), SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.PLAYERS, 1.0f, 1.0f, false);
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        if (event.getEffectInstance() != null && event.getEffectInstance().is(DSEffects.BLAST_DUSTED)) {
            BlastDustedEffect.explode(event.getEntity(), event.getEffectInstance().getAmplifier());
        }
    }
}

