/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.effects;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.capability.EntityStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.effects.ModifiableMobEffect;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.magic.EffectHandler;
import by.dragonsurvivalteam.dragonsurvival.common.particles.LargeLightningParticleOption;
import by.dragonsurvivalteam.dragonsurvival.common.particles.SmallLightningParticleOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.network.particle.SyncParticleTrail;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDamageTypes;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.tags.DSEntityTypeTags;
import by.dragonsurvivalteam.dragonsurvival.util.AdditionalEffectData;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class ChargedEffect
extends ModifiableMobEffect {
    public static final int INFINITE_CHAINS = -1;
    @ConfigRange(min=-1.0)
    @Translation(key="charged_effect_max_chain", type=Translation.Type.CONFIGURATION, comments={"Determines the max. amount of times the charged effect can chain. Set to -1 for infinite chaining"})
    @ConfigOption(side=ConfigSide.SERVER, category={"effects", "charged"}, key="charged_effect_max_chain")
    public static Integer maxChain = 5;
    @ConfigRange(min=0.0)
    @Translation(key="charged_effect_max_chain_targets", type=Translation.Type.CONFIGURATION, comments={"Amount of entities the charged effect can chain to at once"})
    @ConfigOption(side=ConfigSide.SERVER, category={"effects", "charged"}, key="charged_effect_max_chain_targets")
    public static Integer maxChainTargets = 2;
    @ConfigRange(min=0.0, max=256.0)
    @Translation(key="charged_effect_spread_radius", type=Translation.Type.CONFIGURATION, comments={"Determines the radius of the charged effect spread"})
    @ConfigOption(side=ConfigSide.SERVER, category={"effects", "charged"}, key="charged_effect_spread_radius")
    public static Float spreadRadius = Float.valueOf(3.0f);
    @ConfigRange(min=0.0)
    @Translation(key="charged_effect_damage", type=Translation.Type.CONFIGURATION, comments={"Determines the damage dealt by the charged effect"})
    @ConfigOption(side=ConfigSide.SERVER, category={"effects", "charged"}, key="charged_effect_damage")
    public static Float damage = Float.valueOf(1.0f);

    public ChargedEffect(MobEffectCategory type, int color, boolean incurable) {
        super(type, color, incurable);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 20 == 0;
    }

    public void onEffectStarted(@NotNull LivingEntity livingEntity, int amplifier) {
        Creeper creeper;
        if (livingEntity instanceof Creeper && !(creeper = (Creeper)livingEntity).isPowered()) {
            creeper.getEntityData().set(Creeper.DATA_IS_POWERED, (Object)true);
        }
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        entity.hurt(new DamageSource(DSDamageTypes.get(entity.level(), DSDamageTypes.ELECTRIC)), damage.floatValue() * (float)(amplifier + 1));
        if (!DragonStateProvider.isDragon((Entity)entity)) {
            SmallLightningParticleOption particle = new SmallLightningParticleOption(37.0f, false);
            for (int i = 0; i < 4; ++i) {
                EffectHandler.renderEffectParticle(entity, particle);
            }
        }
        ChargedEffect.chargedEffectChain(entity, damage.floatValue() * (float)amplifier + 1.0f);
        return super.applyEffectTick(entity, amplifier);
    }

    public static void drawParticleLine(LivingEntity source, LivingEntity target) {
        if (source.level().isClientSide()) {
            return;
        }
        Vec3 start = source.position().add(0.0, (double)(source.getEyeHeight() / 2.0f), 0.0);
        Vec3 end = target.position().add(0.0, (double)(target.getEyeHeight() / 2.0f), 0.0);
        Vec3 trailMidpoint = end.subtract(start).scale(0.5).add(start);
        PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)source.level()), null, (double)trailMidpoint.x, (double)trailMidpoint.y, (double)trailMidpoint.z, (double)64.0, (CustomPacketPayload)new SyncParticleTrail(start.toVector3f(), end.toVector3f(), new LargeLightningParticleOption(37.0f, false)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void chargedEffectChain(LivingEntity source, float damage) {
        List secondaryTargets = source.level().getNearbyEntities(LivingEntity.class, TargetingConditions.forCombat(), source, source.getBoundingBox().inflate((double)spreadRadius.floatValue()));
        secondaryTargets.sort((c1, c2) -> Boolean.compare(c1.hasEffect(DSEffects.CHARGED), c2.hasEffect(DSEffects.CHARGED)));
        if (secondaryTargets.size() > maxChainTargets) {
            secondaryTargets = secondaryTargets.subList(0, maxChainTargets);
        }
        for (LivingEntity target : secondaryTargets) {
            Entity effectApplier = null;
            Level level = source.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                effectApplier = ((AdditionalEffectData)source.getEffect(DSEffects.CHARGED)).dragonSurvival$getApplier(serverLevel);
            }
            target.hurt(new DamageSource(DSDamageTypes.get(target.level(), DSDamageTypes.ELECTRIC), effectApplier), damage);
            ChargedEffect.drawParticleLine(source, target);
            if (target.level().isClientSide()) {
                return;
            }
            if (target == source || target.getType().is(DSEntityTypeTags.CHARGED_SPREAD_BLACKLIST)) continue;
            EntityStateHandler sourceData = (EntityStateHandler)source.getData(DSDataAttachments.ENTITY_HANDLER);
            EntityStateHandler targetData = (EntityStateHandler)target.getData(DSDataAttachments.ENTITY_HANDLER);
            targetData.chainCount = sourceData.chainCount + 1;
            if (targetData.chainCount >= maxChain && maxChain != -1 || !Functions.chance(target.getRandom(), 40)) continue;
            target.addEffect(new MobEffectInstance(DSEffects.CHARGED, Functions.secondsToTicks(10.0), 0, false, false), effectApplier);
        }
    }
}

