/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.creatures;

import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;

public interface ConfigurableAttributes {
    private LivingEntity self() {
        return (LivingEntity)this;
    }

    default public void setAttributes() {
        this.setBaseValue((Holder<Attribute>)Attributes.MAX_HEALTH, this.maxHealthConfig());
        this.setBaseValue((Holder<Attribute>)Attributes.ATTACK_DAMAGE, this.attackDamageConfig());
        this.setBaseValue((Holder<Attribute>)Attributes.ATTACK_KNOCKBACK, this.attackKnockback());
        this.setBaseValue((Holder<Attribute>)Attributes.MOVEMENT_SPEED, this.movementSpeedConfig());
        this.setBaseValue((Holder<Attribute>)Attributes.ARMOR, this.armorConfig());
        this.setBaseValue((Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, this.armorToughnessConfig());
        this.setBaseValue((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, this.knockbackResistanceConfig());
    }

    default public void setBaseValue(Holder<Attribute> attribute, double value) {
        if (Double.isNaN(value)) {
            return;
        }
        AttributeInstance instance = this.self().getAttribute(attribute);
        if (instance != null) {
            instance.setBaseValue(value);
            if (attribute == Attributes.MAX_HEALTH) {
                this.self().setHealth(this.self().getMaxHealth());
            }
        }
    }

    default public double maxHealthConfig() {
        return Double.NaN;
    }

    default public double attackDamageConfig() {
        return Double.NaN;
    }

    default public double attackKnockback() {
        return Double.NaN;
    }

    default public double movementSpeedConfig() {
        return Double.NaN;
    }

    default public double armorConfig() {
        return Double.NaN;
    }

    default public double armorToughnessConfig() {
        return Double.NaN;
    }

    default public double knockbackResistanceConfig() {
        return Double.NaN;
    }
}

