/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.creatures;

import by.dragonsurvivalteam.dragonsurvival.client.render.util.RandomAnimationPicker;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.Hunter;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.util.AnimationUtils;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class KnightEntity
extends Hunter {
    @ConfigRange(min=1.0)
    @Translation(key="knight_health", type=Translation.Type.CONFIGURATION, comments={"Base value for the max health attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "knight"}, key="knight_health")
    public static double MAX_HEALTH = 40.0;
    @ConfigRange(min=0.0)
    @Translation(key="knight_attack_damage", type=Translation.Type.CONFIGURATION, comments={"Base value for the attack damage attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "knight"}, key="knight_damage")
    public static int ATTACK_DAMAGE = 12;
    @ConfigRange(min=0.0)
    @Translation(key="knight_attack_knockback", type=Translation.Type.CONFIGURATION, comments={"Base value for the attack knockback attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "knight"}, key="knight_attack_knockback")
    public static int ATTACK_KNOCKBACK = 0;
    @ConfigRange(min=0.0)
    @Translation(key="knight_movement_speed", type=Translation.Type.CONFIGURATION, comments={"Base value for the movement speed attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "knight"}, key="knight_movement_speed")
    public static double MOVEMENT_SPEED = 0.3;
    @ConfigRange(min=0.0)
    @Translation(key="knight_armor", type=Translation.Type.CONFIGURATION, comments={"Base value for the armor attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "knight"}, key="knight_armor")
    public static double ARMOR = 10.0;
    @ConfigRange(min=0.0)
    @Translation(key="knight_armor_toughness", type=Translation.Type.CONFIGURATION, comments={"Base value for the armor toughness attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "knight"}, key="knight_armor_toughness")
    public static double ARMOR_TOUGHNESS = 0.0;
    @ConfigRange(min=0.0)
    @Translation(key="knight_knockback_resistance", type=Translation.Type.CONFIGURATION, comments={"Base value for the knockback resistance attribute"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "knight"}, key="knight_knockback_resistance")
    public static double KNOCKBACK_RESISTANCE = 0.0;
    @ConfigRange(min=0.0)
    @Translation(key="knight_shield_chance", type=Translation.Type.CONFIGURATION, comments={"Determines the chance (in %) of knights having a shield"})
    @ConfigOption(side=ConfigSide.SERVER, category={"dragon_hunters", "knight"}, key="knight_shield_chance")
    public static double SHIELD_CHANCE = 0.1;
    private RawAnimation currentIdleAnim;
    private boolean isIdleAnimSet = false;
    private RawAnimation currentAttackAnim;
    private boolean isAttackAnimSet = false;
    private static final RandomAnimationPicker ATTACK_ANIMS = new RandomAnimationPicker(new RandomAnimationPicker.WeightedAnimation(RawAnimation.begin().thenLoop("attack1"), 90.0f), new RandomAnimationPicker.WeightedAnimation(RawAnimation.begin().thenLoop("attack2"), 10.0f));
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("run");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("walk");
    private static final RawAnimation SWIM = RawAnimation.begin().thenLoop("swim");
    private static final RandomAnimationPicker IDLE_ANIMS = new RandomAnimationPicker(new RandomAnimationPicker.WeightedAnimation(RawAnimation.begin().thenLoop("idle1"), 90.0f), new RandomAnimationPicker.WeightedAnimation(RawAnimation.begin().thenLoop("idle2"), 10.0f));
    private static final RawAnimation HEAD_BLEND = RawAnimation.begin().thenLoop("blend_head");

    @Override
    public double maxHealthConfig() {
        return MAX_HEALTH;
    }

    @Override
    public double attackDamageConfig() {
        return ATTACK_DAMAGE;
    }

    @Override
    public double attackKnockback() {
        return ATTACK_KNOCKBACK;
    }

    @Override
    public double movementSpeedConfig() {
        return MOVEMENT_SPEED;
    }

    @Override
    public double armorConfig() {
        return ARMOR;
    }

    @Override
    public double armorToughnessConfig() {
        return ARMOR_TOUGHNESS;
    }

    @Override
    public double knockbackResistanceConfig() {
        return KNOCKBACK_RESISTANCE;
    }

    public KnightEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "everything", 3, this::fullPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "head", 3, this::headPredicate));
    }

    private boolean isNotIdle() {
        double movement = AnimationUtils.getMovementSpeed((LivingEntity)this);
        return this.swingTime > 0 || movement > this.getWalkThreshold() || this.isInWater();
    }

    public PlayState fullPredicate(AnimationState<KnightEntity> state) {
        double movement = AnimationUtils.getMovementSpeed((LivingEntity)this);
        if (this.swingTime == 0) {
            this.isAttackAnimSet = false;
        }
        if (this.isIdleAnimSet) {
            boolean bl = this.isIdleAnimSet = !this.isNotIdle();
        }
        if (this.swingTime > 0) {
            return state.setAndContinue(this.getAttackAnim());
        }
        if (this.isInWater()) {
            return state.setAndContinue(SWIM);
        }
        if (movement > this.getRunThreshold()) {
            return state.setAndContinue(RUN);
        }
        if (movement > this.getWalkThreshold()) {
            return state.setAndContinue(WALK);
        }
        return state.setAndContinue(this.getIdleAnim());
    }

    public RawAnimation getIdleAnim() {
        if (!this.isIdleAnimSet) {
            this.currentIdleAnim = IDLE_ANIMS.pickRandomAnimation();
            this.isIdleAnimSet = true;
        }
        return this.currentIdleAnim;
    }

    public RawAnimation getAttackAnim() {
        if (!this.isAttackAnimSet) {
            this.currentAttackAnim = ATTACK_ANIMS.pickRandomAnimation();
            this.isAttackAnimSet = true;
        }
        return this.currentAttackAnim;
    }

    public PlayState headPredicate(AnimationState<Hunter> state) {
        return state.setAndContinue(HEAD_BLEND);
    }

    public int getCurrentSwingDuration() {
        return 17;
    }

    public double getRunThreshold() {
        return 0.15;
    }

    public double getWalkThreshold() {
        return 0.01;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
    }

    @Override
    public void tick() {
        super.tick();
        this.applyMagicDisabledDebuff();
    }

    private void applyMagicDisabledDebuff() {
        double detectionRadius = 12.0;
        List players = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(detectionRadius));
        for (Player player : players) {
            if (!DragonStateProvider.isDragon((Entity)player)) continue;
            player.addEffect(new MobEffectInstance(DSEffects.MAGIC_DISABLED, 240, 0, false, true));
        }
    }

    public boolean isBlocking() {
        if (this.getOffhandItem().getItem() == Items.SHIELD) {
            return this.random.nextBoolean();
        }
        return false;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor serverWorld, @NotNull DifficultyInstance difficultyInstance, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        return super.finalizeSpawn(serverWorld, difficultyInstance, spawnReason, entityData);
    }

    protected void populateDefaultEquipmentSlots(@NotNull RandomSource randomSource, @NotNull DifficultyInstance difficultyInstance) {
        this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.IRON_SWORD));
        if (this.random.nextDouble() < SHIELD_CHANCE) {
            this.setItemInHand(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.SHIELD));
        }
    }
}

