/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles;

import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Bolas
extends AbstractArrow {
    public Bolas(Level world) {
        super((EntityType)DSEntities.BOLAS_ENTITY.get(), world);
    }

    public Bolas(double x, double y, double z, Level level, ItemStack pickup, @Nullable ItemStack firedFrom) {
        super((EntityType)DSEntities.BOLAS_ENTITY.value(), x, y, z, level, pickup, firedFrom);
    }

    public Bolas(LivingEntity owner, Level level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super((EntityType)DSEntities.BOLAS_ENTITY.value(), owner, level, pickupItemStack, firedFromWeapon);
    }

    protected void onHit(@NotNull HitResult result) {
        super.onHit(result);
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.getEntity();
        if (!entity.level().isClientSide() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.hurt(this.damageSources().arrow((AbstractArrow)this, this.getOwner()), 1.0f);
            if (ServerConfig.hunterTrappedDebuffDuration > 0.0) {
                living.addEffect(new MobEffectInstance(DSEffects.TRAPPED, Functions.secondsToTicks(ServerConfig.hunterTrappedDebuffDuration), 0, false, false), this.getOwner());
            }
        }
        super.onHitEntity(entityHitResult);
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

