/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncEnderDragonMark;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.EnderDragonDamageHistory;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.ClientEffectProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class EnderDragonMarkHandler {
    @Translation(key="ender_dragon_curses_you", type=Translation.Type.CONFIGURATION, comments={"If enabled, the ender dragon will curse you with an effect that prevents you from using some of your abilities when killed."})
    @ConfigOption(side=ConfigSide.SERVER, category={"ender_dragon"}, key="ender_dragon_curses_you")
    public static Boolean enderDragonCursesYou = true;
    public static final ClientEffectProvider MARK_EFFECT = new ClientEffectProvider(){
        @Translation(type=Translation.Type.GUI, comments={"Ender Dragon's Curse"})
        private static final ResourceLocation NAME = DragonSurvival.res("ender_dragon_curse");
        @Translation(comments={"You have been cursed by the ender dragon. You may be unable to use some of your abilities. You can cure this curse by using a Primordial Anchor block after resurrecting the dragon."})
        private static final String DESCRIPTION = Translation.Type.GUI.wrap("ender_dragon_curse.tooltip");
        private static final ClientEffectProvider.ClientData DATA = new ClientEffectProvider.ClientData(DragonSurvival.res("ender_dragon_curse"), DragonSurvival.res("textures/mob_effect/ender_dragon_curse.png"), (Component)Component.translatable((String)Translation.Type.GUI.wrap(NAME)), (Component)Component.empty());

        @Override
        public Component getDescription() {
            return Component.translatable((String)DESCRIPTION);
        }

        @Override
        public ClientEffectProvider.ClientData clientData() {
            return DATA;
        }

        @Override
        public int getDuration() {
            return -1;
        }

        @Override
        public int currentDuration() {
            return 0;
        }
    };

    @SubscribeEvent
    public static void onEnderDragonHealthChanged(LivingDamageEvent.Post event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EnderDragon) {
            EnderDragon enderDragon = (EnderDragon)livingEntity;
            Entity entity = event.getSource().getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                EnderDragonDamageHistory data = EnderDragonDamageHistory.getData(enderDragon);
                data.addDamage(player.getUUID(), event.getNewDamage());
            }
            if (event.getNewDamage() < 0.0f) {
                EnderDragonDamageHistory data = EnderDragonDamageHistory.getData(enderDragon);
                data.addDamageAll(event.getNewDamage());
            }
        }
    }

    @SubscribeEvent
    public static void onEnderDragonDeath(LivingDeathEvent event) {
        if (!enderDragonCursesYou.booleanValue() || event.getEntity().level().isClientSide()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EnderDragon) {
            EnderDragon dragon = (EnderDragon)livingEntity;
            EnderDragonDamageHistory data = EnderDragonDamageHistory.getData(dragon);
            for (Player player : data.getPlayers(event.getEntity().level())) {
                DragonStateHandler handler = DragonStateProvider.getData(player);
                if (!handler.isDragon()) continue;
                handler.markedByEnderDragon = true;
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new SyncEnderDragonMark(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

