/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.config;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ResourceLocationWrapper;
import by.dragonsurvivalteam.dragonsurvival.config.ClientConfig;
import by.dragonsurvivalteam.dragonsurvival.config.ConfigUtils;
import by.dragonsurvivalteam.dragonsurvival.config.CustomConfig;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigType;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.DSLanguageProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import com.electronwill.nightconfig.core.EnumGetMethod;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.modscan.ModAnnotation;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ConfigHandler {
    private static final HashMap<String, Object> DEFAULT_CONFIG_VALUES = new HashMap();
    private static final HashMap<String, ConfigType> CONFIG_TYPES = new HashMap();
    private static final HashMap<String, ConfigOption> CONFIG_OBJECTS = new HashMap();
    private static final HashMap<String, Field> CONFIG_FIELDS = new HashMap();
    private static final HashMap<ConfigSide, Set<String>> CONFIG_KEYS = new HashMap();
    private static final HashMap<String, ModConfigSpec.ConfigValue<?>> CONFIG_VALUES = new HashMap();
    private static final HashMap<Class<?>, Registry<?>> REGISTRY_MAP = new HashMap();

    private static void initRegistryMapping() {
        REGISTRY_MAP.put(Item.class, (Registry<?>)BuiltInRegistries.ITEM);
        REGISTRY_MAP.put(Block.class, (Registry<?>)BuiltInRegistries.BLOCK);
        REGISTRY_MAP.put(EntityType.class, (Registry<?>)BuiltInRegistries.ENTITY_TYPE);
        REGISTRY_MAP.put(BlockEntityType.class, BuiltInRegistries.BLOCK_ENTITY_TYPE);
        REGISTRY_MAP.put(Biome.class, BuiltInRegistries.BIOME_SOURCE);
        REGISTRY_MAP.put(MobEffect.class, BuiltInRegistries.MOB_EFFECT);
        REGISTRY_MAP.put(Potion.class, BuiltInRegistries.POTION);
    }

    private static List<Field> getFields() {
        ArrayList<Field> instances = new ArrayList<Field>();
        org.objectweb.asm.Type annotationType = org.objectweb.asm.Type.getType(ConfigOption.class);
        ModList.get().getAllScanData().forEach(scanData -> {
            List<ModFileScanData.AnnotationData> targets = scanData.getAnnotations().stream().filter(annotationData -> annotationData.targetType() == ElementType.FIELD && annotationType.equals((Object)annotationData.annotationType())).toList();
            targets.forEach(annotationData -> {
                Dist side;
                ModAnnotation.EnumHolder sidesValue = (ModAnnotation.EnumHolder)annotationData.annotationData().get("side");
                Dist dist = side = Objects.equals(sidesValue.value(), "CLIENT") ? Dist.CLIENT : Dist.DEDICATED_SERVER;
                if (side == FMLEnvironment.dist || side == Dist.DEDICATED_SERVER) {
                    try {
                        Class<?> classType = Class.forName(annotationData.clazz().getClassName());
                        Field field = classType.getDeclaredField(annotationData.memberName());
                        instances.add(field);
                    }
                    catch (Exception e) {
                        DragonSurvival.LOGGER.error((Object)e);
                    }
                }
            });
        });
        return instances;
    }

    public static void initConfig() {
        ArrayList duplicateKeys = new ArrayList();
        ConfigHandler.initRegistryMapping();
        ConfigHandler.getFields().forEach(field -> {
            boolean keyAdded;
            if (!Modifier.isStatic(field.getModifiers())) {
                return;
            }
            ConfigOption configOption = field.getAnnotation(ConfigOption.class);
            try {
                DEFAULT_CONFIG_VALUES.put(configOption.key(), field.get(null));
            }
            catch (IllegalAccessException e) {
                DragonSurvival.LOGGER.error("There was a problem while trying to get the default config value of [{}]", (Object)ConfigHandler.createConfigPath(configOption), (Object)e);
            }
            CONFIG_FIELDS.put(configOption.key(), (Field)field);
            CONFIG_OBJECTS.put(configOption.key(), configOption);
            ConfigType configType = field.getAnnotation(ConfigType.class);
            if (configType != null) {
                CONFIG_TYPES.put(configOption.key(), configType);
            }
            if (!(keyAdded = CONFIG_KEYS.computeIfAbsent(configOption.side(), key -> new HashSet()).add(configOption.key()))) {
                duplicateKeys.add(configOption.key());
            }
        });
        if (!duplicateKeys.isEmpty()) {
            throw new IllegalStateException("Tried to add duplicate config keys: " + String.valueOf(duplicateKeys));
        }
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        if (FMLLoader.getDist().isClient()) {
            Pair clientConfig = new ModConfigSpec.Builder().configure(ClientConfig::new);
            modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientConfig.getRight());
        }
        Pair serverConfig = new ModConfigSpec.Builder().configure(ServerConfig::new);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverConfig.getRight());
    }

    public static void resetConfigValues(ConfigSide side) {
        CONFIG_KEYS.get((Object)side).forEach(ConfigHandler::resetConfigValue);
    }

    public static void resetConfigValue(String configKey) {
        ModConfigSpec.ConfigValue<?> configValue = CONFIG_VALUES.get(configKey);
        configValue.set(configValue.getDefault());
        Field field = CONFIG_FIELDS.get(configKey);
        try {
            field.set(null, ConfigHandler.convertToFieldValue(field, configKey));
        }
        catch (IllegalAccessException exception) {
            DragonSurvival.LOGGER.error("Failed to update the field [{}] with the default config value", (Object)field.getName(), (Object)exception);
        }
    }

    public static Field getField(String configKey) {
        Field field = CONFIG_FIELDS.get(configKey);
        if (field == null) {
            throw new IllegalArgumentException("There is no field for the supplied config key [" + configKey + "]");
        }
        return field;
    }

    public static void createConfigEntries(ModConfigSpec.Builder builder, ConfigSide side) {
        for (String key : CONFIG_KEYS.getOrDefault((Object)side, Set.of())) {
            String[] categories;
            block30: {
                String[] stringArray;
                ConfigOption configOption = CONFIG_OBJECTS.get(key);
                Field field = CONFIG_FIELDS.get(key);
                Object defaultValues = DEFAULT_CONFIG_VALUES.get(configOption.key());
                List<Translation> translations = DSLanguageProvider.getTranslations(field).stream().filter(translation -> translation.type() == Translation.Type.CONFIGURATION).toList();
                if (translations.size() != 1) {
                    throw new IllegalStateException("Configuration key [" + key + "] had [" + translations.size() + "] translations - expected 1");
                }
                Translation translation2 = translations.getFirst();
                if (configOption.category() != null && configOption.category().length > 0) {
                    stringArray = configOption.category();
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "general";
                }
                for (String category : categories = stringArray) {
                    builder.translation(LangKey.CATEGORY_PREFIX + category);
                    builder.push(category);
                }
                builder.comment(translation2.comments());
                builder.translation(translation2.type().prefix + translation2.key());
                if (configOption.worldRestart()) {
                    builder.worldRestart();
                }
                if (configOption.gameRestart()) {
                    builder.gameRestart();
                }
                try {
                    boolean hasRange;
                    ConfigRange range = field.isAnnotationPresent(ConfigRange.class) ? field.getAnnotation(ConfigRange.class) : null;
                    boolean bl = hasRange = range != null;
                    if (defaultValues instanceof Integer) {
                        Integer value = (Integer)defaultValues;
                        int minValue = Integer.MIN_VALUE;
                        int maxValue = Integer.MAX_VALUE;
                        if (hasRange) {
                            minValue = Double.isNaN(range.min()) ? minValue : (int)range.min();
                            maxValue = Double.isNaN(range.max()) ? maxValue : (int)range.max();
                        }
                        CONFIG_VALUES.put(key, (ModConfigSpec.ConfigValue<?>)builder.defineInRange(configOption.key(), value.intValue(), minValue, maxValue));
                        break block30;
                    }
                    if (defaultValues instanceof Float) {
                        Float value = (Float)defaultValues;
                        double minValue = 1.4E-45f;
                        double maxValue = 3.4028234663852886E38;
                        if (hasRange) {
                            minValue = Double.isNaN(range.min()) ? minValue : range.min();
                            maxValue = Double.isNaN(range.max()) ? maxValue : range.max();
                        }
                        CONFIG_VALUES.put(key, (ModConfigSpec.ConfigValue<?>)builder.defineInRange(configOption.key(), (double)value.floatValue(), minValue, maxValue));
                        break block30;
                    }
                    if (defaultValues instanceof Long) {
                        Long value = (Long)defaultValues;
                        long minValue = Long.MIN_VALUE;
                        long maxValue = Long.MAX_VALUE;
                        if (hasRange) {
                            minValue = Double.isNaN(range.min()) ? minValue : (long)range.min();
                            maxValue = Double.isNaN(range.max()) ? maxValue : (long)range.max();
                        }
                        CONFIG_VALUES.put(key, (ModConfigSpec.ConfigValue<?>)builder.defineInRange(configOption.key(), value.longValue(), minValue, maxValue));
                        break block30;
                    }
                    if (defaultValues instanceof Double) {
                        Double value = (Double)defaultValues;
                        double minValue = Double.MIN_VALUE;
                        double maxValue = Double.MAX_VALUE;
                        if (hasRange) {
                            minValue = Double.isNaN(range.min()) ? minValue : range.min();
                            maxValue = Double.isNaN(range.max()) ? maxValue : range.max();
                        }
                        CONFIG_VALUES.put(key, (ModConfigSpec.ConfigValue<?>)builder.defineInRange(configOption.key(), value.doubleValue(), minValue, maxValue));
                        break block30;
                    }
                    if (defaultValues instanceof Boolean) {
                        Boolean value = (Boolean)defaultValues;
                        CONFIG_VALUES.put(key, (ModConfigSpec.ConfigValue<?>)builder.define(configOption.key(), value.booleanValue()));
                        break block30;
                    }
                    if (field.getType().isEnum()) {
                        CONFIG_VALUES.put(key, (ModConfigSpec.ConfigValue<?>)builder.defineEnum(configOption.key(), (Enum)defaultValues, (Enum[])((Enum)defaultValues).getClass().getEnumConstants()));
                        break block30;
                    }
                    if (defaultValues instanceof List) {
                        List list = (List)defaultValues;
                        ModConfigSpec.Range sizeRange = ModConfigSpec.Range.of((int)0, (int)Integer.MAX_VALUE);
                        ModConfigSpec.ConfigValue<List<?>> configList = null;
                        boolean handledList = false;
                        Type type = field.getGenericType();
                        if (type instanceof ParameterizedType) {
                            ParameterizedType listParameter = (ParameterizedType)type;
                            String className = listParameter.getActualTypeArguments()[0].getTypeName();
                            try {
                                Class<?> customConfigType = Class.forName(className);
                                if (CustomConfig.class.isAssignableFrom(customConfigType)) {
                                    List<String> customList = list.stream().map(customConfig -> ((CustomConfig)customConfig).convert()).toList();
                                    configList = ConfigHandler.buildList(builder, configOption, (ModConfigSpec.Range<Integer>)sizeRange, customList, configValue -> CustomConfig.getInstance(customConfigType).validate(configValue));
                                    handledList = true;
                                }
                            }
                            catch (ClassNotFoundException exception) {
                                DragonSurvival.LOGGER.error("A problem occurred while trying to handle the config [{}]", (Object)configOption.key(), (Object)exception);
                            }
                        }
                        if (!handledList) {
                            configList = ConfigHandler.buildList(builder, configOption, (ModConfigSpec.Range<Integer>)sizeRange, list, configValue -> ConfigHandler.checkSpecific(configOption, configValue));
                        }
                        CONFIG_VALUES.put(key, configList);
                        break block30;
                    }
                    if (defaultValues instanceof CustomConfig) {
                        CustomConfig value = (CustomConfig)defaultValues;
                        CONFIG_VALUES.put(key, builder.define(configOption.key(), (Object)value.convert()));
                    } else if (defaultValues instanceof String) {
                        String value = (String)defaultValues;
                        CONFIG_VALUES.put(key, builder.define(configOption.key(), (Object)value));
                    } else {
                        ModConfigSpec.ConfigValue value = builder.define(configOption.key(), defaultValues);
                        CONFIG_VALUES.put(key, value);
                        DragonSurvival.LOGGER.warn("Potential issue found for configuration: [{}]", (Object)configOption.key());
                    }
                }
                catch (Exception e) {
                    DragonSurvival.LOGGER.error("Invalid configuration found: [{}]", (Object)configOption.key(), (Object)e);
                }
            }
            for (int i = 0; i < categories.length; ++i) {
                builder.pop();
            }
        }
    }

    private static ModConfigSpec.ConfigValue<List<?>> buildList(ModConfigSpec.Builder builder, ConfigOption config, ModConfigSpec.Range<Integer> sizeRange, List<?> defaultValues, Predicate<Object> validation) {
        return builder.defineList(List.of(config.key()), () -> defaultValues, () -> "", configValue -> {
            if (validation.test(configValue)) {
                return true;
            }
            DragonSurvival.LOGGER.debug("Config entry [{}] of config [{}] was invalid", configValue, (Object)config.key());
            return false;
        }, sizeRange);
    }

    private static boolean checkSpecific(ConfigOption configOption, Object configValue) {
        switch (configOption.validation()) {
            case RESOURCE_LOCATION: {
                return ResourceLocation.tryParse((String)((String)configValue)) != null;
            }
            case RESOURCE_LOCATION_REGEX: {
                return ResourceLocationWrapper.validateRegexResourceLocation(configValue.toString());
            }
            case RESOURCE_LOCATION_NUMBER: {
                String[] split = ((String)configValue).split(":");
                if (split.length != 3) {
                    return false;
                }
                if (ResourceLocation.tryParse((String)(split[0] + ":" + split[1])) == null) {
                    return false;
                }
                return ConfigUtils.validateInteger(split[2]);
            }
            case RESOURCE_LOCATION_OPTIONAL_NUMBER: {
                String[] split = ((String)configValue).split(":");
                if (split.length < 2) {
                    return false;
                }
                if (ResourceLocation.tryParse((String)(split[0] + ":" + split[1])) == null) {
                    return false;
                }
                if (split.length == 3) {
                    return ConfigUtils.validateInteger(split[2]);
                }
                return split.length == 2;
            }
            case RESOURCE_LOCATION_2_OPTIONAL_NUMBERS: {
                String[] split = ((String)configValue).split(":");
                if (split.length < 2) {
                    return false;
                }
                if (ResourceLocation.tryParse((String)(split[0] + ":" + split[1])) == null) {
                    return false;
                }
                if (split.length != 4) break;
                return ConfigUtils.validateInteger(split[2]) && ConfigUtils.validateDouble(split[3]);
            }
        }
        return true;
    }

    private static <T> List<T> parseResourceLocation(@NotNull Registry<T> registry, String location) {
        ResourceLocation resourceLocation = ResourceLocation.tryParse((String)location);
        if (resourceLocation == null) {
            String[] splitLocation = location.split(":", 2);
            if (splitLocation.length < 2) {
                return List.of();
            }
            ArrayList list = new ArrayList();
            registry.registryKeySet().forEach(key -> {
                Pattern pattern;
                Matcher matcher;
                ResourceLocation keyLocation = key.location();
                if (keyLocation.getNamespace().equals(splitLocation[0]) && (matcher = (pattern = Pattern.compile(splitLocation[1])).matcher(keyLocation.getPath())).matches()) {
                    list.add(registry.get(key));
                }
            });
            return list;
        }
        if (registry.containsKey(resourceLocation)) {
            Optional optional = registry.getHolder(resourceLocation);
            if (optional.isPresent() && ((Holder.Reference)optional.get()).isBound()) {
                return List.of(((Holder.Reference)optional.get()).value());
            }
        } else {
            Optional<TagKey> tag = registry.getTagNames().filter(registryTag -> registryTag.location().equals((Object)resourceLocation)).findAny();
            if (tag.isPresent()) {
                ArrayList list = new ArrayList();
                registry.holders().forEach(holder -> holder.tags().forEach(holderTag -> {
                    if (((TagKey)tag.get()).equals(holderTag)) {
                        list.add(holder.value());
                    }
                }));
                return list;
            }
        }
        return List.of();
    }

    @Nullable
    private static Object convertToFieldValue(Field field, Object value, @Nullable Class<?> registryType) {
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType listParameter = (ParameterizedType)type;
            try {
                Class<?> classType = Class.forName(listParameter.getActualTypeArguments()[0].getTypeName());
                if (CustomConfig.class.isAssignableFrom(classType) && value instanceof String) {
                    String string = (String)value;
                    return CustomConfig.getInstance(classType).parse(string);
                }
            }
            catch (ClassNotFoundException exception) {
                DragonSurvival.LOGGER.error("A problem occurred while trying to parse a custom config entry: {}", value);
            }
        }
        if (value instanceof String) {
            String string = (String)value;
            if (field.getType().isEnum()) {
                Class<?> cs = field.getType();
                return EnumGetMethod.ORDINAL_OR_NAME.get(value, cs);
            }
            Registry<?> registry = REGISTRY_MAP.get(registryType);
            if (registry != null) {
                List<?> list = ConfigHandler.parseResourceLocation(registry, string);
                if (field.getGenericType() instanceof List) {
                    return list.isEmpty() ? List.of(string) : list;
                }
                return list.isEmpty() ? null : string;
            }
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (field.getType().equals(Double.TYPE) || field.getType().equals(Double.class)) {
                return number.doubleValue();
            }
            if (field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class)) {
                return number.intValue();
            }
            if (field.getType().equals(Long.TYPE) || field.getType().equals(Long.class)) {
                return number.longValue();
            }
            if (field.getType().equals(Float.TYPE) || field.getType().equals(Float.class)) {
                return Float.valueOf(number.floatValue());
            }
            return number;
        }
        return value;
    }

    @SubscribeEvent
    public static void handleConfigLoading(ModConfigEvent.Loading event) {
        ConfigHandler.handleConfigChange(event.getConfig().getType());
    }

    @SubscribeEvent
    public static void handleConfigReloading(ModConfigEvent.Reloading event) {
        ConfigHandler.handleConfigChange(event.getConfig().getType());
    }

    private static void handleConfigChange(ModConfig.Type type) {
        ConfigSide side = type == ModConfig.Type.SERVER ? ConfigSide.SERVER : ConfigSide.CLIENT;
        Set<String> configKeys = CONFIG_KEYS.get((Object)side);
        for (String configKey : configKeys) {
            try {
                Object value;
                Field field;
                if (!CONFIG_VALUES.containsKey(configKey) || !CONFIG_FIELDS.containsKey(configKey) || (field = CONFIG_FIELDS.get(configKey)) == null || (value = ConfigHandler.convertToFieldValue(field, configKey)) == null) continue;
                field.set(null, value);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                DragonSurvival.LOGGER.error("An error occurred while setting the config [{}]", (Object)configKey, (Object)exception);
            }
        }
    }

    public static void updateConfigValue(String configKey, Object newValue) {
        ModConfigSpec.ConfigValue<?> valueHolder = CONFIG_VALUES.get(configKey);
        if (valueHolder == null) {
            DragonSurvival.LOGGER.error("There is no known config for [{}]", (Object)configKey);
            return;
        }
        if (newValue != null) {
            Object convertedValue = ConfigHandler.convertToConfigValue(newValue);
            boolean isValid = valueHolder.getSpec().test(convertedValue);
            if (!isValid) {
                DragonSurvival.LOGGER.error("Tried to set an invalid value [{}] for the config [{}]", convertedValue, (Object)configKey);
                return;
            }
            valueHolder.set(convertedValue);
            valueHolder.save();
        } else {
            ConfigHandler.resetConfigValue(configKey);
        }
        try {
            Field field = CONFIG_FIELDS.get(configKey);
            field.set(null, ConfigHandler.convertToFieldValue(field, configKey));
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException exception) {
            DragonSurvival.LOGGER.error("An error occurred while trying to update the config [{}] with the value [{}]", (Object)configKey, newValue, (Object)exception);
        }
    }

    private static Object convertToConfigValue(Object object) {
        ArrayList<Object> result;
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object listElement : collection) {
                list.add(ConfigHandler.getRelevantConfigValue(listElement));
            }
            result = list;
        } else {
            result = ConfigHandler.getRelevantConfigValue(object);
        }
        return result;
    }

    private static Object getRelevantConfigValue(Object object) {
        if (object instanceof Registry) {
            Registry registry = (Registry)object;
            return registry.key().location();
        }
        if (object instanceof CustomConfig) {
            CustomConfig customConfig = (CustomConfig)object;
            return customConfig.convert();
        }
        if (object instanceof Enum) {
            Enum enumValue = (Enum)object;
            return enumValue.name();
        }
        if (object instanceof Item) {
            Item item = (Item)object;
            return item.builtInRegistryHolder().key().location();
        }
        if (object instanceof Block) {
            Block block = (Block)object;
            return block.builtInRegistryHolder().key().location();
        }
        return object;
    }

    @Nullable
    private static Object convertToFieldValue(Field field, String configKey) {
        ArrayList<Object> result;
        Class<?> registryType;
        ArrayList<Object> configValue = CONFIG_VALUES.get(configKey).get();
        ConfigType configType = CONFIG_TYPES.get(configKey);
        Class<?> clazz = registryType = configType != null ? configType.value() : null;
        if (Collection.class.isAssignableFrom(field.getType())) {
            Collection collection = configValue;
            ArrayList<Object> resultList = new ArrayList<Object>();
            for (Object listValue : collection) {
                Object value = ConfigHandler.convertToFieldValue(field, listValue, registryType);
                if (value == null) continue;
                resultList.add(value);
            }
            result = resultList;
        } else {
            if (CustomConfig.class.isAssignableFrom(field.getType())) {
                return CustomConfig.getInstance(field.getType()).parse((String)((Object)configValue));
            }
            result = configValue;
        }
        return ConfigHandler.convertToFieldValue(field, result, registryType);
    }

    public static <T> HashSet<T> getResourceElements(Class<T> type, List<String> values) {
        Registry registry = REGISTRY_MAP.getOrDefault(type, null);
        HashSet<T> hashSet = new HashSet<T>();
        for (String rawResourceLocation : values) {
            if (rawResourceLocation == null) continue;
            hashSet.addAll(ConfigHandler.parseResourceLocation(registry, rawResourceLocation));
        }
        return hashSet;
    }

    private static String createConfigPath(ConfigOption configOption) {
        return ConfigHandler.createConfigPath(configOption.category(), configOption.key());
    }

    private static String createConfigPath(String[] category, String key) {
        StringBuilder path = new StringBuilder();
        for (String pathElement : category) {
            path.append(pathElement).append(".");
        }
        path.append(key);
        return path.toString();
    }
}

