/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.config;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ConfigUtils {
    private static final int NAMESPACE = 0;
    private static final int PATH = 1;

    public static Predicate<ItemStack> itemStackPredicate(String[] splitData) {
        boolean isTag = splitData[0].startsWith("#");
        ResourceLocation location = ConfigUtils.getLocation(splitData, isTag);
        if (isTag) {
            TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location);
            return stack -> stack.is(tag);
        }
        Item item = (Item)BuiltInRegistries.ITEM.get(location);
        return stack -> stack.is(item);
    }

    public static Predicate<Item> itemPredicate(String[] splitData) {
        boolean isTag = splitData[0].startsWith("#");
        ResourceLocation location = ConfigUtils.getLocation(splitData, isTag);
        if (isTag) {
            TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location);
            return item -> item.builtInRegistryHolder().is(tag);
        }
        Item itemToCheck = (Item)BuiltInRegistries.ITEM.get(location);
        return item -> item == itemToCheck;
    }

    public static Predicate<BlockState> blockStatePredicate(String[] splitData) {
        boolean isTag = splitData[0].startsWith("#");
        ResourceLocation location = ConfigUtils.getLocation(splitData, isTag);
        if (isTag) {
            TagKey tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)location);
            return stack -> stack.is(tag);
        }
        Block block = (Block)BuiltInRegistries.BLOCK.get(location);
        return stack -> stack.is(block);
    }

    public static Supplier<HolderSet<Item>> itemSupplier(String[] splitData) {
        boolean isTag = splitData[0].startsWith("#");
        ResourceLocation location = ConfigUtils.getLocation(splitData, isTag);
        if (isTag) {
            TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location);
            return () -> {
                Optional optional = BuiltInRegistries.ITEM.getTag(tag);
                return optional.isPresent() ? (HolderSet)optional.get() : HolderSet.empty();
            };
        }
        return () -> {
            Optional optional = BuiltInRegistries.ITEM.getHolder(location);
            return optional.isPresent() ? HolderSet.direct((Holder[])new Holder[]{(Holder)optional.get()}) : HolderSet.empty();
        };
    }

    public static boolean validateResourceLocation(String[] splitData) {
        if (splitData.length < 2) {
            return false;
        }
        String namespace = splitData[0].startsWith("#") ? splitData[0].substring(1) : splitData[0];
        String path = splitData[1];
        return ResourceLocation.tryParse((String)(namespace + ":" + path)) != null;
    }

    public static boolean validateInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean validateFloat(String string) {
        try {
            Float.parseFloat(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean validateDouble(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String location(Object object) {
        if (object instanceof TagKey) {
            TagKey tag = (TagKey)object;
            return "#" + String.valueOf(tag.location());
        }
        if (object instanceof Block) {
            Block block = (Block)object;
            return ConfigUtils.location(block.builtInRegistryHolder().getRegisteredName());
        }
        if (object instanceof Item) {
            Item item = (Item)object;
            return ConfigUtils.location(item.builtInRegistryHolder().getRegisteredName());
        }
        if (object instanceof ResourceKey) {
            ResourceKey key = (ResourceKey)object;
            return ConfigUtils.location(key);
        }
        if (object instanceof Holder) {
            Holder holder = (Holder)object;
            return holder.getRegisteredName();
        }
        if (object instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)object;
            return location.toString();
        }
        throw new IllegalArgumentException("Cannot handle [" + object.getClass().getName() + "]");
    }

    private static String location(ResourceKey<?> key) {
        return key.location().toString();
    }

    private static ResourceLocation getLocation(String[] splitData, boolean isTag) {
        if (isTag) {
            return DragonSurvival.location(splitData[0].substring(1), splitData[1]);
        }
        return DragonSurvival.location(splitData[0], splitData[1]);
    }
}

