/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.config;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.ResourceLocationWrapper;
import by.dragonsurvivalteam.dragonsurvival.config.CustomConfig;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;

public class EffectConfig
implements CustomConfig {
    private final Set<ResourceLocation> effects;
    private final int duration;
    private final int amplifier;
    private final double durationMultiplier;
    private final double amplifierMultiplier;
    private final String originalData;
    private static final int EFFECTS = 0;
    private static final int DURATION = 1;
    private static final int AMPLIFIER = 2;
    private static final int DURATION_MULTIPLIER = 3;
    private static final int AMPLIFIER_MULTIPLIER = 4;

    public EffectConfig() {
        this("", 0, 0, 0.0, 0.0, "");
    }

    private EffectConfig(String effectResource, int duration, int amplifier, double durationMultiplier, double amplifierMultiplier, String originalData) {
        this.effects = ResourceLocationWrapper.getEntries(effectResource, BuiltInRegistries.MOB_EFFECT);
        this.duration = duration;
        this.amplifier = amplifier;
        this.durationMultiplier = durationMultiplier;
        this.amplifierMultiplier = amplifierMultiplier;
        this.originalData = originalData;
    }

    public static EffectConfig create(Holder<MobEffect> effect, int duration, int amplifier, double durationMultiplier, double amplifierMultiplier) {
        String data = effect.getRegisteredName() + ";" + duration + ";" + amplifier + ";" + durationMultiplier + ";" + amplifierMultiplier;
        return new EffectConfig(effect.getRegisteredName(), duration, amplifier, durationMultiplier, amplifierMultiplier, data);
    }

    public void applyEffects(Player player, int level) {
        this.effects.forEach(resource -> BuiltInRegistries.MOB_EFFECT.getHolder(resource).ifPresent(effect -> {
            int duration = (int)((double)this.duration * (1.0 + (double)level * this.durationMultiplier));
            int amplifier = (int)((double)(1 + this.amplifier) * (1.0 + (double)level * this.amplifierMultiplier));
            MobEffectInstance instance = new MobEffectInstance((Holder)effect, duration, amplifier - 1, false, true);
            player.addEffect(instance);
        }));
    }

    @Override
    public CustomConfig parse(String data) {
        String[] elements = data.split(";");
        int duration = Integer.parseInt(elements[1]);
        int amplifier = Integer.parseInt(elements[2]);
        double durationMultiplier = Double.parseDouble(elements[3]);
        double amplifierMultiplier = Double.parseDouble(elements[4]);
        return new EffectConfig(elements[0], duration, amplifier, durationMultiplier, amplifierMultiplier, data);
    }

    @Override
    public boolean validate(Object configValue) {
        if (configValue instanceof String) {
            String string = (String)configValue;
            String[] elements = string.split(";");
            if (elements.length != 5) {
                return false;
            }
            if (!ResourceLocationWrapper.validateRegexResourceLocation(elements[0])) {
                return false;
            }
            try {
                int duration = Integer.parseInt(elements[1]);
                int amplifier = Integer.parseInt(elements[2]);
                double durationMultiplier = Double.parseDouble(elements[3]);
                double amplifierMultiplier = Double.parseDouble(elements[4]);
                if (duration <= 0 || amplifier < 0 || durationMultiplier < 0.0 || amplifierMultiplier < 0.0) {
                    return false;
                }
            }
            catch (NumberFormatException ignored) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String convert() {
        return this.originalData;
    }
}

