/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.client.gui.AbilityTooltipPositioner;
import by.dragonsurvivalteam.dragonsurvival.client.util.RenderingUtils;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.UpgradeType;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.DragonPenalty;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2ic;
import software.bernie.geckolib.util.Color;

public class AbilityAndPenaltyTooltipRenderer {
    @Translation(comments={"Hold 'Shift' for info"})
    private static final String INFO_SHIFT = Translation.Type.GUI.wrap("general.info_shift");
    @Translation(comments={"\u00a74Manually disabled\u00a7r"})
    private static final String MANUALLY_DISABLED = Translation.Type.GUI.wrap("general.manually_disabled");
    private static final ResourceLocation EFFECT_HEADER = DragonSurvival.res("ability_effect_header");
    private static final ResourceLocation BARS = DragonSurvival.res("textures/gui/widget_bars.png");
    private static final int MAX_SHOWN_LINES = 15;
    private static int maxScrollAmount = Integer.MAX_VALUE;

    public static int maxScroll() {
        return Math.max(0, maxScrollAmount - 15);
    }

    public static void drawTooltip(@NotNull GuiGraphics graphics, int x, int y, List<Component> shiftInfo, FormattedText rawDescription, int colorXPos, int colorYPos, String headerTranslationKey, Component name, Color tooltipBackgroundColor, int maxLevel, int abilityLevel, ResourceLocation icon, int scrollAmount) {
        int sideWidth;
        FormattedText textContents = AbilityAndPenaltyTooltipRenderer.formatText(shiftInfo);
        int maxLineWidth = 150;
        List lines = Minecraft.getInstance().font.split(textContents, maxLineWidth - 10);
        maxScrollAmount = lines.size();
        scrollAmount = Math.clamp((long)scrollAmount, 0, AbilityAndPenaltyTooltipRenderer.maxScroll());
        boolean skipFirstLine = !lines.isEmpty() && AbilityAndPenaltyTooltipRenderer.isEffectHeader((FormattedCharSequence)lines.getFirst());
        int backgroundWidth = Math.max(150, Minecraft.getInstance().font.width((FormattedText)name) + 65);
        List description = Minecraft.getInstance().font.split(rawDescription, backgroundWidth - 7);
        int backgroundHeight = 59 + description.size() * 9;
        int n = sideWidth = Screen.hasShiftDown() ? maxLineWidth : 15;
        int sideHeight = Screen.hasShiftDown() ? 36 + Math.min(skipFirstLine ? lines.size() - 1 : lines.size(), 15) * 9 : backgroundHeight - 10;
        AbilityTooltipPositioner positioner = new AbilityTooltipPositioner(Screen.hasShiftDown() ? sideWidth : 0);
        Vector2ic position = positioner.positionTooltip(graphics.guiWidth(), graphics.guiHeight(), x, y, maxLineWidth + 5, Math.max(sideHeight, backgroundHeight));
        int trueX = position.x();
        int trueY = position.y();
        if (!shiftInfo.isEmpty()) {
            graphics.blitWithBorder(BARS, trueX - (Screen.hasShiftDown() ? maxLineWidth : 10), trueY + 3, 40, 20, sideWidth, sideHeight, 20, 20, 3);
            graphics.blitWithBorder(BARS, trueX - (Screen.hasShiftDown() ? maxLineWidth : 10) + 3, trueY + 9, colorXPos, colorYPos, Screen.hasShiftDown() ? maxLineWidth : 15, 20, 20, 20, 3);
            if (Screen.hasShiftDown()) {
                graphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)LangKey.INFO), trueX - maxLineWidth + 10, trueY + 15, -1);
                int counter = 0;
                for (int line = scrollAmount; line < lines.size(); ++line) {
                    FormattedCharSequence text = (FormattedCharSequence)lines.get(line);
                    int startPosition = trueX - maxLineWidth + 5;
                    int textY = trueY + 5 + 28 + counter * 9;
                    if (line == 0 && skipFirstLine) continue;
                    if (AbilityAndPenaltyTooltipRenderer.isEffectHeader(text)) {
                        RenderingUtils.setShaderColor(DSColors.withAlpha(0xFFAA00, 1.0f));
                        graphics.blitSprite(EFFECT_HEADER, startPosition, textY - 4, maxLineWidth - 10, 9);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    } else {
                        graphics.drawString(Minecraft.getInstance().font, text, startPosition, textY, 0xAAAAAA);
                    }
                    if (++counter == 15) break;
                }
            }
        }
        graphics.blitWithBorder(BARS, trueX - 2, trueY - 4, 40, 20, backgroundWidth + 5, backgroundHeight, 20, 20, 3, 3, 3, 3);
        graphics.blitWithBorder(BARS, trueX, trueY + 3, colorXPos, colorYPos, backgroundWidth, 20, 20, 20, 3);
        graphics.blitWithBorder(BARS, trueX, trueY, 0, 100, 26, 26, 24, 24, 3);
        graphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)headerTranslationKey), trueX + backgroundWidth / 2, trueY + 30, tooltipBackgroundColor.getColor());
        if (maxLevel > 0) {
            graphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.empty().append(abilityLevel + "/" + maxLevel), trueX + backgroundWidth - 18, trueY + 9, -1);
            graphics.drawCenteredString(Minecraft.getInstance().font, name, trueX + backgroundWidth / 2, trueY + 9, -1);
        } else {
            graphics.drawCenteredString(Minecraft.getInstance().font, name, trueX + backgroundWidth / 2 + 10, trueY + 9, -1);
        }
        for (int line = 0; line < description.size(); ++line) {
            graphics.drawString(Minecraft.getInstance().font, (FormattedCharSequence)description.get(line), trueX + 5, trueY + 47 + line * 9, -5592406);
        }
        if (!shiftInfo.isEmpty()) {
            graphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)INFO_SHIFT).withStyle(ChatFormatting.DARK_GRAY), trueX + backgroundWidth / 2, trueY + 47 + (description.size() - 1) * 9, 0);
        }
        graphics.blitSprite(icon, trueX + 5, trueY + 5, 16, 16);
    }

    private static boolean isEffectHeader(FormattedCharSequence text) {
        StringBuilder builder = new StringBuilder();
        text.accept((charPosition, style, character) -> {
            builder.append(Character.toString(character));
            return true;
        });
        return builder.toString().equals("#HEADER#");
    }

    private static FormattedText formatText(List<Component> shiftInfo) {
        FormattedText textContents = null;
        for (Component component : shiftInfo) {
            if (textContents == null) {
                textContents = FormattedText.composite((FormattedText[])new FormattedText[]{component});
                continue;
            }
            textContents = FormattedText.composite((FormattedText[])new FormattedText[]{textContents, Component.literal((String)"\n")});
            textContents = FormattedText.composite((FormattedText[])new FormattedText[]{textContents, component});
        }
        if (textContents == null) {
            textContents = FormattedText.composite((FormattedText[])new FormattedText[]{Component.empty()});
        }
        return textContents;
    }

    public static void drawAbilityTooltip(@NotNull GuiGraphics guiGraphics, int x, int y, DragonAbilityInstance ability, int scrollAmount) {
        MutableComponent upgradeDescription;
        int colorXPos = 0;
        int colorYPos = !ability.isPassive() ? 20 : 0;
        MutableComponent abilityDescription = Component.translatable((String)Translation.Type.ABILITY_DESCRIPTION.wrap(ability.location()));
        MutableComponent rawDescription = !ability.isEnabled() && ability.isDisabled(true) ? Component.translatable((String)MANUALLY_DISABLED).append("\n\n").append((Component)abilityDescription) : abilityDescription;
        List<Component> info = ability.value().getInfo((Player)Minecraft.getInstance().player, ability);
        UpgradeType upgrade = ability.value().upgrade().orElse(null);
        if (upgrade != null && ability.level() < upgrade.maxLevel() && (upgradeDescription = upgrade.getDescription(ability.level() + 1)).getContents() != PlainTextContents.EMPTY) {
            rawDescription = FormattedText.composite((FormattedText[])new FormattedText[]{rawDescription, Component.empty().append("\n\n")});
            rawDescription = FormattedText.composite((FormattedText[])new FormattedText[]{rawDescription, upgradeDescription.withColor(Color.GREEN.getColor())});
        }
        if (!info.isEmpty()) {
            rawDescription = FormattedText.composite((FormattedText[])new FormattedText[]{rawDescription, Component.empty().append("\n\n")});
        }
        Color color = ability.isPassive() ? new Color(DSColors.withAlpha(8360238, 1.0f)) : new Color(DSColors.withAlpha(13141535, 1.0f));
        AbilityAndPenaltyTooltipRenderer.drawTooltip(guiGraphics, x, y, info, (FormattedText)rawDescription, colorXPos, colorYPos, ability.isPassive() ? LangKey.PASSIVE_ABILITY : LangKey.ACTIVE_ABILITY, ability.getName(), color, ability.getMaxLevel(), ability.level(), ability.getIcon(), scrollAmount);
    }

    public static void drawPenaltyTooltip(@NotNull GuiGraphics guiGraphics, int x, int y, Holder<DragonPenalty> penalty) {
        int colorXPos = 20;
        int colorYPos = 0;
        MutableComponent description = Component.translatable((String)Translation.Type.PENALTY_DESCRIPTION.wrap(penalty.getKey().location()));
        MutableComponent component = ((DragonPenalty)penalty.value()).getDescription((Player)Minecraft.getInstance().player);
        List<Object> components = component.getContents() == PlainTextContents.EMPTY ? List.of() : List.of(component);
        if (!components.isEmpty()) {
            description = FormattedText.composite((FormattedText[])new FormattedText[]{description, Component.empty().append("\n\n")});
        }
        MutableComponent name = Component.translatable((String)Translation.Type.PENALTY.wrap(penalty.getKey().location()));
        ResourceLocation icon = ((DragonPenalty)penalty.value()).icon().orElse(MissingTextureAtlasSprite.getLocation());
        AbilityAndPenaltyTooltipRenderer.drawTooltip(guiGraphics, x, y, components, (FormattedText)description, colorXPos, colorYPos, LangKey.PENALTY, (Component)name, Color.ofRGB((int)145, (int)46, (int)46), -1, -1, icon, 0);
    }
}

