/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins.client;

import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.HunterData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MovementData;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={InventoryScreen.class})
public abstract class InventoryScreenMixin
extends EffectRenderingInventoryScreen<InventoryMenu>
implements RecipeUpdateListener {
    @Unique
    private static float dragon_survival$storedXAngle = 0.0f;
    @Unique
    private static float dragon_survival$storedYAngle = 0.0f;

    public InventoryScreenMixin(InventoryMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
    }

    @WrapOperation(method={"renderEntityInInventory"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;runAsFancy(Ljava/lang/Runnable;)V")})
    private static void dragon_survival$dragonScreenEntityRender(Runnable runnable, Operation<Void> original, @Local(argsOnly=true) LivingEntity entity) {
        LivingEntity entityToRender = entity;
        DragonEntity dragon = null;
        if (entity instanceof DragonEntity) {
            dragon = (DragonEntity)entity;
            entityToRender = dragon.getPlayer();
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            dragon = ClientDragonRenderer.getDragon(player);
        }
        if (DragonStateProvider.isDragon((Entity)entityToRender)) {
            MovementData movement = MovementData.getData((Entity)entityToRender);
            double bodyYaw = movement.bodyYaw;
            double headYaw = movement.headYaw;
            double headPitch = movement.headPitch;
            Vec3 deltaMovement = movement.deltaMovement;
            Vec3 deltaMovementLastFrame = movement.deltaMovementLastFrame;
            movement.bodyYaw = entityToRender.yBodyRot;
            movement.headYaw = -Math.toDegrees(dragon_survival$storedXAngle);
            movement.headPitch = -Math.toDegrees(dragon_survival$storedYAngle);
            movement.deltaMovement = Vec3.ZERO;
            movement.deltaMovementLastFrame = Vec3.ZERO;
            if (dragon != null) {
                dragon.isInInventory = true;
            }
            RenderSystem.runAsFancy((Runnable)runnable);
            if (dragon != null) {
                dragon.isInInventory = false;
            }
            dragon_survival$storedXAngle = 0.0f;
            dragon_survival$storedYAngle = 0.0f;
            movement.bodyYaw = bodyYaw;
            movement.headYaw = headYaw;
            movement.headPitch = headPitch;
            movement.deltaMovement = deltaMovement;
            movement.deltaMovementLastFrame = deltaMovementLastFrame;
        } else {
            original.call(new Object[]{runnable});
        }
    }

    @ModifyArgs(method={"renderEntityInInventoryFollowsMouse"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/InventoryScreen;renderEntityInInventoryFollowsAngle(Lnet/minecraft/client/gui/GuiGraphics;IIIIIFFFLnet/minecraft/world/entity/LivingEntity;)V"))
    private static void dragon_survival$cancelEntityAnglingForDragons(Args args) {
        if (DragonStateProvider.isDragon((Entity)args.get(9))) {
            dragon_survival$storedXAngle = ((Float)args.get(7)).floatValue();
            dragon_survival$storedYAngle = ((Float)args.get(8)).floatValue();
            args.set(7, (Object)Float.valueOf(0.0f));
            args.set(8, (Object)Float.valueOf(0.0f));
        }
    }

    @Inject(method={"renderEntityInInventory"}, at={@At(value="HEAD")})
    private static void dragonSurvival$setFlag(GuiGraphics graphics, float x, float y, float scale, Vector3f translate, Quaternionf pose, Quaternionf cameraOrientation, LivingEntity entity, CallbackInfo callback) {
        if (entity instanceof DragonEntity) {
            DragonEntity dragon = (DragonEntity)entity;
            Player player = dragon.getPlayer();
            if (player != null) {
                player.getExistingData(DSDataAttachments.HUNTER).ifPresent(HunterData::disableTransparency);
            }
        } else {
            entity.getExistingData(DSDataAttachments.HUNTER).ifPresent(HunterData::disableTransparency);
        }
    }

    @Inject(method={"renderEntityInInventory"}, at={@At(value="RETURN")})
    private static void dragonSurvival$clearFlag(GuiGraphics graphics, float x, float y, float scale, Vector3f translate, Quaternionf pose, Quaternionf cameraOrientation, LivingEntity entity, CallbackInfo callback) {
        if (entity instanceof DragonEntity) {
            DragonEntity dragon = (DragonEntity)entity;
            Player player = dragon.getPlayer();
            if (player != null) {
                player.getExistingData(DSDataAttachments.HUNTER).ifPresent(HunterData::enableTransparency);
            }
        } else {
            entity.getExistingData(DSDataAttachments.HUNTER).ifPresent(HunterData::enableTransparency);
        }
    }
}

