/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.magic;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.network.animation.StopAbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.network.sound.StopTickingSound;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SyncStopCast(int playerId, Optional<ResourceKey<DragonAbility>> ability) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncStopCast> TYPE = new CustomPacketPayload.Type(DragonSurvival.res("sync_stop_cast"));
    public static final StreamCodec<FriendlyByteBuf, SyncStopCast> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SyncStopCast::playerId, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceKey.streamCodec(DragonAbility.REGISTRY)), SyncStopCast::ability, SyncStopCast::new);

    public static void handleClient(SyncStopCast packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp = context.player().level().getEntity(packet.playerId());
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                MagicData magic = MagicData.getData(player);
                packet.ability().ifPresentOrElse(ability -> magic.stopCasting(player, magic.getAbility((ResourceKey<DragonAbility>)ability)), () -> magic.stopCasting(player));
            }
        });
    }

    public static void handleServer(Player player, @Nullable ResourceKey<DragonAbility> ability) {
        MagicData data = MagicData.getData(player);
        DragonAbilityInstance abilityInstance = ability == null ? data.getCurrentlyCasting() : data.getAbility(ability);
        if (abilityInstance == null) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)player, (CustomPacketPayload)new StopTickingSound(abilityInstance.location().withSuffix(player.getStringUUID())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (!abilityInstance.isApplyingEffects() || abilityInstance.isApplyingEffects() && !abilityInstance.hasEndAnimation()) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)player, (CustomPacketPayload)new StopAbilityAnimation(player.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (ability == null) {
            data.stopCasting(player);
        } else {
            data.stopCasting(player, data.getAbility(ability));
        }
    }

    public static void handleServer(SyncStopCast packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity patt0$temp = context.player().level().getEntity(packet.playerId());
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                packet.ability().ifPresentOrElse(ability -> SyncStopCast.handleServer(player, (ResourceKey<DragonAbility>)ability), () -> SyncStopCast.handleServer(player, null));
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

