/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.network.player.SyncPitchAndYaw;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public class MovementData
implements INBTSerializable<CompoundTag> {
    public static final String HEAD_YAW = "headYaw";
    public static final String HEAD_PITCH = "headPitch";
    public static final String BODY_YAW = "bodyYaw";
    public static final double INPUT_EPSILON = 1.0E-7;
    public double headYaw = 0.0;
    public double headPitch = 0.0;
    public double bodyYaw = 0.0;
    public Vec3 deltaMovement = Vec3.ZERO;
    public double headYawLastFrame = 0.0;
    public double headPitchLastFrame = 0.0;
    public double bodyYawLastFrame = 0.0;
    public Vec3 deltaMovementLastFrame = Vec3.ZERO;
    public float prevXRot = 0.0f;
    public float prevZRot = 0.0f;
    public Vec3 desiredMoveVec = Vec3.ZERO;
    public boolean isFirstPerson;
    public boolean isFreeLook;
    public boolean bite;
    public boolean dig;

    public boolean isMoving() {
        return this.desiredMoveVec.lengthSqr() > 9.999999999999998E-15;
    }

    public boolean isMovingHorizontally() {
        return this.desiredMoveVec.x * this.desiredMoveVec.x + this.desiredMoveVec.z * this.desiredMoveVec.z > 9.999999999999998E-15;
    }

    public void setFreeLook(boolean isFreeLook) {
        this.isFreeLook = isFreeLook;
    }

    public void setFirstPerson(boolean isFirstPerson) {
        this.isFirstPerson = isFirstPerson;
    }

    public void setBite(boolean bite) {
        this.bite = bite;
    }

    public void setDig(boolean dig) {
        this.dig = dig;
    }

    public void setDesiredMoveVec(Vec3 desiredMoveVec) {
        this.desiredMoveVec = desiredMoveVec;
    }

    public void set(double bodyYaw, double headYaw, double headPitch, Vec3 deltaMovement) {
        this.headYawLastFrame = this.headYaw;
        this.bodyYawLastFrame = this.bodyYaw;
        this.headPitchLastFrame = this.headPitch;
        this.deltaMovementLastFrame = this.deltaMovement;
        this.bodyYaw = bodyYaw;
        this.headYaw = headYaw;
        this.headPitch = headPitch;
        this.deltaMovement = deltaMovement;
    }

    public static MovementData getData(Entity entity) {
        return (MovementData)entity.getData(DSDataAttachments.MOVEMENT);
    }

    public void sync(ServerPlayer player) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SyncPitchAndYaw(player.getId(), this.headYaw, this.headPitch, this.bodyYaw), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sync(ServerPlayer source, ServerPlayer target) {
        PacketDistributor.sendToPlayer((ServerPlayer)target, (CustomPacketPayload)new SyncPitchAndYaw(source.getId(), this.headYaw, this.headPitch, this.bodyYaw), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public @UnknownNullability CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag movementData = new CompoundTag();
        movementData.putDouble(HEAD_YAW, this.headYaw);
        movementData.putDouble(BODY_YAW, this.bodyYaw);
        movementData.putDouble(HEAD_PITCH, this.headPitch);
        return movementData;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
        this.headYaw = nbt.getDouble(HEAD_YAW);
        this.bodyYaw = nbt.getDouble(BODY_YAW);
        this.headPitch = nbt.getDouble(HEAD_PITCH);
    }
}

