/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.SummonedEntities;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SummonData
implements INBTSerializable<CompoundTag> {
    public static final Codec<SummonData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.optionalFieldOf("owner_uuid").forGetter(data -> Optional.ofNullable(data.ownerUUID)), (App)Codec.BOOL.optionalFieldOf("is_allied", (Object)false).forGetter(data -> data.isAllied), (App)SummonedEntities.AttackBehaviour.CODEC.optionalFieldOf("attack_behaviour", (Object)SummonedEntities.AttackBehaviour.DEFENSIVE).forGetter(data -> data.attackBehaviour), (App)SummonedEntities.MovementBehaviour.CODEC.optionalFieldOf("movement_behaviour", (Object)SummonedEntities.MovementBehaviour.FOLLOW).forGetter(data -> data.movementBehaviour)).apply((Applicative)instance, SummonData::new));
    private static final String DATA = "data";
    public boolean isAllied;
    public SummonedEntities.AttackBehaviour attackBehaviour;
    public SummonedEntities.MovementBehaviour movementBehaviour;
    private UUID ownerUUID;
    private LivingEntity summonOwner;

    public SummonData() {
    }

    public SummonData(Optional<UUID> ownerUUID, boolean isAllied, SummonedEntities.AttackBehaviour attackBehaviour, SummonedEntities.MovementBehaviour movementBehaviour) {
        this.ownerUUID = ownerUUID.orElse(null);
        this.isAllied = isAllied;
        this.attackBehaviour = attackBehaviour;
        this.movementBehaviour = movementBehaviour;
    }

    @Nullable
    public LivingEntity getOwner(Level level) {
        ServerLevel serverLevel;
        Player player;
        if (this.ownerUUID == null) {
            return null;
        }
        if (this.summonOwner != null && this.summonOwner.isAlive()) {
            return this.summonOwner;
        }
        if (level instanceof ServerLevel && (player = (serverLevel = (ServerLevel)level).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            LivingEntity livingEntity;
            this.summonOwner = livingEntity = (LivingEntity)player;
        } else {
            player = level.getPlayerByUUID(this.ownerUUID);
            if (player instanceof LivingEntity) {
                Player livingEntity = player;
                this.summonOwner = livingEntity;
            } else {
                this.summonOwner = null;
            }
        }
        return this.summonOwner;
    }

    public void setOwnerUUID(@Nullable LivingEntity owner) {
        this.summonOwner = owner;
        this.ownerUUID = owner == null ? null : owner.getUUID();
    }

    public boolean isOwner(Entity entity) {
        return this.ownerUUID != null && this.ownerUUID.equals(entity.getUUID());
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).ifPresent(compound -> tag.put(DATA, compound));
        return tag;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound(DATA)).resultOrPartial(arg_0 -> ((Logger)DragonSurvival.LOGGER).error(arg_0)).ifPresent(data -> {
            this.ownerUUID = ((SummonData)data.getFirst()).ownerUUID;
            this.attackBehaviour = ((SummonData)data.getFirst()).attackBehaviour;
            this.movementBehaviour = ((SummonData)data.getFirst()).movementBehaviour;
        });
    }
}

