/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.attachments;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.OxygenBonus;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncSwimDataEntry;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class SwimData {
    public static final int UNLIMITED_OXYGEN = -1;
    public FluidType previousFluid;
    private final Map<ResourceKey<FluidType>, Integer> swimData = new HashMap<ResourceKey<FluidType>, Integer>();

    public Integer add(int maxOxygen, Holder<FluidType> fluid) {
        return this.swimData.put((ResourceKey<FluidType>)fluid.getKey(), maxOxygen);
    }

    public void remove(Holder<FluidType> fluid) {
        this.swimData.remove(fluid.getKey());
    }

    public int getMaxOxygen(Player player, FluidType fluid) {
        ResourceKey<FluidType> key = SwimData.key(fluid);
        float base = key == NeoForgeMod.EMPTY_TYPE.getKey() ? (float)this.getMaxOxygen(player, this.previousFluid) : (float)this.swimData.getOrDefault(key, 300).intValue();
        if (base == -1.0f) {
            return -1;
        }
        float bonus = player.getExistingData(DSDataAttachments.OXYGEN_BONUSES).map(data -> Float.valueOf(data.getBonus(key))).orElse(Float.valueOf(OxygenBonus.NONE)).floatValue();
        if (bonus == -1.0f) {
            return -1;
        }
        return Math.max(0, (int)(base + bonus));
    }

    public boolean canSwimIn(FluidType fluid) {
        return this.canSwimIn(SwimData.key(fluid));
    }

    public boolean canSwimIn(ResourceKey<FluidType> fluid) {
        return this.swimData.containsKey(fluid);
    }

    public void sync(ServerPlayer player) {
        this.swimData.forEach((fluid, oxygen) -> PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncSwimDataEntry((int)oxygen, (Holder<FluidType>)player.registryAccess().holderOrThrow(fluid), false), (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    public static SwimData getData(Player player) {
        return (SwimData)player.getData(DSDataAttachments.SWIM);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleOxygen(LivingBreatheEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            FluidType currentFluid = player.getEyeInFluidType();
            SwimData data = SwimData.getData(player);
            if (event.canBreathe()) {
                if (data.canSwimIn(currentFluid)) {
                    event.setRefillAirAmount(data.getMaxOxygen(player, currentFluid));
                } else if (SwimData.isAir(currentFluid) && data.previousFluid != null) {
                    event.setRefillAirAmount((int)((double)data.getMaxOxygen(player, data.previousFluid) * 0.015));
                }
            }
            if (!SwimData.isAir(currentFluid) && data.previousFluid != currentFluid) {
                int maxAirSupply = data.getMaxOxygen(player, data.previousFluid);
                int newMaxAirSupply = data.getMaxOxygen(player, player.getEyeInFluidType());
                float airSupplyRatio = (float)newMaxAirSupply / (float)maxAirSupply;
                player.setAirSupply((int)Math.min((double)newMaxAirSupply, Math.ceil((float)player.getAirSupply() * airSupplyRatio)));
                data.previousFluid = currentFluid;
            }
        }
    }

    public static boolean isAir(FluidType fluid) {
        return SwimData.key(fluid) == NeoForgeMod.EMPTY_TYPE.getKey();
    }

    @Nullable
    public static ResourceLocation getAirSprite(FluidType fluid) {
        ResourceLocation resource = NeoForgeRegistries.FLUID_TYPES.getKey((Object)fluid);
        if (resource == null) {
            return null;
        }
        return DragonSurvival.res("air_meters/" + resource.getPath());
    }

    public static ResourceLocation getAirBurstSprite(FluidType fluid) {
        ResourceLocation resource = NeoForgeRegistries.FLUID_TYPES.getKey((Object)fluid);
        if (resource == null) {
            return null;
        }
        return DragonSurvival.res("air_meters/" + resource.getPath() + "_burst");
    }

    @Nullable
    public static ResourceKey<FluidType> key(FluidType fluid) {
        return NeoForgeRegistries.FLUID_TYPES.getResourceKey((Object)fluid).orElse(null);
    }
}

