/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.data_maps;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.DietEntry;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDataMaps;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.DragonSpecies;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.datamaps.DataMapsUpdatedEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class DietEntryCache {
    private static final Map<ResourceKey<DragonSpecies>, Map<Item, FoodProperties>> CACHE = new HashMap<ResourceKey<DragonSpecies>, Map<Item, FoodProperties>>();

    @SubscribeEvent
    public static void buildCache(DataMapsUpdatedEvent event) {
        event.ifRegistry(DragonSpecies.REGISTRY, registry -> registry.getDataMap(DSDataMaps.DIET_ENTRIES).forEach((key, diet) -> CACHE.put((ResourceKey<DragonSpecies>)key, DietEntry.map(diet == null ? List.of() : diet))));
    }

    public static boolean isEmpty(Holder<DragonSpecies> species) {
        return CACHE.computeIfAbsent((ResourceKey<DragonSpecies>)species.getKey(), key -> DietEntryCache.generate(species)).isEmpty();
    }

    @Nullable
    public static FoodProperties getDiet(Holder<DragonSpecies> species, Item item) {
        return (FoodProperties)CACHE.computeIfAbsent((ResourceKey<DragonSpecies>)species.getKey(), key -> DietEntryCache.generate(species)).get(item);
    }

    public static List<Item> getDietItems(Holder<DragonSpecies> species) {
        return List.copyOf(CACHE.computeIfAbsent((ResourceKey<DragonSpecies>)species.getKey(), key -> DietEntryCache.generate(species)).keySet());
    }

    private static Map<Item, FoodProperties> generate(Holder<DragonSpecies> species) {
        List diet = (List)species.getData(DSDataMaps.DIET_ENTRIES);
        return DietEntry.map(diet == null ? List.of() : diet);
    }
}

