/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.Modifier;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ModifierType;
import by.dragonsurvivalteam.dragonsurvival.mixins.AttributeMapAccessor;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.Nullable;

public interface AttributeModifierSupplier {
    public static void removeModifiers(ModifierType type, LivingEntity entity) {
        if (type == ModifierType.CUSTOM) {
            Functions.logOrThrow("Modifiers of the type " + ModifierType.CUSTOM.name() + " need to be handled using the stored ids");
            return;
        }
        ((AttributeMapAccessor)entity.getAttributes()).dragonSurvival$getAttributes().values().forEach(instance -> instance.getModifiers().forEach(modifier -> {
            if (modifier.id().getPath().startsWith(type.path())) {
                instance.removeModifier(modifier);
            }
        }));
    }

    default public List<AttributeModifier> filterModifiers(AttributeInstance instance) {
        ArrayList<AttributeModifier> modifiers = new ArrayList<AttributeModifier>();
        if (this.getModifierType() == ModifierType.CUSTOM) {
            List ids = this.getStoredIds().getOrDefault(instance.getAttribute(), List.of());
            for (AttributeModifier modifier : instance.getModifiers()) {
                if (ids.contains(modifier.id())) continue;
                modifiers.add(modifier);
            }
        } else {
            for (AttributeModifier modifier : instance.getModifiers()) {
                if (modifier.id().getPath().startsWith(this.getModifierType().path())) continue;
                modifiers.add(modifier);
            }
        }
        return modifiers;
    }

    default public void applyModifiers(LivingEntity entity) {
        this.applyModifiers(entity, 1.0);
    }

    default public void applyModifiers(LivingEntity entity, double level) {
        this.modifiers().forEach(modifier -> {
            AttributeInstance instance = entity.getAttribute(modifier.attribute());
            this.applyModifier((Modifier)modifier, instance, level, entity.getRandom());
        });
    }

    default public void removeModifiers(LivingEntity entity) {
        if (this.getModifierType() != ModifierType.CUSTOM) {
            AttributeModifierSupplier.removeModifiers(this.getModifierType(), entity);
            return;
        }
        Map<Holder<Attribute>, List<ResourceLocation>> ids = this.getStoredIds();
        ids.forEach((attribute, modifiers) -> {
            AttributeInstance instance = entity.getAttribute(attribute);
            if (instance != null) {
                modifiers.forEach(arg_0 -> ((AttributeInstance)instance).removeModifier(arg_0));
            }
        });
        ids.clear();
    }

    private void applyModifier(Modifier modifier, @Nullable AttributeInstance instance, double level, RandomSource random) {
        ResourceLocation id;
        if (instance == null) {
            return;
        }
        ModifierType type = this.getModifierType();
        while (instance.hasModifier(id = type.randomId(modifier.attribute(), modifier.operation(), random))) {
        }
        AttributeModifier attributeModifier = modifier.getModifier(id, level);
        instance.addPermanentModifier(attributeModifier);
        this.storeId((Holder<Attribute>)instance.getAttribute(), attributeModifier.id());
    }

    default public void storeId(Holder<Attribute> attribute, ResourceLocation id) {
    }

    default public Map<Holder<Attribute>, List<ResourceLocation>> getStoredIds() {
        return Collections.emptyMap();
    }

    default public List<Modifier> modifiers() {
        return List.of();
    }

    public ModifierType getModifierType();
}

