/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.ManaCost;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.AbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.AnimationType;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.CompoundAbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.SimpleAbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.network.animation.SyncAbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.network.sound.StartTickingSound;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Animations;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.ChanneledActivation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Notification;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.PassiveActivation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.SimpleActivation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Sound;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public interface Activation {
    public static final ResourceKey<Registry<MapCodec<? extends Activation>>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)DragonSurvival.res("activation"));
    public static final Registry<MapCodec<? extends Activation>> REGISTRY = new RegistryBuilder(REGISTRY_KEY).create();
    public static final Codec<Activation> CODEC = REGISTRY.byNameCodec().dispatch("activation_type", Activation::codec, Function.identity());

    @SubscribeEvent
    public static void register(NewRegistryEvent event) {
        event.register(REGISTRY);
    }

    @SubscribeEvent
    public static void registerEntries(RegisterEvent event) {
        if (event.getRegistry() == REGISTRY) {
            event.register(REGISTRY_KEY, DragonSurvival.res("passive"), () -> PassiveActivation.CODEC);
            event.register(REGISTRY_KEY, DragonSurvival.res("simple"), () -> SimpleActivation.CODEC);
            event.register(REGISTRY_KEY, DragonSurvival.res("channeled"), () -> ChanneledActivation.CODEC);
        }
    }

    public Type type();

    public MapCodec<? extends Activation> codec();

    default public float getInitialManaCost(int level) {
        return 0.0f;
    }

    default public Optional<ManaCost> continuousManaCost() {
        return Optional.empty();
    }

    default public int getCastTime(int level) {
        return 0;
    }

    default public int getCooldown(int level) {
        return 0;
    }

    default public Notification notification() {
        return Notification.NONE;
    }

    default public boolean canMoveWhileCasting() {
        return true;
    }

    default public Optional<Sound> sound() {
        return Optional.empty();
    }

    default public Optional<Animations> animations() {
        return Optional.empty();
    }

    default public void playStartAndLoopingSound(Player dragon, DragonAbilityInstance instance) {
        this.sound().flatMap(Sound::start).ifPresent(start -> {
            if (dragon.level().isClientSide()) {
                DragonSurvival.PROXY.playSoundAtEyeLevel(dragon, (SoundEvent)start);
            } else {
                dragon.level().playSound(dragon, dragon.blockPosition(), start, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        });
        this.sound().flatMap(Sound::looping).ifPresent(looping -> {
            if (dragon.level().isClientSide()) {
                instance.queueTickingSound((SoundEvent)looping, SoundSource.PLAYERS, dragon);
            } else {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)dragon, (CustomPacketPayload)new StartTickingSound(dragon.getId(), (SoundEvent)looping, instance.location().withSuffix(dragon.getStringUUID())), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    default public void playChargingSound(Player dragon, DragonAbilityInstance instance) {
        this.sound().flatMap(Sound::charging).ifPresent(charging -> {
            if (dragon.level().isClientSide()) {
                instance.queueTickingSound((SoundEvent)charging, SoundSource.PLAYERS, dragon);
            } else {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)dragon, (CustomPacketPayload)new StartTickingSound(dragon.getId(), (SoundEvent)charging, instance.location().withSuffix(dragon.getStringUUID())), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    default public void playEndSound(Player dragon) {
        this.sound().flatMap(Sound::end).ifPresent(end -> {
            if (dragon.level().isClientSide()) {
                DragonSurvival.PROXY.playSoundAtEyeLevel(dragon, (SoundEvent)end);
            } else {
                dragon.level().playSound(dragon, dragon.blockPosition(), end, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        });
    }

    default public void playStartAndChargingAnimation(Player dragon) {
        this.animations().flatMap(Animations::startAndCharging).ifPresent(startAndCharging -> {
            if (dragon.level().isClientSide()) {
                AbilityAnimation abilityAnimation = (AbilityAnimation)startAndCharging.map(simple -> simple, compound -> compound);
                DragonSurvival.PROXY.setCurrentAbilityAnimation(dragon, (Pair<AbilityAnimation, AnimationType>)new Pair((Object)abilityAnimation, (Object)AnimationType.LOOPING));
            } else {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)dragon, (CustomPacketPayload)new SyncAbilityAnimation(dragon.getId(), AnimationType.LOOPING, (Either<CompoundAbilityAnimation, SimpleAbilityAnimation>)startAndCharging), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    default public void playLoopingAnimation(Player dragon) {
        this.animations().flatMap(Animations::looping).ifPresent(looping -> {
            if (dragon.level().isClientSide()) {
                DragonSurvival.PROXY.setCurrentAbilityAnimation(dragon, (Pair<AbilityAnimation, AnimationType>)new Pair(looping, (Object)AnimationType.LOOPING));
            } else {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)dragon, (CustomPacketPayload)new SyncAbilityAnimation(dragon.getId(), AnimationType.LOOPING, (Either<CompoundAbilityAnimation, SimpleAbilityAnimation>)Either.right((Object)looping)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    default public void playEndAnimation(Player dragon) {
        this.animations().flatMap(Animations::end).ifPresent(end -> {
            if (dragon.level().isClientSide()) {
                DragonSurvival.PROXY.setCurrentAbilityAnimation(dragon, (Pair<AbilityAnimation, AnimationType>)new Pair(end, (Object)AnimationType.PLAY_ONCE));
            } else {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)dragon, (CustomPacketPayload)new SyncAbilityAnimation(dragon.getId(), AnimationType.PLAY_ONCE, (Either<CompoundAbilityAnimation, SimpleAbilityAnimation>)Either.right((Object)end)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    public static enum Type implements StringRepresentable
    {
        PASSIVE("passive"),
        SIMPLE("simple"),
        CHANNELED("channeled");

        public static final Codec<Type> CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }
}

