/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.trigger;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Condition;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.trigger.ActivationTrigger;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public record OnTargetKilled(Optional<LootItemCondition> condition) implements ActivationTrigger
{
    public static final MapCodec<OnTargetKilled> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LootItemCondition.DIRECT_CODEC.optionalFieldOf("condition").forGetter(OnTargetKilled::condition)).apply((Applicative)instance, OnTargetKilled::new));

    public static void trigger(LivingEntity entity, DamageSource source) {
        Entity entity2 = source.getEntity();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            DragonStateHandler handler = DragonStateProvider.getData((Player)player);
            if (!handler.isDragon()) {
                return;
            }
            LootContext context = Condition.damageContext(player.serverLevel(), (Entity)entity, source, null);
            MagicData.getData((Player)player).filterPassiveByTrigger(trigger -> trigger.type() == ActivationTrigger.TriggerType.ON_TARGET_KILLED && trigger.test(context)).forEach(ability -> ability.tick((Player)player));
        }
    }

    @Override
    public boolean test(LootContext context) {
        return this.condition.map(condition -> condition.test((Object)context)).orElse(true);
    }

    @Override
    public ActivationTrigger.TriggerType type() {
        return ActivationTrigger.TriggerType.ON_TARGET_KILLED;
    }

    @Override
    public MapCodec<? extends ActivationTrigger> codec() {
        return CODEC;
    }
}

