/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.block_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.block_effects.AbilityBlockEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import org.jetbrains.annotations.NotNull;

public record BlockConversionEffect(List<BlockConversionData> blockConversions, LevelBasedValue probability) implements AbilityBlockEffect
{
    public static final MapCodec<BlockConversionEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockConversionData.CODEC.listOf().fieldOf("conversion_data").forGetter(BlockConversionEffect::blockConversions), (App)LevelBasedValue.CODEC.fieldOf("probability").forGetter(BlockConversionEffect::probability)).apply((Applicative)instance, BlockConversionEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, BlockPos position, Direction direction) {
        if (dragon.getRandom().nextDouble() > (double)this.probability.calculate(ability.level())) {
            return;
        }
        for (BlockConversionData data : this.blockConversions) {
            if (!data.fromPredicate().test((Object)dragon.serverLevel(), (Object)position)) continue;
            data.blocksTo().getRandom(dragon.getRandom()).ifPresent(conversion -> dragon.serverLevel().setBlock(position, conversion.state(), 3));
        }
    }

    @Override
    public MapCodec<? extends AbilityBlockEffect> blockCodec() {
        return CODEC;
    }

    public record BlockConversionData(BlockPredicate fromPredicate, WeightedRandomList<BlockTo> blocksTo) {
        public static final Codec<BlockConversionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPredicate.CODEC.fieldOf("from_predicate").forGetter(BlockConversionData::fromPredicate), (App)SimpleWeightedRandomList.codec(BlockTo.CODEC).fieldOf("blocks_to").forGetter(BlockConversionData::blocksTo)).apply((Applicative)instance, BlockConversionData::new));
    }

    public record BlockTo(BlockState state, int weight) implements WeightedEntry
    {
        public static final Codec<BlockTo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.CODEC.fieldOf("state").forGetter(BlockTo::state), (App)Codec.INT.fieldOf("weight").forGetter(BlockTo::weight)).apply((Applicative)instance, BlockTo::new));

        @NotNull
        public Weight getWeight() {
            return Weight.of((int)this.weight);
        }
    }
}

