/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.network.particle.SyncBreathParticles;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public record BreathParticlesEffect(float spread, float speedPerGrowth, ParticleOptions mainParticle, ParticleOptions secondaryParticle) implements AbilityEntityEffect
{
    private static final int DEFAULT_PARTICLE_COUNT = 20;
    public static final MapCodec<BreathParticlesEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("spread").forGetter(BreathParticlesEffect::spread), (App)Codec.FLOAT.fieldOf("speed_per_growth").forGetter(BreathParticlesEffect::speedPerGrowth), (App)ParticleTypes.CODEC.fieldOf("main_particle").forGetter(BreathParticlesEffect::mainParticle), (App)ParticleTypes.CODEC.fieldOf("secondary_particle").forGetter(BreathParticlesEffect::secondaryParticle)).apply((Applicative)instance, BreathParticlesEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        Player player;
        DragonStateHandler handler;
        double particleAmount = target instanceof Player ? ((handler = DragonStateProvider.getData(player = (Player)target)).isDragon() ? handler.getGrowth() : 20.0) : 20.0;
        particleAmount = Mth.clamp((double)(particleAmount * 0.6), (double)12.0, (double)100.0);
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)target, (CustomPacketPayload)new SyncBreathParticles(target.getId(), this.spread, this.speedPerGrowth, (int)particleAmount, this.mainParticle, this.secondaryParticle), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

