/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.AbilityTargeting;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record DiscTarget(Either<AbilityTargeting.BlockTargeting, AbilityTargeting.EntityTargeting> target, LevelBasedValue radius, LevelBasedValue height, boolean heightStartsBelow) implements AbilityTargeting
{
    @Translation(comments={"Targets a disc around you (radius: %s / height: %s)"})
    private static final String DISC_TARGET_BLOCK = Translation.Type.GUI.wrap("ability_target.disc_target.block");
    @Translation(comments={"Targets %s in a disc around you (radius: %s / height: %s)"})
    public static final String DISC_TARGET_ENTITY = Translation.Type.GUI.wrap("ability_target.disc_target.entity");
    public static final MapCodec<DiscTarget> CODEC = RecordCodecBuilder.mapCodec(instance -> AbilityTargeting.codecStart(instance).and((App)LevelBasedValue.CODEC.fieldOf("radius").forGetter(DiscTarget::radius)).and((App)LevelBasedValue.CODEC.optionalFieldOf("height", (Object)LevelBasedValue.constant((float)1.0f)).forGetter(DiscTarget::height)).and((App)Codec.BOOL.optionalFieldOf("height_starts_below", (Object)false).forGetter(DiscTarget::heightStartsBelow)).apply((Applicative)instance, DiscTarget::new));

    @Override
    public MutableComponent getDescription(Player dragon, DragonAbilityInstance ability) {
        Component targetingComponent = (Component)this.target.map(block -> null, entity -> entity.targetingMode().translation());
        MutableComponent radius = DSColors.dynamicValue((int)this.radius.calculate(ability.level()));
        MutableComponent height = DSColors.dynamicValue((int)this.height.calculate(ability.level()));
        if (targetingComponent == null) {
            return Component.translatable((String)DISC_TARGET_BLOCK, (Object[])new Object[]{radius, height});
        }
        return Component.translatable((String)DISC_TARGET_ENTITY, (Object[])new Object[]{DSColors.dynamicValue(targetingComponent), radius, height});
    }

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability) {
        int radius = (int)this.radius.calculate(ability.level());
        int height = (int)this.height.calculate(ability.level());
        this.target.ifLeft(blockTarget -> BlockPos.betweenClosedStream((AABB)this.calculateAffectedArea(dragon.position(), radius, height)).forEach(position -> {
            if (blockTarget.matches(dragon, (BlockPos)position)) {
                blockTarget.effects().forEach(target -> target.apply(dragon, ability, (BlockPos)position, null));
            }
        })).ifRight(entityTarget -> dragon.serverLevel().getEntities(EntityTypeTest.forClass(Entity.class), this.calculateAffectedArea(dragon.position(), radius, height), entity -> entityTarget.targetingMode().isEntityRelevant((Player)dragon, (Entity)entity) && entityTarget.matches(dragon, (Entity)entity, entity.position())).forEach(entity -> entityTarget.effects().forEach(target -> target.apply(dragon, ability, (Entity)entity))));
    }

    public AABB calculateAffectedArea(Vec3 origin, int radius, int height) {
        return new AABB(origin.subtract((double)radius, this.heightStartsBelow ? 1.0 : 0.0, (double)radius), origin.add((double)radius, this.heightStartsBelow ? (double)(height - 1) : (double)height, (double)radius));
    }

    @Override
    public MapCodec<? extends AbilityTargeting> codec() {
        return CODEC;
    }
}

